/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.testpolicymgmt;

import com.netegrity.sdk.apiutil.SmApiConnection;
import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.apiutil.SmApiSession;
import com.netegrity.sdk.policyapi.SmPolicyApiImpl;
import com.netegrity.sdk.policyapi.SmUserContext;
import com.netegrity.sdk.policyapi.SmUserDirectory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Vector;
import netegrity.siteminder.javaagent.AgentAPI;
import netegrity.siteminder.javaagent.InitDef;
import netegrity.siteminder.javaagent.ServerDef;

public class PolicyApiTestUser {
    public static void main(String[] stringArray) {
        String string;
        Object object;
        Object object2;
        Object object3;
        SmUserDirectory smUserDirectory;
        SmApiResult smApiResult;
        PolicyApiTestUser policyApiTestUser = new PolicyApiTestUser();
        AgentAPI agentAPI = new AgentAPI();
        ServerDef serverDef = new ServerDef();
        serverDef.serverIpAddress = "localhost";
        serverDef.connectionMin = 1;
        serverDef.connectionMax = 1;
        serverDef.connectionStep = 1;
        serverDef.timeout = 600;
        serverDef.authenticationPort = 44442;
        serverDef.authorizationPort = 44443;
        serverDef.accountingPort = 44444;
        InitDef initDef = new InitDef("test", "test", false, serverDef);
        int n = agentAPI.init(initDef);
        if (n != 0) {
            PolicyApiTestUser.LogFatal("Failed to connect");
        }
        PolicyApiTestUser.Log("\nCreate API session.");
        SmApiSession smApiSession = new SmApiSession(new SmApiConnection(agentAPI));
        try {
            smApiResult = smApiSession.login("SiteMinder", "test", InetAddress.getLocalHost(), 0);
            if (!smApiResult.isSuccess()) {
                PolicyApiTestUser.LogFatal("Failed to create API session.");
            }
        }
        catch (UnknownHostException unknownHostException) {
            PolicyApiTestUser.LogFatal("Failed to create API session." + unknownHostException);
        }
        catch (SmApiException smApiException) {
            PolicyApiTestUser.LogFatal("Failed to create API session." + (Object)((Object)smApiException));
        }
        smApiResult = new SmPolicyApiImpl(smApiSession);
        String string2 = null;
        try {
            smUserDirectory = new Hashtable();
            object3 = smApiResult.lookupDirectory("test", "uid=user1", smUserDirectory);
            if (!object3.isSuccess()) {
                PolicyApiTestUser.LogFatal("Failed to lookup user.");
            }
            string2 = smUserDirectory.keys().nextElement().toString();
        }
        catch (Exception exception) {
            PolicyApiTestUser.LogFatal("Failed to lookup user - " + exception);
        }
        PolicyApiTestUser.Log("\nUser lookup: " + string2);
        smUserDirectory = new SmUserDirectory();
        try {
            object3 = smApiResult.getUserDirectory("test", smUserDirectory);
            if (!object3.isSuccess()) {
                PolicyApiTestUser.LogFatal("Failed to get user directory.");
            }
        }
        catch (Exception exception) {
            PolicyApiTestUser.LogFatal("Failed to get user directory - " + exception);
        }
        PolicyApiTestUser.Log("\nGet user groups.");
        object3 = new Vector();
        try {
            object2 = smApiResult.getUserGroups(smUserDirectory.getOid(), string2, true, (Vector)object3);
            if (!object2.isSuccess()) {
                PolicyApiTestUser.LogFatal("Failed to get user groups.");
            }
        }
        catch (Exception exception) {
            PolicyApiTestUser.LogFatal("Failed to get user groups - " + exception);
        }
        object2 = ((Vector)object3).elements();
        while (object2.hasMoreElements()) {
            PolicyApiTestUser.Log("\n[" + object2.nextElement() + "]");
        }
        PolicyApiTestUser.Log("\nGet user context.");
        SmUserContext smUserContext = new SmUserContext();
        try {
            object = smApiResult.getUserContext(smUserDirectory.getOid(), string2, null, smUserContext);
            if (!object.isSuccess()) {
                PolicyApiTestUser.LogFatal("Failed to get user groups.");
            }
        }
        catch (Exception exception) {
            PolicyApiTestUser.LogFatal("Failed to get user groups - " + exception);
        }
        PolicyApiTestUser.Log("\nGet user prop.");
        try {
            object = "telephoneNumber";
            string = smUserContext.getProp((String)object);
            if (string == null) {
                PolicyApiTestUser.LogFatal("Failed to get user prop.");
            } else {
                PolicyApiTestUser.Log((String)object + " = " + string);
            }
            PolicyApiTestUser.Log("\nSet user prop.");
            boolean bl = smUserContext.setProp((String)object, string + "9999");
            if (bl) {
                String string3 = smUserContext.getProp((String)object);
                PolicyApiTestUser.Log("\n" + (String)object + " = " + string3);
                smUserContext.setProp((String)object, string);
            } else {
                PolicyApiTestUser.Log("\nFailed to set user prop.");
            }
        }
        catch (Exception exception) {
            PolicyApiTestUser.LogFatal("Failed to get/set user prop - " + exception);
        }
        PolicyApiTestUser.Log("\nGet dn prop.");
        try {
            object = "seealso";
            string = (String)((Vector)object3).elementAt(0);
            String string4 = smUserContext.getDnProp(string, (String)object);
            if (string4 == null) {
                PolicyApiTestUser.LogFatal("Failed to get dn prop.");
            } else {
                PolicyApiTestUser.Log("\nGet dn prop: " + (String)object + " = " + string4);
            }
            PolicyApiTestUser.Log("\nSet dn prop.");
            boolean bl = smUserContext.setDnProp(string, (String)object, string4 + "9999");
            if (bl) {
                String string5 = smUserContext.getDnProp(string, (String)object);
                PolicyApiTestUser.Log("\nSet dn prop: " + (String)object + " = " + string5);
                smUserContext.setDnProp(string, (String)object, string4);
            } else {
                PolicyApiTestUser.Log("\nFailed to set user prop.");
            }
        }
        catch (Exception exception) {
            PolicyApiTestUser.LogFatal("Failed to get/set user prop - " + exception);
        }
        PolicyApiTestUser.Log("\nAuthenticate user.");
        try {
            object = new StringBuffer();
            string = smUserContext.authenticateUser("bad", (StringBuffer)object);
            if (string == null) {
                PolicyApiTestUser.Log("\nUser is not authenticated: " + ((StringBuffer)object).toString());
            } else {
                PolicyApiTestUser.Log("\nUser is authenticated: " + string);
            }
        }
        catch (Exception exception) {
            PolicyApiTestUser.LogFatal("Failed to authenticate user user prop - " + exception);
        }
    }

    private static void Log(String string) {
        System.out.print(string);
    }

    private static void LogError(String string) {
        PolicyApiTestUser.Log("\nERROR: " + string);
    }

    private static void LogException(Exception exception) {
        PolicyApiTestUser.Log("\nEXCEPTION: " + exception.getMessage());
    }

    private static void LogFatal(String string) {
        PolicyApiTestUser.Log("\nFATAL: " + string);
        System.exit(-1);
    }
}

