/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.testpolicymgmt;

import com.netegrity.sdk.apiutil.SmApiConnection;
import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.apiutil.SmApiSession;
import com.netegrity.sdk.policyapi.SmObject;
import com.netegrity.sdk.policyapi.SmPolicyApi;
import com.netegrity.sdk.policyapi.SmPolicyApiImpl;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netegrity.siteminder.javaagent.AgentAPI;
import netegrity.siteminder.javaagent.InitDef;
import netegrity.siteminder.javaagent.ServerDef;

public class PolicyApiTest {
    public static final String AGENT_LOGIN = "SampleAgent";
    public static final String SharedSecret = "SharedSecret";
    public static final String RESOURCE = "/SMAPISample/SampleResourceGet";
    public static final String ACTION = "GET";
    public static final String CLIENT_IP = "127.0.0.1";
    public static final String USER = "SiteMinder";
    public static final String PASSWORD = "firewall";
    public static final String ORG_ROOT = "o=bigdir";
    public static final String USER_DN = "uid=smuser,ou=people,o=security.com";
    public static final String POLICY_IP = "127.0.0.1";
    public static final String LDAP_IP_PORT = "192.168.50.83:38900";
    public static final boolean REQUIRE_CREDENTIALS = false;
    public static final String ORACLE_ADMIN = "scott";
    public static final String ORACLE_ADMIN_PASSWD = "tiger";
    public static final String API_LOGFILE = "PolicyApiTestLog.txt";
    public static final String DESCRIPTION = "SiteMinder Java Policy API";
    public static final String AGENT = "javaagent";
    public static final String DIR_LDAP = "javadir-LDAP";
    public static final String DIR_ODBC = "javadir-ODBC";
    public static final String DOMAIN = "javadomain";
    public static final String DOMAIN2 = "SampleDomain";
    public static final String ADMIN = "javaadmin";
    public static final String REG_SCHEME = "ldapregscheme";
    public static final String REG_SCHEME_ORA = "oraregscheme";
    public static final String REALM = "javarealm";
    public static final String RULE1 = "javarule1";
    public static final String POLICY = "SamplePolicy";
    public static final String USERPOLICY_PATH = "ou=Directory Administrators, o=security.com";
    public static final String USERPOLICY_CLASS = "groupofuniquenames";
    public static String m_REALM_OID = "";
    public static String m_SESSIONSPEC = null;
    public SmApiConnection m_ApiConnection = null;
    private static PrintWriter pw = null;
    private static DateFormat dateFormat = new SimpleDateFormat("[dd/MMM/yyyy:H:mm:ss z]");

    public PolicyApiTest() {
        try {
            this.m_ApiConnection = new SmApiConnection(false, false);
        }
        catch (SmApiException smApiException) {
            PolicyApiTest.printfile(smApiException.getMessage());
        }
    }

    public static void createObjects(SmPolicyApi smPolicyApi) {
        SmApiResult smApiResult = new SmApiResult();
    }

    public static void getObjects(SmPolicyApi smPolicyApi) {
        SmApiResult smApiResult = new SmApiResult();
    }

    public static void cleanup(SmPolicyApi smPolicyApi) {
        SmApiResult smApiResult = new SmApiResult();
    }

    public static void main(String[] stringArray) {
        try {
            InetAddress inetAddress;
            SmApiResult smApiResult = new SmApiResult();
            PolicyApiTest.printfile("Begin policy API sample program.");
            PolicyApiTest policyApiTest = new PolicyApiTest();
            AgentAPI agentAPI = new AgentAPI();
            ServerDef serverDef = new ServerDef();
            serverDef.serverIpAddress = "127.0.0.1";
            serverDef.connectionMin = 1;
            serverDef.connectionMax = 1;
            serverDef.connectionStep = 1;
            serverDef.timeout = 8000;
            serverDef.authorizationPort = 44443;
            serverDef.authenticationPort = 44442;
            serverDef.accountingPort = 44441;
            InitDef initDef = new InitDef(AGENT_LOGIN, SharedSecret, false, serverDef);
            int n = agentAPI.init(initDef);
            System.out.print("result code from init:");
            System.out.println(n);
            SmApiSession smApiSession = new SmApiSession(new SmApiConnection(agentAPI));
            try {
                inetAddress = InetAddress.getLocalHost();
                smApiResult = smApiSession.login(USER, PASSWORD, inetAddress, 0);
                if (!smApiResult.isSuccess()) {
                    PolicyApiTest.printfile("Login failed: " + smApiResult.toString());
                    PolicyApiTest.closefile();
                    return;
                }
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println(unknownHostException.getMessage());
                return;
            }
            inetAddress = new SmPolicyApiImpl(smApiSession);
            PolicyApiTest.testGetPolicyStoreVersion((SmPolicyApi)inetAddress);
            PolicyApiTest.cleanup((SmPolicyApi)inetAddress);
            PolicyApiTest.createObjects((SmPolicyApi)inetAddress);
            PolicyApiTest.getObjects((SmPolicyApi)inetAddress);
            PolicyApiTest.testDirectorySearchOrder((SmPolicyApi)inetAddress);
            PolicyApiTest.closefile();
        }
        catch (SmApiException smApiException) {
            PolicyApiTest.printfile(smApiException.getMessage());
        }
    }

    public static void printfile(String string) {
        if (string.equals("")) {
            pw.println(string);
            return;
        }
        String string2 = dateFormat.format(new Date());
        String string3 = string2 + ": " + string;
        pw.println(string3);
        pw.flush();
    }

    private static void printObject(Object object) {
        if (object != null) {
            if (object instanceof Hashtable) {
                Enumeration enumeration = ((Hashtable)object).keys();
                Enumeration enumeration2 = ((Hashtable)object).elements();
                while (enumeration2.hasMoreElements()) {
                    PolicyApiTest.printfile(enumeration.nextElement() + "=" + enumeration2.nextElement());
                }
            } else if (object instanceof Vector) {
                PolicyApiTest.printfile("Vector size " + ((Vector)object).size());
                Enumeration enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    PolicyApiTest.printfile("<" + enumeration.nextElement() + ">");
                }
            } else {
                PolicyApiTest.printfile(object.toString());
            }
        }
    }

    private static void printObject(SmObject smObject, SmApiResult smApiResult) {
        if (smApiResult.isSuccess()) {
            PolicyApiTest.printfile("SUCCESS: " + smApiResult.toString());
        } else {
            PolicyApiTest.printfile("ERROR: " + smApiResult.toString());
        }
        if (smObject != null) {
            Hashtable hashtable = new Hashtable(25);
            smObject.writeProperties(hashtable);
            PolicyApiTest.printObject(hashtable);
        }
        PolicyApiTest.printfile("");
    }

    private static void printResult(SmApiResult smApiResult) {
        if (!smApiResult.isSuccess()) {
            PolicyApiTest.printfile("ERROR: " + smApiResult.toString());
        } else {
            PolicyApiTest.printfile("SUCCESS: " + smApiResult.toString());
        }
        PolicyApiTest.printfile("");
    }

    public static void closefile() {
        pw.close();
    }

    public static void testDirectorySearchOrder(SmPolicyApi smPolicyApi) {
        SmApiResult smApiResult = new SmApiResult();
    }

    public static void testGetPolicyStoreVersion(SmPolicyApi smPolicyApi) {
        SmApiResult smApiResult = new SmApiResult();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        try {
            smApiResult = smPolicyApi.getPolicyStoreVersion(stringBuffer, stringBuffer2, stringBuffer3);
            PolicyApiTest.printfile(stringBuffer.toString());
            PolicyApiTest.printfile(stringBuffer2.toString());
            PolicyApiTest.printfile(stringBuffer3.toString());
        }
        catch (SmApiException smApiException) {
            PolicyApiTest.printfile(smApiException.getMessage());
        }
    }

    static {
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(API_LOGFILE)));
        }
        catch (IOException iOException) {
            System.out.println("IO Exception " + iOException.getMessage());
        }
    }
}

