/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.management;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiNotInitializedException;
import com.ca.siteminder.sdk.agentapi.SmAttribute;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmRealmDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmResourceContextDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmSessionDef;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmUserAgentDef;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnection;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmSecureRandom;
import com.ca.siteminder.sdk.agentapi.management.SmAgentApiManagement;
import com.ca.siteminder.sdk.agentapi.management.SmAgentApiManagementException;
import com.ca.siteminder.sdk.agentapi.management.SmAgentApiManagementResult;
import com.ca.siteminder.sdk.agentapi.management.SmAgentInstance;
import com.ca.siteminder.sdk.agentapi.management.SmAgentInstanceDef;
import com.ca.siteminder.sdk.agentapi.management.SmManagementCommands;
import com.ca.siteminder.sdk.agentapi.management.SmManagementContextDef;
import com.ca.siteminder.sdk.agentapi.management.SmTokenDescriptor;
import com.ca.siteminder.sdk.agentapi.management.SmTokenFields;
import com.ca.siteminder.sdk.agentapi.resources.SmManagementMessages;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliPacket;
import com.netegrity.util.AesCryptoProviderString;
import com.netegrity.util.DeriveKey;
import com.netegrity.util.Fips140Mode;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimerTask;
import java.util.Vector;

public class SmAgentApiManagementImpl
implements SmAgentApiManagement,
SmAgentApiConstants,
SmManagementCommands,
SmTokenFields {
    private static final String CLASS_NAME = "SmAgentApiManagementImpl";
    private static final String MESSAGES_CLASSNAME = SmManagementMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private static final String AGENT_CONFIGURATION_TYPE = "agent";
    private static final String HOST_CONFIGURATION_TYPE = "host";
    private static final String MULTIVAL_SEPARATOR = Character.toString('\u0003');
    private static final int STALE_KEY_TIME = 30;
    private SmAgentApiConnection m_connection;
    private byte[] m_currentKey;
    private byte[] m_nextKey;
    private byte[] m_lastKey;
    private byte[] m_staticKey;
    private int m_keyTimestamp;
    private SmAgentInstanceDef m_agentInstanceDef = null;
    private byte[] m_currentFipsKey;
    private byte[] m_nextFipsKey;
    private byte[] m_lastFipsKey;
    private byte[] m_staticFipsKey;

    public SmAgentApiManagementImpl(SmAgentApiConnection connection) {
        this.m_connection = connection;
    }

    public SmAgentApiManagementResult doManagement(SmManagementContextDef managementContextDef) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "doManagement";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            Util.display(2, CLASS_NAME, "doManagement", "Connection is null or closed");
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (managementContextDef == null || managementContextDef.getData() == null) {
            Util.display(2, CLASS_NAME, "doManagement", "Missing managementContextDef/Data");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_MANAGEMENT_CONTEXT"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(7);
        try {
            if (this.m_agentInstanceDef != null) {
                if (this.m_agentInstanceDef.getAgentGuid().equals("") || this.m_agentInstanceDef.getAgentGuid() == null) {
                    String blankGUID = "unknown";
                    request.setAttribute(169, blankGUID.getBytes("UTF-8"));
                } else {
                    request.setAttribute(169, this.m_agentInstanceDef.getAgentGuid().getBytes("UTF-8"));
                }
            }
            long connTimestamp = this.m_connection.getTimestamp() / 1000L;
            request.setAttribute(199, String.valueOf(connTimestamp).getBytes("UTF-8"));
            long timestamp = System.currentTimeMillis() / 1000L;
            request.setAttribute(159, String.valueOf(timestamp).getBytes("UTF-8"));
            int timezone = 0;
            request.setAttribute(165, String.valueOf(timezone).getBytes("UTF-8"));
            int strength = this.getCipherStrength();
            request.setAttribute(166, String.valueOf(strength).getBytes("UTF-8"));
            int command = managementContextDef.getCommand();
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "doManagement", "Adding request packet mgmt command = " + command);
            }
            request.setAttribute(148, String.valueOf(command).getBytes("UTF-8"));
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "doManagement", "Adding request packet mgmt data = " + managementContextDef.getData());
            }
            request.setAttribute(149, managementContextDef.getData().getBytes("UTF-8"));
            int[] status = new int[1];
            SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
            this.validateResponse(status, response);
            SmManagementContextDef managementContext = null;
            List responseAttributes = response.getAttributes();
            ArrayList<SmAttribute> resultAttributes = new ArrayList<SmAttribute>();
            int code = response.getType();
            if (responseAttributes != null && responseAttributes.size() >= 0) {
                block12: for (SmAttribute responseAttribute : responseAttributes) {
                    if (responseAttribute == null) continue;
                    switch (responseAttribute.getId()) {
                        case 192: {
                            if (code == 2) {
                                this.m_currentKey = responseAttribute.getValue();
                                this.m_currentFipsKey = DeriveKey.Fips140(DeriveKey.DerivationType.FIPS140_AGENTKEYS, 48, this.m_currentKey, this.m_currentKey.length, null, 0, null, 0, null, 0);
                                this.m_keyTimestamp = (int)(System.currentTimeMillis() / 1000L);
                            } else {
                                Util.display(3, CLASS_NAME, "doManagement", "Current key update not set since TLI response failed");
                            }
                            resultAttributes.add(responseAttribute);
                            continue block12;
                        }
                        case 190: {
                            if (code == 2) {
                                this.m_nextKey = responseAttribute.getValue();
                                this.m_nextFipsKey = DeriveKey.Fips140(DeriveKey.DerivationType.FIPS140_AGENTKEYS, 48, this.m_nextKey, this.m_nextKey.length, null, 0, null, 0, null, 0);
                                this.m_keyTimestamp = (int)(System.currentTimeMillis() / 1000L);
                            } else {
                                Util.display(3, CLASS_NAME, "doManagement", "Next key update not set since TLI response failed");
                            }
                            resultAttributes.add(responseAttribute);
                            continue block12;
                        }
                        case 191: {
                            if (code == 2) {
                                this.m_lastKey = responseAttribute.getValue();
                                this.m_lastFipsKey = DeriveKey.Fips140(DeriveKey.DerivationType.FIPS140_AGENTKEYS, 48, this.m_lastKey, this.m_lastKey.length, null, 0, null, 0, null, 0);
                                this.m_keyTimestamp = (int)(System.currentTimeMillis() / 1000L);
                            } else {
                                Util.display(3, CLASS_NAME, "doManagement", "last key update not set since TLI response failed");
                            }
                            resultAttributes.add(responseAttribute);
                            continue block12;
                        }
                        case 193: {
                            if (code == 2) {
                                this.m_staticKey = responseAttribute.getValue();
                                this.m_staticFipsKey = DeriveKey.Fips140(DeriveKey.DerivationType.FIPS140_AGENTKEYS, 48, this.m_staticKey, this.m_staticKey.length, null, 0, null, 0, null, 0);
                                this.m_keyTimestamp = (int)(System.currentTimeMillis() / 1000L);
                            }
                            resultAttributes.add(responseAttribute);
                            continue block12;
                        }
                        case 149: {
                            managementContext = new SmManagementContextDef(command, new String(responseAttribute.getValue(), "UTF-8"));
                            continue block12;
                        }
                        case 199: {
                            long newConnTimestamp;
                            try {
                                newConnTimestamp = Long.parseLong(new String(responseAttribute.getValue(), "UTF-8"));
                            }
                            catch (NumberFormatException e2) {
                                Util.display(2, CLASS_NAME, "doManagement", "Format exception parsing new timestamp");
                                throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_ATTRIBUTE"), e2);
                            }
                            this.m_connection.setTimestamp(newConnTimestamp * 1000L);
                            this.m_keyTimestamp = (int)(System.currentTimeMillis() / 1000L);
                            continue block12;
                        }
                    }
                    resultAttributes.add(responseAttribute);
                }
            }
            boolean result = false;
            if (code == 2) {
                result = true;
            } else if (managementContext != null) {
                Util.display(3, CLASS_NAME, "doManagement", "Did not get TLI response accept for command " + managementContext.getCommand() + ", received instead " + code);
            } else {
                Util.display(3, CLASS_NAME, "doManagement", "Did not get TLI response, Mgmt Context is null, received" + code);
            }
            return new SmAgentApiManagementResult(result, resultAttributes, managementContext);
        }
        catch (UnsupportedEncodingException e3) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "doManagement", "Unsupported encoding: " + e3);
            }
            throw new SmAgentApiManagementException(e3);
        }
    }

    public SmAgentApiManagementResult setAgentInstanceInfo(SmAgentInstanceDef agentInstanceDef) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "setAgentInstanceInfo";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            Util.display(2, CLASS_NAME, "setAgentInstanceInfo", "Connection is null or closed");
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (agentInstanceDef == null) {
            Util.display(2, CLASS_NAME, "setAgentInstanceInfo", "Missing AgentInstanceDef/Data");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_AGENT_INSTANCE"));
        }
        this.m_agentInstanceDef = agentInstanceDef;
        SmAgentApiManagementResult result = new SmAgentInstance(this.m_connection, this.m_agentInstanceDef).processAgentInstanceInfo();
        long timetoSchedule = this.m_agentInstanceDef.getAIHI() * 1000L;
        this.m_connection.getTimer().schedule((TimerTask)new SmAgentInstance(this.m_connection, this.m_agentInstanceDef), timetoSchedule);
        return result;
    }

    public SmAgentApiManagementResult updateAttributes(String transactionId, SmUserAgentDef userAgentDef, SmResourceContextDef resourceContextDef, SmRealmDef realmDef, SmSessionDef sessionDef, List refreshAttributes) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "updateAttributes";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            Util.display(2, CLASS_NAME, "updateAttributes", "Connection is null or closed");
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (userAgentDef == null || userAgentDef.getClientIpAddress() == null) {
            Util.display(2, CLASS_NAME, "updateAttributes", "Invalid user agent data passed");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_USER_AGENT"));
        }
        if (resourceContextDef == null || resourceContextDef.getServer() == null || resourceContextDef.getResource() == null || resourceContextDef.getAction() == null) {
            Util.display(2, CLASS_NAME, "updateAttributes", "Invalid RCD data passed");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_RESOURCE_CONTEXT"));
        }
        if (realmDef == null || realmDef.getOid() == null) {
            Util.display(2, CLASS_NAME, "updateAttributes", "Invalid realmDef data passed");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_REALM"));
        }
        if (sessionDef == null || sessionDef.getId() == null || sessionDef.getSpec() == null) {
            Util.display(2, CLASS_NAME, "updateAttributes", "Invalid sessionDef data passed");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_SESSION"));
        }
        if (refreshAttributes == null) {
            Util.display(5, CLASS_NAME, "updateAttributes", "No attributes passed to update");
            return new SmAgentApiManagementResult(true);
        }
        String agent = this.m_connection.getAgentName(resourceContextDef);
        if (agent == null) {
            Util.display(2, CLASS_NAME, "updateAttributes", "Invalid agent name");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_AGENT_NAME"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(6);
        try {
            request.setAttribute(208, userAgentDef.getClientIpAddress().getBytes("UTF-8"));
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(200, agent.getBytes("UTF-8"));
            request.setAttribute(217, resourceContextDef.getServer().getBytes("UTF-8"));
            request.setAttribute(201, resourceContextDef.getResource().getBytes("UTF-8"));
            request.setAttribute(202, resourceContextDef.getAction().getBytes("UTF-8"));
            request.setAttribute(204, realmDef.getOid().getBytes("UTF-8"));
            request.setAttribute(205, sessionDef.getId().getBytes("UTF-8"));
            request.setAttribute(209, sessionDef.getSpec().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            Util.display(2, CLASS_NAME, "updateAttributes", "Unsupported encoding creating TLI packet");
            throw new SmAgentApiManagementException(e2);
        }
        for (SmAttribute attr : refreshAttributes) {
            if (attr == null || attr.getOid() == null) {
                Util.display(4, CLASS_NAME, "updateAttributes", "Ignoring null or empty OID attribute as part of the request");
                continue;
            }
            try {
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "updateAttributes", "Request attribute update id = " + attr.getId());
                }
                request.setAttribute(157, attr.getOid().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e3) {
                Util.display(2, CLASS_NAME, "updateAttributes", "Unsupported encoding processing attribute");
                throw new SmAgentApiManagementException(e3);
            }
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        this.validateResponse(status, response);
        int reason = 0;
        List attributes = response.getAttributes();
        if (attributes == null) {
            Util.display(2, CLASS_NAME, "updateAttributes", "No response attributes to process");
            throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_LIST_ATTRIBUTES"));
        }
        ArrayList<SmAttribute> updatedAttributes = new ArrayList<SmAttribute>();
        for (SmAttribute responseAttribute : attributes) {
            if (responseAttribute == null) {
                Util.display(4, CLASS_NAME, "updateAttributes", "Ignoring null attribute from the PS");
                continue;
            }
            if (Util.isLogEnabled()) {
                Util.display(4, CLASS_NAME, "updateAttributes", "Received response attribute id = " + responseAttribute.getId());
            }
            if (responseAttribute.getId() == 212) {
                reason = ByteBuffer.wrap(responseAttribute.getValue()).getInt();
                continue;
            }
            updatedAttributes.add(responseAttribute);
        }
        boolean result = false;
        int code = response.getType();
        if (code == 2) {
            result = true;
        }
        return new SmAgentApiManagementResult(result, updatedAttributes, reason);
    }

    public SmAgentApiManagementResult getAgentConfig(String agentConfigName) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        return this.getConfigData(agentConfigName, AGENT_CONFIGURATION_TYPE, false);
    }

    public SmAgentApiManagementResult getHostConfig(String hostConfigName) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        return this.getConfigData(hostConfigName, HOST_CONFIGURATION_TYPE, true);
    }

    private SmAgentApiManagementResult getConfigData(String configName, String configType, boolean getHostConfig) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "getConfigData";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            Util.display(2, CLASS_NAME, "getConfigData", "Connection is null or closed");
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (configName == null) {
            Util.display(2, CLASS_NAME, "getConfigData", "Missing configuraton name");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_CONFIG_NAME"));
        }
        if (configType == null) {
            Util.display(2, CLASS_NAME, "getConfigData", "Missing configuration type");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_CONFIG_TYPE"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(12);
        try {
            request.setAttribute(143, configType.getBytes("UTF-8"));
            request.setAttribute(144, configName.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            Util.display(2, CLASS_NAME, "getConfigData", "Unsupported encoding processing config type or name");
            throw new SmAgentApiManagementException(e2);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        this.validateResponse(status, response);
        List responseAttrs = response.getAttributes();
        Iterator it = responseAttrs.iterator();
        ArrayList<SmAttribute> resultAttrs = new ArrayList<SmAttribute>();
        while (it.hasNext()) {
            SmAttribute attr = (SmAttribute)it.next();
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "getConfigData", "Processing TLI response attribute = " + new String(attr.getValue()));
            }
            if (attr == null || attr.getValue() == null) {
                Util.display(2, CLASS_NAME, "getConfigData", "Response contained null or empty attribute");
                throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_ATTRIBUTE"));
            }
            if (attr.getId() != 144) {
                resultAttrs.add(attr);
                continue;
            }
            String data = null;
            try {
                data = new String(attr.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException e3) {
                Util.display(2, CLASS_NAME, "getConfigData", "Unsupported encoding parsing attribute value");
                throw new SmAgentApiManagementException(e3);
            }
            try {
                int nameEnd = data.indexOf("=");
                if (nameEnd < 0) {
                    data = data + "=";
                    resultAttrs.add(new SmAttribute(144, attr.getTtl(), attr.getFlags(), attr.getOid(), data.getBytes("UTF-8")));
                    continue;
                }
                String name = data.substring(0, nameEnd);
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "getConfigData", "Attribute name:" + name);
                }
                String[] allValues = data.substring(nameEnd + 1).split(MULTIVAL_SEPARATOR);
                if (name.toLowerCase().startsWith("cluster_")) {
                    resultAttrs.add(new SmAttribute(144, attr.getTtl(), attr.getFlags(), attr.getOid(), (name + "=" + allValues[0]).getBytes("UTF-8")));
                    this.addMultiValuesHelper(attr, allValues, 1, "", resultAttrs);
                    continue;
                }
                this.addMultiValuesHelper(attr, allValues, 0, name + "=", resultAttrs);
            }
            catch (UnsupportedEncodingException e4) {
                Util.display(2, CLASS_NAME, "getConfigData", "Unsupported encoding inserting value into SmAttribute");
                throw new SmAgentApiManagementException(e4);
            }
        }
        boolean result = false;
        int code = response.getType();
        if (code == 2) {
            result = true;
        }
        return new SmAgentApiManagementResult(result, resultAttrs);
    }

    public String createSSOToken(SmSessionDef sessionDef, List attributes) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException, SmCryptoProviderException {
        String methodName = "createSSOToken";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            Util.display(2, CLASS_NAME, "createSSOToken", "Connection is null or closed");
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (sessionDef == null) {
            Util.display(2, CLASS_NAME, "createSSOToken", "Missing session definition.");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_SESSION"));
        }
        if (attributes == null) {
            Util.display(2, CLASS_NAME, "createSSOToken", "Missing list of attributes.");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_LIST_ATTRIBUTES"));
        }
        if (this.areKeysStale()) {
            Util.display(4, CLASS_NAME, "createSSOToken", "Updating stale keys");
            this.doManagement(new SmManagementContextDef(1, ""));
        }
        StringBuffer cookie = new StringBuffer();
        int saltName = SmSecureRandom.nextInt();
        int saltValue = SmSecureRandom.nextInt();
        SmAgentApiManagementImpl.addCookieValue(cookie, Integer.toHexString(saltName), Integer.toHexString(saltValue));
        SmAgentApiManagementImpl.addCookieValue(cookie, "VER", String.valueOf(401));
        boolean[] used = new boolean[11];
        Arrays.fill(used, false);
        for (int k2 = 0; k2 < 11; ++k2) {
            int index = SmSecureRandom.nextInt(11);
            while (used[index]) {
                index = SmSecureRandom.nextInt(11);
            }
            switch (index) {
                case 0: {
                    SmAgentApiManagementImpl.addCookieValue(cookie, 210, "NAME", attributes);
                    break;
                }
                case 1: {
                    SmAgentApiManagementImpl.addCookieValue(cookie, 218, "DN", attributes);
                    break;
                }
                case 2: {
                    SmAgentApiManagementImpl.addCookieValue(cookie, 208, "IPADDRESS", attributes);
                    break;
                }
                case 3: {
                    SmAgentApiManagementImpl.addCookieValue(cookie, 205, "SRVSESSIONID", attributes, sessionDef.getId());
                    SmAgentApiManagementImpl.addCookieValue(cookie, "SAVEID", "NO");
                    break;
                }
                case 4: {
                    SmAgentApiManagementImpl.addCookieValue(cookie, 209, "SPC3", attributes, sessionDef.getSpec());
                    break;
                }
                case 5: {
                    SmAgentApiManagementImpl.addCookieValue(cookie, 154, "AUTHTIME", attributes, String.valueOf(sessionDef.getSessionStartTime()));
                    break;
                }
                case 6: {
                    SmAgentApiManagementImpl.addCookieValue(cookie, "LASTACCESSTIME", String.valueOf(System.currentTimeMillis() / 1000L));
                    break;
                }
                case 7: {
                    SmAgentApiManagementImpl.addCookieValue(cookie, 226, "MAXTIMEOUT", attributes, String.valueOf(sessionDef.getMaxTimeout()));
                    break;
                }
                case 8: {
                    SmAgentApiManagementImpl.addCookieValue(cookie, 225, "IDLETIMEOUT", attributes, String.valueOf(sessionDef.getIdleTimeout()));
                    break;
                }
                case 9: {
                    SmAgentApiManagementImpl.addCookieValue(cookie, 228, "SSOZONE", attributes, "SM");
                    break;
                }
                case 10: {
                    SmAgentApiManagementImpl.addCookieValue(cookie, 229, "TARGETH", attributes);
                }
            }
            used[index] = true;
        }
        return this.encrypt(cookie.toString());
    }

    public SmTokenDescriptor decodeSSOToken(String SSOToken, boolean bUpdate) throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException, SmCryptoProviderException {
        String cookie;
        String methodName = "decodeSSOToken";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            Util.display(2, CLASS_NAME, "decodeSSOToken", "Connection is null or closed");
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (SSOToken == null) {
            Util.display(2, CLASS_NAME, "decodeSSOToken", "Missing SSO token.");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_SSO_TOKEN"));
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "decodeSSOToken", "Decoding token length = " + SSOToken.length() + ", value = <" + SSOToken + ">");
        }
        if (this.areKeysStale()) {
            Util.display(4, CLASS_NAME, "decodeSSOToken", "Updating stale keys");
            this.doManagement(new SmManagementContextDef(1, ""));
            Util.display(5, CLASS_NAME, "decodeSSOToken", "Completed updating stale keys");
        }
        if ((cookie = this.decrypt(SSOToken)) == null) {
            throw new SmAgentApiManagementException(-1, c_bundle.getString("M_FAILED_DECRYPT_TOKEN"));
        }
        int version = -1;
        boolean bThirdParty = false;
        Vector<SmAttribute> attributes = new Vector<SmAttribute>();
        StringBuffer updated = null;
        if (bUpdate) {
            updated = new StringBuffer();
        }
        int idleTimeout = -1;
        int maxTimeout = -1;
        int currentTime = -1;
        int startTime = -1;
        int lastTime = -1;
        String sessionId = null;
        String sessionSpec = null;
        String lastAccessTime = null;
        try {
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "decodeSSOToken", "Connection device name = " + this.m_connection.getHostName());
            }
            attributes.add(new SmAttribute(200, this.m_connection.getHostName().getBytes("UTF-8")));
            cookie = cookie.trim();
            String[] tokens = cookie.split("\t");
            for (int k2 = 0; k2 < tokens.length; ++k2) {
                if (tokens[k2] == null) {
                    throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_TOKEN_ATTRIBUTE"));
                }
                int index = tokens[k2].indexOf("=");
                if (index < 0) {
                    throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_TOKEN_ATTRIBUTE"));
                }
                String name = tokens[k2].substring(0, index);
                String value = tokens[k2].substring(index + "=".length());
                if (name == null || value == null) {
                    throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_TOKEN_ATTRIBUTE"));
                }
                if (name.equals("VER")) {
                    try {
                        version = Integer.parseInt(value);
                        continue;
                    }
                    catch (NumberFormatException e2) {
                        throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_TOKEN_ATTRIBUTE"), e2);
                    }
                }
                if (name.equals("DN")) {
                    attributes.add(new SmAttribute(218, value.getBytes("UTF-8")));
                    continue;
                }
                if (name.equals("SRVSESSIONID")) {
                    sessionId = value;
                    attributes.add(new SmAttribute(205, value.getBytes("UTF-8")));
                    continue;
                }
                if (name.equals("NAME")) {
                    attributes.add(new SmAttribute(210, value.getBytes("UTF-8")));
                    continue;
                }
                if (name.equals("IPADDRESS")) {
                    attributes.add(new SmAttribute(208, value.getBytes("UTF-8")));
                    continue;
                }
                if (name.equals("IDLETIMEOUT")) {
                    try {
                        idleTimeout = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e3) {
                        throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_TOKEN_ATTRIBUTE"), e3);
                    }
                    attributes.add(new SmAttribute(225, value.getBytes("UTF-8")));
                    continue;
                }
                if (name.equals("MAXTIMEOUT")) {
                    try {
                        maxTimeout = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e4) {
                        throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_TOKEN_ATTRIBUTE"), e4);
                    }
                    attributes.add(new SmAttribute(226, value.getBytes("UTF-8")));
                    continue;
                }
                if (name.equals("AUTHTIME")) {
                    try {
                        startTime = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e5) {
                        throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_TOKEN_ATTRIBUTE"), e5);
                    }
                    attributes.add(new SmAttribute(154, value.getBytes("UTF-8")));
                    continue;
                }
                if (name.equals("LASTACCESSTIME")) {
                    try {
                        lastTime = Integer.parseInt(value);
                        if (bUpdate) {
                            lastAccessTime = String.valueOf(System.currentTimeMillis() / 1000L);
                            int lastAccessToken = cookie.indexOf(name);
                            updated.append(cookie.substring(0, lastAccessToken));
                            SmAgentApiManagementImpl.addCookieValue(updated, name, String.valueOf(lastAccessTime));
                            int cookieLength = cookie.length();
                            int subStringLength = lastAccessToken + name.length() + "=".length() + value.length();
                            if (cookieLength <= subStringLength) {
                                updated.append(cookie.substring(subStringLength));
                            } else {
                                updated.append(cookie.substring(subStringLength + "\t".length()));
                            }
                            currentTime = Integer.parseInt(lastAccessTime);
                            attributes.add(new SmAttribute(155, lastAccessTime.getBytes("UTF-8")));
                            continue;
                        }
                        currentTime = lastTime;
                        attributes.add(new SmAttribute(155, value.getBytes("UTF-8")));
                        continue;
                    }
                    catch (NumberFormatException e6) {
                        throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_TOKEN_ATTRIBUTE"), e6);
                    }
                }
                if (name.equals("SRVSESSIONSPEC")) {
                    if (value.equals("")) {
                        bThirdParty = true;
                        continue;
                    }
                    bThirdParty = false;
                    sessionSpec = value;
                    attributes.add(new SmAttribute(209, value.getBytes("UTF-8")));
                    continue;
                }
                if (name.equals("SPC3")) {
                    if (value.equals("")) {
                        bThirdParty = false;
                        continue;
                    }
                    bThirdParty = true;
                    sessionSpec = value;
                    attributes.add(new SmAttribute(209, value.getBytes("UTF-8")));
                    continue;
                }
                if (name.equals("SSOZONE")) {
                    attributes.add(new SmAttribute(228, value.getBytes("UTF-8")));
                    continue;
                }
                if (!name.equals("TARGETH")) continue;
                attributes.add(new SmAttribute(229, value.getBytes("UTF-8")));
            }
            SmSessionDef session = new SmSessionDef(idleTimeout, maxTimeout, currentTime, startTime, lastTime, sessionId, sessionSpec);
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "decodeSSOToken", "Setting version = " + version + ", thirdParty = " + bThirdParty);
            }
            return new SmTokenDescriptor(version, bThirdParty, bUpdate ? this.encrypt(updated.toString()) : null, session, attributes);
        }
        catch (UnsupportedEncodingException e7) {
            throw new SmAgentApiManagementException(e7);
        }
    }

    private static void addCookieValue(StringBuffer cookie, String name, String value) {
        if (cookie != null && name != null && value != null) {
            cookie.append(name).append("=").append(value).append("\t");
        }
    }

    private static void addCookieValue(StringBuffer cookie, int attrId, String name, List attributes) throws SmAgentApiManagementException {
        SmAgentApiManagementImpl.addCookieValue(cookie, attrId, name, attributes, "");
    }

    private static void addCookieValue(StringBuffer cookie, int attrId, String name, List attributes, String defaultValue) throws SmAgentApiManagementException {
        if (cookie != null && name != null && attributes != null) {
            String value = null;
            for (int k2 = 0; k2 < attributes.size(); ++k2) {
                SmAttribute attr = (SmAttribute)attributes.get(k2);
                if (attr == null || attrId != attr.getId()) continue;
                try {
                    value = new String(attr.getValue(), "UTF-8");
                    break;
                }
                catch (UnsupportedEncodingException e2) {
                    throw new SmAgentApiManagementException(e2);
                }
            }
            if (value != null && 208 == attrId && value.startsWith("*")) {
                value = value.substring(1);
            }
            if (value == null && attrId != 229) {
                value = defaultValue;
            }
            if (null != value) {
                SmAgentApiManagementImpl.addCookieValue(cookie, name, value);
            }
        }
    }

    private boolean areKeysStale() {
        return System.currentTimeMillis() / 1000L - (long)this.m_keyTimestamp > 30L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encrypt(String input) throws SmCryptoProviderException {
        if (input == null) {
            return null;
        }
        Fips140Mode fipsModeObj = Fips140Mode.getFips140ModeObject();
        if (fipsModeObj.wantFips()) {
            byte[] key = this.m_currentFipsKey;
            if (key == null) {
                key = this.m_staticFipsKey;
            }
            AesCryptoProviderString aesCryptoProvider = new AesCryptoProviderString(key);
            try {
                byte[] inputBytes = input.getBytes("UTF-8");
                byte[] output = aesCryptoProvider.Encrypt(inputBytes, 0, inputBytes.length);
                return new String(output, "UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                throw new SmCryptoProviderException(e2);
            }
        }
        SmCryptoProvider provider = SmCryptoProvider.getInstance("RC2/HmacSHA1", null, true);
        byte[] key = this.m_currentKey;
        if (key == null) {
            key = this.m_staticKey;
        }
        byte[] e2 = key;
        synchronized (key) {
            provider.init(key, key, null, this.getCipherStrength(), true);
            // ** MonitorExit[e] (shouldn't be in output)
            try {
                byte[] output = provider.encrypt(input.getBytes("UTF-8"));
                return new String(output, "UTF-8");
            }
            catch (UnsupportedEncodingException e3) {
                throw new SmCryptoProviderException(e3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String decrypt(String input) throws SmCryptoProviderException {
        byte[] e22;
        byte[] decrypted2;
        SmCryptoProvider provider;
        String output;
        block36: {
            Fips140Mode fipsModeObj;
            output = null;
            boolean bStatic = false;
            if (input == null) {
                return null;
            }
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "decrypt", "Input = " + input);
            }
            if ((fipsModeObj = Fips140Mode.getFips140ModeObject()).wantFips()) {
                byte[] decrypted2;
                byte[] inputBytes;
                byte[] key = this.m_currentFipsKey;
                try {
                    inputBytes = input.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e3) {
                    throw new SmCryptoProviderException(e3);
                }
                if (key == null) {
                    key = this.m_staticFipsKey;
                    bStatic = true;
                }
                AesCryptoProviderString currentKeyProvider = new AesCryptoProviderString(key);
                try {
                    decrypted2 = currentKeyProvider.Decrypt(inputBytes, 0, inputBytes.length);
                    output = new String(decrypted2, "UTF-8");
                }
                catch (UnsupportedEncodingException e4) {
                    output = null;
                }
                if (output != null) {
                    return output;
                }
                if (!bStatic) {
                    if (this.m_lastFipsKey != null) {
                        AesCryptoProviderString lastKeyProvider = new AesCryptoProviderString(this.m_lastFipsKey);
                        try {
                            decrypted2 = lastKeyProvider.Decrypt(inputBytes, 0, inputBytes.length);
                            output = new String(decrypted2, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e5) {
                            output = null;
                        }
                    }
                    if (output != null) {
                        return output;
                    }
                }
                if (this.m_nextFipsKey != null) {
                    AesCryptoProviderString nextKeyProvider = new AesCryptoProviderString(this.m_nextFipsKey);
                    try {
                        decrypted2 = nextKeyProvider.Decrypt(inputBytes, 0, inputBytes.length);
                        output = new String(decrypted2, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e6) {
                        output = null;
                    }
                }
                if (output == null) return output;
                return output;
            }
            provider = SmCryptoProvider.getInstance("RC2/HmacSHA1", null, true);
            byte[] key = this.m_currentKey;
            if (key == null) {
                key = this.m_staticKey;
                bStatic = true;
            }
            try {
                decrypted2 = key;
                // MONITORENTER : key
                provider.init(key, key, null, this.getCipherStrength(), true);
                // MONITOREXIT : decrypted2
                try {
                    decrypted2 = provider.decrypt(input.getBytes("UTF-8"));
                    output = new String(decrypted2, "UTF-8");
                }
                catch (UnsupportedEncodingException e7) {
                    throw new SmCryptoProviderException(e7);
                }
            }
            catch (SmCryptoProviderException e22) {
                output = null;
            }
            if (output != null) {
                return output;
            }
            if (bStatic) return output;
            try {
                if (this.m_lastKey == null) break block36;
                e22 = this.m_lastKey;
                // MONITORENTER : this.m_lastKey
                provider.init(this.m_lastKey, this.m_lastKey, null, this.getCipherStrength(), true);
                // MONITOREXIT : e22
                try {
                    decrypted2 = provider.decrypt(input.getBytes("UTF-8"));
                    output = new String(decrypted2, "UTF-8");
                }
                catch (UnsupportedEncodingException e23) {
                    throw new SmCryptoProviderException(e23);
                }
            }
            catch (SmCryptoProviderException e8) {
                output = null;
            }
        }
        if (output != null) return output;
        if (this.m_nextKey == null) return output;
        e22 = this.m_nextKey;
        // MONITORENTER : this.m_nextKey
        provider.init(this.m_nextKey, this.m_nextKey, null, this.getCipherStrength(), true);
        // MONITOREXIT : e22
        try {
            decrypted2 = provider.decrypt(input.getBytes("UTF-8"));
            return new String(decrypted2, "UTF-8");
        }
        catch (UnsupportedEncodingException e3) {
            throw new SmCryptoProviderException(e3);
        }
    }

    private int getCipherStrength() {
        return 128;
    }

    private void validateResponse(int[] status, SmAgentTliPacket response) throws SmAgentApiManagementException {
        String methodName = "validateResponse";
        if (status[0] != 0) {
            Util.display(2, CLASS_NAME, "validateResponse", "Did not receive SUCCESS from request");
            throw new SmAgentApiManagementException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            Util.display(2, CLASS_NAME, "validateResponse", "Null response from request");
            throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        int code = response.getType();
        if (code != 2 && code != 3) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "validateResponse", "Unrecognized response code from request: " + code);
            }
            throw new SmAgentApiManagementException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
    }

    private void addMultiValuesHelper(SmAttribute attr, String[] allValues, int startIndex, String prependName, List resultAttrs) throws UnsupportedEncodingException {
        String methodName = "addMultiValuesHelper";
        for (int i2 = startIndex; i2 < allValues.length; ++i2) {
            String value = prependName + allValues[i2];
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "addMultiValuesHelper", "Adding attribute:" + value);
            }
            resultAttrs.add(new SmAttribute(144, attr.getTtl(), attr.getFlags(), attr.getOid(), value.getBytes("UTF-8")));
        }
    }
}

