/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.as;
import com.ca.siteminder.sdk.agentapi.bz;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.aq;
import com.ca.siteminder.sdk.agentapi.crypto.ar;
import com.ca.siteminder.sdk.agentapi.crypto.at;
import com.ca.siteminder.sdk.agentapi.crypto.au;
import com.ca.siteminder.sdk.agentapi.crypto.av;
import com.ca.siteminder.sdk.agentapi.crypto.aw;
import com.ca.siteminder.sdk.agentapi.resources.SmCryptoMessages;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_Recode;
import com.rsa.jsafe.provider.JsafeJCE;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public abstract class ap
implements as {
    private static final String a = "SmCryptoProvider";
    public static final int b = 24;
    public static final int c = 48;
    public static final int d = 56;
    public static final int e = 128;
    protected static final String f = SmCryptoMessages.getName();
    protected static ResourceBundle g = ResourceBundle.getBundle(f);
    protected String h = null;
    protected String i = null;
    protected String j = null;
    protected String k = null;
    protected int l = 128;
    protected boolean m = false;
    protected boolean n = false;
    protected int o = 24;
    protected static JsafeJCE p = new JsafeJCE();
    protected byte[] q = null;
    protected Key r = null;
    protected Key s = null;
    protected Cipher t = null;
    protected Cipher u = null;
    protected int v = 0;
    protected boolean w = true;

    public static ap a(String algorithm, String keyDigestAlg, boolean bAscii) throws SmCryptoProviderException {
        ap provider = null;
        if ("RC2".equals(algorithm)) {
            provider = new aq(keyDigestAlg, bAscii);
        } else if ("RC2/SHA".equals(algorithm)) {
            provider = new ar(keyDigestAlg, bAscii);
        }
        if ("RC2/HmacSHA1".equals(algorithm)) {
            provider = new at(keyDigestAlg, bAscii);
        } else if ("RC4/SHA".equals(algorithm)) {
            provider = new au(keyDigestAlg, bAscii);
        } else if ("DES3".equals(algorithm)) {
            provider = new av(keyDigestAlg, bAscii);
        } else if ("AES-TLI".equals(algorithm)) {
            provider = new aw();
        }
        if (provider == null) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_UNSUPPORTED_PROVIDER") + algorithm);
        }
        return provider;
    }

    public void a(byte[] encryptKey, byte[] decryptKey, byte[] initVector, int keyStrength, boolean bUseEncKeyForIV) throws SmCryptoProviderException {
        if (keyStrength < 56) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_KEY_STRENGTH") + String.valueOf(keyStrength));
        }
        try {
            this.l = keyStrength;
            bz.a(5, a, "init", "Setting keys");
            this.e(encryptKey);
            this.f(decryptKey);
            bz.a(5, a, "init", "Setting IV");
            this.a(initVector, bUseEncKeyForIV);
            bz.a(5, a, "init", "Initializing params");
            this.b();
            this.t = null;
            this.u = null;
            bz.a(5, a, "init", "Init complete");
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public void a(Key encryptKey, byte[] decryptKey, byte[] initVector, int keyStrength, boolean bUseEncKeyForIV) throws SmCryptoProviderException {
        if (keyStrength < 56) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_KEY_STRENGTH") + String.valueOf(keyStrength));
        }
        try {
            this.l = keyStrength;
            bz.a(5, a, "init", "Setting keys");
            this.a(encryptKey);
            this.f(decryptKey);
            bz.a(5, a, "init", "Setting IV");
            this.a(initVector, bUseEncKeyForIV);
            bz.a(5, a, "init", "Initializing params");
            this.b();
            this.t = null;
            this.u = null;
            bz.a(5, a, "init", "Init complete");
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public void a(byte[] encryptKey, Key decryptKey, byte[] initVector, int keyStrength, boolean bUseEncKeyForIV) throws SmCryptoProviderException {
        if (keyStrength < 56) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_KEY_STRENGTH") + String.valueOf(keyStrength));
        }
        try {
            this.l = keyStrength;
            bz.a(5, a, "init", "Setting keys");
            this.e(encryptKey);
            this.b(decryptKey);
            bz.a(5, a, "init", "Setting IV");
            this.a(initVector, bUseEncKeyForIV);
            bz.a(5, a, "init", "Initializing params");
            this.b();
            this.t = null;
            this.u = null;
            bz.a(5, a, "init", "Init complete");
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public void a(Key encryptKey, Key decryptKey, byte[] initVector, int keyStrength, boolean bUseEncKeyForIV) throws SmCryptoProviderException {
        if (keyStrength < 56) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_KEY_STRENGTH") + String.valueOf(keyStrength));
        }
        try {
            this.l = keyStrength;
            bz.a(5, a, "init", "Setting keys");
            this.a(encryptKey);
            this.b(decryptKey);
            bz.a(5, a, "init", "Setting IV");
            this.a(initVector, bUseEncKeyForIV);
            bz.a(5, a, "init", "Initializing params");
            this.b();
            this.t = null;
            this.u = null;
            bz.a(5, a, "init", "Init complete");
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public void a(byte[] keyingMaterial, int keyStrength) throws SmCryptoProviderException {
    }

    public byte[] a(byte[] input) throws SmCryptoProviderException {
        String methodName = "encrypt";
        if (input == null) {
            bz.a(3, a, "encrypt", "Invalid null input to encrypt");
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        return this.b(input, input.length);
    }

    public byte[] b(byte[] input, int inLength) throws SmCryptoProviderException {
        String methodName = "encrypt";
        if (input == null || inLength <= 0 || inLength > input.length) {
            bz.a(3, a, "encrypt", "Invalid null input to encrypt");
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        if (bz.a()) {
            bz.a(5, a, "encrypt", "Using crypto provider = " + this.getClass().getName() + ", on input length = " + inLength);
        }
        try {
            if (this.t == null) {
                bz.a(5, a, "encrypt", "Getting encrypter");
                this.t = this.c();
                bz.a(5, a, "encrypt", "Got encrypter");
            }
            byte[] output = null;
            byte[] digest = this.a(input, inLength, true);
            if (digest != null) {
                int tl = this.t.getOutputSize(digest.length + inLength);
                output = new byte[tl];
                int dl = this.t.update(digest, 0, digest.length, output);
                int il = this.t.update(input, 0, inLength, output, dl);
                if (this.w) {
                    this.t.doFinal(output, dl + il);
                }
            } else {
                output = this.w ? this.t.doFinal(input, 0, inLength) : this.t.update(input, 0, inLength);
            }
            if (this.n) {
                output = ap.c(output);
            }
            return output;
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public byte[] b(byte[] input) throws SmCryptoProviderException {
        String methodName = "decrypt";
        if (input == null) {
            bz.a(3, a, "decrypt", "Invalid null input to decrypt");
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        return this.c(input, input.length);
    }

    public byte[] c(byte[] input, int inLength) throws SmCryptoProviderException {
        String methodName = "decrypt";
        if (input == null || inLength <= 0 || inLength > input.length) {
            bz.a(3, a, "decrypt", "Invalid null input to decrypt");
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        if (bz.a()) {
            bz.a(5, a, "decrypt", "Using crypto provider = " + this.getClass().getName() + ", on input length = " + inLength);
        }
        try {
            byte[] compare;
            int digestLength;
            if (this.u == null) {
                bz.a(5, a, "decrypt", "Getting decrypter");
                this.u = this.d();
                bz.a(5, a, "decrypt", "Got decrypter");
            }
            byte[] output = null;
            byte[] digest = null;
            if (this.n) {
                input = ap.e(input, inLength);
                inLength = input.length;
            }
            if ((digestLength = this.e()) > 0) {
                digest = new byte[digestLength];
                byte[] combined = this.w ? this.u.doFinal(input, 0, inLength) : this.u.update(input, 0, inLength);
                output = new byte[combined.length - digest.length];
                System.arraycopy(combined, 0, digest, 0, digest.length);
                System.arraycopy(combined, digest.length, output, 0, output.length);
            } else {
                output = this.w ? this.u.doFinal(input, 0, inLength) : this.u.update(input, 0, inLength);
            }
            if (this.m && !MessageDigest.isEqual(digest, compare = this.b(output, false))) {
                throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_DIGEST_MISMATCH"));
            }
            return output;
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public static byte[] a(byte[] input, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm, (Provider)new JsafeJCE());
        return md.digest(input);
    }

    public static byte[] c(byte[] input) throws SmCryptoProviderException {
        if (input == null) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        return ap.d(input, input.length);
    }

    public static byte[] d(byte[] input, int inLength) throws SmCryptoProviderException {
        if (input == null || inLength <= 0 || inLength > input.length) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        try {
            JSAFE_Recode encoder = JSAFE_Recode.getInstance((String)"Base64-0", (String)"Java");
            encoder.encodeInit();
            int ouputSize = encoder.getOutputBufferSize(inLength);
            byte[] output = new byte[ouputSize];
            int updatedSize = encoder.encodeUpdate(input, 0, inLength, output, 0);
            updatedSize += encoder.encodeFinal(output, updatedSize);
            if (updatedSize == ouputSize) {
                return output;
            }
            byte[] updated = new byte[updatedSize];
            System.arraycopy(output, 0, updated, 0, updatedSize);
            return updated;
        }
        catch (JSAFE_Exception e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public static byte[] d(byte[] input) throws SmCryptoProviderException {
        if (input == null) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        return ap.e(input, input.length);
    }

    public static byte[] e(byte[] input, int inLength) throws SmCryptoProviderException {
        if (input == null || inLength <= 0 || inLength > input.length) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        try {
            JSAFE_Recode decoder = JSAFE_Recode.getInstance((String)"Base64-0", (String)"Java");
            decoder.decodeInit();
            int ouputSize = decoder.getOutputBufferSize(inLength);
            byte[] output = new byte[ouputSize];
            int updatedSize = decoder.decodeUpdate(input, 0, inLength, output, 0);
            updatedSize += decoder.decodeFinal(output, updatedSize);
            if (updatedSize == ouputSize) {
                return output;
            }
            byte[] updated = new byte[updatedSize];
            System.arraycopy(output, 0, updated, 0, updatedSize);
            return updated;
        }
        catch (JSAFE_Exception e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    public abstract Key a() throws SmCryptoProviderException;

    protected void e(byte[] encryptKey) throws NoSuchAlgorithmException, SmCryptoProviderException {
        if (encryptKey == null) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_ENCRYPTION_KEY"));
        }
        byte[] encryptKeyData = this.g(encryptKey);
        this.r = new SecretKeySpec(encryptKeyData, this.i);
    }

    protected void f(byte[] decryptKey) throws NoSuchAlgorithmException, SmCryptoProviderException {
        if (decryptKey == null) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_DECRYPTION_KEY"));
        }
        byte[] decryptKeyData = this.g(decryptKey);
        this.s = new SecretKeySpec(decryptKeyData, this.i);
    }

    protected void a(Key encryptKey) throws SmCryptoProviderException {
        if (encryptKey == null) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_ENCRYPTION_KEY"));
        }
        if (encryptKey.getAlgorithm() == null || !encryptKey.getAlgorithm().equals(this.i)) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_KEY_ALGORITHM") + encryptKey.getAlgorithm());
        }
        this.r = encryptKey;
    }

    protected void b(Key decryptKey) throws SmCryptoProviderException {
        if (decryptKey == null) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_DECRYPTION_KEY"));
        }
        if (decryptKey.getAlgorithm() == null || !decryptKey.getAlgorithm().equals(this.i)) {
            throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_KEY_ALGORITHM") + decryptKey.getAlgorithm());
        }
        this.s = decryptKey;
    }

    protected void a(byte[] initVector, boolean bUseEncKeyForIV) throws GeneralSecurityException, SmCryptoProviderException {
        this.q = initVector;
        if (this.q == null) {
            int blockSize = this.f();
            byte[] keyData = null;
            keyData = bUseEncKeyForIV ? this.r.getEncoded() : this.s.getEncoded();
            if (keyData == null || keyData.length < blockSize) {
                String error = null;
                try {
                    error = new String(keyData, "UTF-8");
                }
                catch (UnsupportedEncodingException e2) {
                    throw new SmCryptoProviderException(e2);
                }
                throw new SmCryptoProviderException(g.getString("M_SMCRYPTO_INVALID_INIT_VECTOR") + error);
            }
            this.q = new byte[blockSize];
            System.arraycopy(keyData, 0, this.q, 0, blockSize);
        }
    }

    protected void b() throws SmCryptoProviderException {
    }

    protected abstract Cipher c() throws GeneralSecurityException, SmCryptoProviderException;

    protected abstract Cipher d() throws GeneralSecurityException, SmCryptoProviderException;

    protected byte[] b(byte[] input, boolean bEncryptionMode) throws GeneralSecurityException, SmCryptoProviderException {
        return null;
    }

    protected byte[] a(byte[] input, int inLength, boolean bEncryptionMode) throws GeneralSecurityException, SmCryptoProviderException {
        return null;
    }

    protected int e() {
        return this.v;
    }

    protected int f() throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.h, (Provider)p);
        return cipher.getBlockSize();
    }

    protected byte[] g(byte[] input) throws NoSuchAlgorithmException {
        if (input == null) {
            return null;
        }
        byte[] keyData = new byte[this.o];
        byte[] rawData = input;
        if (this.k != null) {
            MessageDigest md = MessageDigest.getInstance(this.k, (Provider)p);
            rawData = md.digest(input);
        }
        if (rawData.length >= this.o) {
            System.arraycopy(rawData, 0, keyData, 0, this.o);
        } else {
            System.arraycopy(rawData, 0, keyData, 0, rawData.length);
            Arrays.fill(keyData, rawData.length, this.o, (byte)0);
        }
        return keyData;
    }
}

