/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmSecureRandom;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;

class SmRC4SHA1CryptoProvider
extends SmCryptoProvider {
    protected MessageDigest m_md = null;

    SmRC4SHA1CryptoProvider(String keyDigestAlg, boolean bAscii) throws SmCryptoProviderException {
        this.m_transformation = "RC4";
        this.m_algorithm = "RC4";
        this.m_digestAlg = "SHA";
        this.m_keyDigestAlg = keyDigestAlg;
        this.m_verifyDigest = true;
        this.m_bAscii = bAscii;
        try {
            this.m_md = MessageDigest.getInstance(this.m_digestAlg, (Provider)m_provider);
            this.m_digestLength = this.m_md.getDigestLength();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new SmCryptoProviderException(e2);
        }
        this.m_keySize = 16;
        this.m_bCipherCanDoFinal = false;
    }

    public Key generateKey() throws SmCryptoProviderException {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(this.m_algorithm, (Provider)m_provider);
            keygen.init(this.m_keyStrength, SmSecureRandom.get());
            return keygen.generateKey();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    protected Cipher getEncrypter() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.m_transformation, (Provider)m_provider);
        cipher.init(1, this.m_encryptKey, SmSecureRandom.get());
        return cipher;
    }

    protected Cipher getDecrypter() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.m_transformation, (Provider)m_provider);
        cipher.init(2, this.m_decryptKey, SmSecureRandom.get());
        return cipher;
    }

    protected byte[] makeDigest(byte[] input, boolean mode) throws NoSuchAlgorithmException {
        return this.makeDigest(input, input.length, mode);
    }

    protected byte[] makeDigest(byte[] input, int inLength, boolean mode) throws NoSuchAlgorithmException {
        MessageDigest md = null;
        try {
            md = (MessageDigest)this.m_md.clone();
            md.reset();
        }
        catch (CloneNotSupportedException e2) {
            md = null;
        }
        if (md == null) {
            md = MessageDigest.getInstance(this.m_digestAlg, (Provider)m_provider);
        }
        md.update(this.m_initVector);
        md.update(input, 0, inLength);
        return md.digest();
    }
}

