/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.connection;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.bz;
import com.ca.siteminder.sdk.agentapi.config.k;
import com.ca.siteminder.sdk.agentapi.connection.m;
import com.ca.siteminder.sdk.agentapi.connection.p;
import com.ca.siteminder.sdk.agentapi.connection.q;
import com.ca.siteminder.sdk.agentapi.connection.r;
import com.ca.siteminder.sdk.agentapi.connection.s;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.resources.SmConnectionMessages;
import com.ca.siteminder.sdk.agentapi.tli.bc;
import com.ca.siteminder.sdk.agentapi.tli.t;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.ResourceBundle;

class o
extends p
implements SmAgentApiConstants {
    private static final String a = "SmCluster";
    private static final String b = SmConnectionMessages.getName();
    private static ResourceBundle c = ResourceBundle.getBundle(b);
    private static int d = 0;
    private s[] e = null;
    private int f = 0;
    private int g = 0;
    private int h = 0;
    private int i = 0;
    private int j = 0;
    private int k = 0;
    private double[] l = null;
    private Object m = new Object();
    private int n = 0;

    o() {
        this.j = d++;
        if (bz.a()) {
            bz.a(5, a, a, "Creating cluster index = " + this.j);
        }
        try {
            ((p)this).i = new q(20000L, true);
        }
        catch (r r2) {
            // empty catch block
        }
    }

    void a(int maxServers, int failoverThresholdPercent) throws r {
        String methodName = "init";
        if (bz.a()) {
            bz.a(5, a, "init", "Started init");
        }
        if (this.e != null) {
            if (bz.a()) {
                bz.a(2, a, "init", "Re-initializing on an already-intialized cluster");
            }
            throw new r(c.getString("M_CLUSTER_ALREADY_INITIALIZED"));
        }
        if (failoverThresholdPercent < 0 || failoverThresholdPercent > 100 || maxServers <= 0) {
            if (bz.a()) {
                bz.a(2, a, "init", "Invalid failoverThresholdPercent");
            }
            throw new r(c.getString("M_INVALID_CONFIG_INFO"));
        }
        this.e = new s[maxServers];
        Arrays.fill(this.e, null);
        this.g = maxServers;
        this.h = failoverThresholdPercent;
        this.l = new double[2 * this.g];
        this.c();
        if (bz.a()) {
            bz.a(4, a, "init", "Changing cluster state from init to disabled for id = " + this.j);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(SocketAddress serverAddress, m initDef, int version) throws r {
        String methodName = "addServer";
        Object object = this.m;
        synchronized (object) {
            if (this.e == null) {
                if (bz.a()) {
                    bz.a(2, a, "addServer", "Adding servers to an unintialized cluster!");
                }
                throw new r(c.getString("M_CLUSTER_NOT_INITIALIZED"));
            }
            if (this.f >= this.g) {
                if (bz.a()) {
                    bz.a(2, a, "addServer", "Invalid servers - #servers = " + this.f + ", maxServers = " + this.g);
                }
                throw new r(c.getString("M_INVALID_CONFIG_INFO"));
            }
            boolean newslot = false;
            s newServer = new s();
            try {
                newServer.a(serverAddress, initDef, version);
            }
            catch (r e2) {
                if (bz.a()) {
                    bz.a(2, a, "addServer", "Failed to add server " + serverAddress.toString() + " to cluster " + this.j);
                    e2.printStackTrace();
                }
                newServer.b(0, 5);
                throw e2;
            }
            catch (Throwable t2) {
                if (bz.a()) {
                    bz.a(2, a, "addServer", "Failed to add server " + serverAddress.toString() + " to cluster " + this.j);
                    t2.printStackTrace();
                }
                newServer.b(0, 5);
                throw new r(c.getString("M_INVALID_CONFIG_INFO"), t2);
            }
            if (bz.a()) {
                bz.a(4, a, "addServer", "Added a new server, hostname = " + serverAddress + ", to cluster id = " + this.j);
            }
            newServer.b(0, 3);
            this.e[this.f++] = newServer;
            this.k = (int)((long)this.k + newServer.b());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    bc a(bc request, int[] status) throws r, SmCryptoProviderException, k {
        String methodName = "processRequest";
        long start = System.currentTimeMillis();
        int[] returnCode = new int[]{-1};
        while (true) {
            int i2;
            s curServer;
            Object object = this.m;
            synchronized (object) {
                curServer = this.a();
                if (curServer == null) {
                    status[0] = returnCode[0] == -2 ? -2 : -1;
                    if (bz.a()) {
                        bz.a(4, a, "processRequest", "No active servers found for cluster id = " + this.j + ", setting status = " + status[0]);
                    }
                    return null;
                }
            }
            bc response = curServer.a(request, returnCode);
            if (bz.a()) {
                bz.a(5, a, "processRequest", "Server " + curServer.g + " returned " + returnCode[0]);
            }
            Object object2 = this.m;
            synchronized (object2) {
                if (returnCode[0] == 0) {
                    if (bz.a()) {
                        bz.a(5, a, "processRequest", "Server process request returned successfully");
                    }
                    curServer.b(1, 2);
                    long now = System.currentTimeMillis();
                    curServer.j().a(now, now - start);
                    status[0] = 0;
                    return response;
                }
                if (curServer.b(2, 4)) {
                    if (bz.a()) {
                        bz.a(5, a, "processRequest", "Changing active server " + curServer.g + " to intermediate");
                    }
                } else {
                    if (bz.a()) {
                        bz.a(5, a, "processRequest", "Server " + curServer.g + " wasn't active, trying another");
                    }
                    continue;
                }
            }
            if (returnCode[0] == -2) {
                if (bz.a()) {
                    bz.a(5, a, "processRequest", "Got timeout from server " + curServer.g);
                }
                object2 = this.m;
                synchronized (object2) {
                    boolean bDeleteTimedOutConnection = false;
                    if (this.e.length == 1 && curServer.m() == 1) {
                        bDeleteTimedOutConnection = true;
                    }
                    for (i2 = 0; i2 < this.e.length; ++i2) {
                        int srState = this.e[i2].i();
                        if (srState != 2 && srState != 1 && srState != 4) continue;
                        if (bz.a()) {
                            bz.a(5, a, "processRequest", "Deleting idle connections for server " + curServer.g);
                        }
                        this.e[i2].b(bDeleteTimedOutConnection);
                    }
                }
            }
            if (curServer.m() > 0) {
                object2 = this.m;
                synchronized (object2) {
                    if (curServer.b(4, 1) && bz.a()) {
                        bz.a(5, a, "processRequest", "Connections left, changing from interm. to inactive for server " + curServer.g);
                    }
                }
            }
            if (bz.a()) {
                bz.a(5, a, "processRequest", "No connections left, creating 1 for server " + curServer.g);
            }
            boolean bInitResult = curServer.a(1);
            Object bDeleteTimedOutConnection = this.m;
            synchronized (bDeleteTimedOutConnection) {
                if (bInitResult) {
                    if (curServer.b(4, 2) && bz.a()) {
                        bz.a(5, a, "processRequest", "Creating connection succeeded, changing intermed. to success for server " + curServer.g);
                    }
                } else if (curServer.b(4, 1) && bz.a()) {
                    bz.a(5, a, "processRequest", "Creating connection failed, changing intermed. to inactive for server " + curServer.g);
                }
            }
            object2 = this.m;
            synchronized (object2) {
                int activecount = 0;
                for (i2 = 0; i2 < this.e.length; ++i2) {
                    if (this.e[i2].i() != 2) continue;
                    ++activecount;
                }
                if (bz.a()) {
                    bz.a(5, a, "processRequest", "Found active server count = " + activecount + ", for cluster " + this.j);
                }
                if (activecount < this.i) {
                    curServer.b(2, 1);
                    status[0] = returnCode[0] == -2 ? -2 : -1;
                    if (bz.a()) {
                        bz.a(5, a, "processRequest", "Active count < failoverthreshhold, setting status = " + status[0]);
                    }
                    return null;
                }
            }
            if (System.currentTimeMillis() - start > (long)(2000 * this.k)) break;
        }
        if (bz.a()) {
            bz.a(5, a, "processRequest", "Aborting / timeout to prevent looping forever");
        }
        status[0] = -2;
        return null;
    }

    s a() {
        String methodName = "getServer";
        int best = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int j2 = 0; j2 < this.e.length; ++j2) {
                if (this.l[2 * j2] > 0.0 && this.e[j2].i() != 2) {
                    this.b();
                    j2 = -1;
                    i2 = 2;
                    continue;
                }
                if (!(this.l[2 * j2] > this.l[2 * best])) continue;
                best = j2;
            }
            if (!(this.l[2 * best] <= 0.0)) continue;
            this.b();
        }
        int doubleBest = 2 * best;
        if (this.l[doubleBest] <= 0.0) {
            if (bz.a()) {
                bz.a(5, a, "getServer", "No good servers found for cluster id " + this.j);
            }
            return null;
        }
        if (bz.a()) {
            bz.a(5, a, "getServer", "Using server " + this.e[best].g + ": goodness " + this.l[doubleBest] + ", step " + this.l[doubleBest + 1]);
        }
        int n2 = doubleBest;
        this.l[n2] = this.l[n2] - this.l[doubleBest + 1];
        return this.e[best];
    }

    void b() {
        String methodName = "recalibrateDistribution";
        if (bz.a()) {
            bz.a(5, a, "recalibrateDistribution", "Recalibrating for cluster id " + this.j);
        }
        this.c();
        int i2 = 0;
        double totalTput = 0.0;
        for (i2 = 0; i2 < this.e.length; ++i2) {
            if (this.e[i2].i() != 2) continue;
            double resptime = this.e[i2].j().a();
            double thr = 1000.0 / (resptime + 1.0);
            this.l[2 * i2] = 100.0;
            this.l[2 * i2 + 1] = thr;
            totalTput += thr;
        }
        if (totalTput > 0.0) {
            for (i2 = 0; i2 < this.e.length; ++i2) {
                if (this.e[i2].i() != 2) continue;
                this.l[2 * i2 + 1] = totalTput / this.l[2 * i2 + 1];
            }
        }
    }

    void c() {
        Arrays.fill(this.l, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean d() throws r, SmCryptoProviderException, k {
        String methodName = "enable";
        if (bz.a()) {
            bz.a(5, a, "enable", "Attempting to enable cluster id = " + this.j);
        }
        int activecount = 0;
        this.n = 0;
        Object object = this.m;
        synchronized (object) {
            this.i = (int)Math.max(1.0, Math.ceil((double)this.h * (double)this.e.length / 100.0));
            for (int i2 = 0; i2 < this.e.length; ++i2) {
                if (bz.a()) {
                    bz.a(5, a, "enable", "Attempting to enable server index = " + i2);
                }
                if (this.e[i2].d()) {
                    if (bz.a()) {
                        bz.a(5, a, "enable", "Success enabling server index = " + i2);
                    }
                    this.e[i2].b(3, 2);
                    ++activecount;
                    continue;
                }
                if (bz.a()) {
                    bz.a(3, a, "enable", "Failed enabling server index = " + i2);
                }
                this.e[i2].b(3, 1);
                if (!this.e[i2].n()) continue;
                ++this.n;
            }
        }
        if (activecount < this.i) {
            if (bz.a()) {
                bz.a(4, a, "enable", "Failed to activate cluster id = " + this.j);
            }
            return false;
        }
        if (bz.a()) {
            bz.a(4, a, "enable", "Activating cluster id = " + this.j);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void e() {
        if (bz.a()) {
            bz.a(4, a, "disable", "Disabling all servers for cluster id = " + this.j);
        }
        Object object = this.m;
        synchronized (object) {
            for (int i2 = 0; i2 < this.e.length; ++i2) {
                this.e[i2].e();
                this.e[i2].b(this.e[i2].i(), 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean f() throws r, SmCryptoProviderException, k {
        String methodName = "revive";
        int activecount = 0;
        if (bz.a()) {
            bz.a(4, a, "revive", "Reviving cluster id = " + this.j);
        }
        for (int i2 = 0; i2 < this.e.length; ++i2) {
            s server = null;
            Object object = this.m;
            synchronized (object) {
                int srState = this.e[i2].i();
                if (srState == 2) {
                    ++activecount;
                } else if (srState == 1 && this.e[i2].b(1, 4)) {
                    server = this.e[i2];
                }
            }
            if (server == null) continue;
            if (server.m() > 0) {
                int retryRes = server.l();
                Object object2 = this.m;
                synchronized (object2) {
                    switch (retryRes) {
                        case 0: {
                            if (bz.a()) {
                                bz.a(4, a, "revive", "Revived timed-out connections to server + " + this.e[i2] + " succesfully");
                            }
                            if (!server.b(4, 2)) break;
                            ++activecount;
                            break;
                        }
                        case -1: {
                            if (bz.a()) {
                                bz.a(4, a, "revive", "Failed to revive timed-out connections, killing all connections to server " + this.e[i2]);
                            }
                            server.f();
                            server.b(4, 1);
                            break;
                        }
                        default: {
                            if (bz.a()) {
                                bz.a(4, a, "revive", "No connections found to retry for server " + this.e[i2] + " state " + this.e[i2].i());
                            }
                            server.b(4, 1);
                        }
                    }
                    continue;
                }
            }
            boolean bInitResult = server.a(1);
            Object object3 = this.m;
            synchronized (object3) {
                if (bInitResult) {
                    if (bz.a()) {
                        bz.a(4, a, "revive", "Created initial connection to server " + this.e[i2]);
                    }
                    if (server.b(4, 2)) {
                        ++activecount;
                    }
                } else {
                    if (bz.a()) {
                        bz.a(4, a, "revive", "Failed to create initial connection to server " + this.e[i2]);
                    }
                    server.b(4, 1);
                }
                continue;
            }
        }
        return activecount >= this.i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int g() {
        int nSize = t.a();
        boolean gotValidLimit = false;
        Object object = this.m;
        synchronized (object) {
            int trialSize = 0;
            for (int i2 = 0; i2 < this.e.length; ++i2) {
                if (this.e[i2].i() == 3 || this.e[i2].i() == 5) continue;
                trialSize = this.e[i2].g();
                if (trialSize < nSize) {
                    if (trialSize < t.b()) continue;
                    nSize = trialSize;
                    gotValidLimit = true;
                    continue;
                }
                if (gotValidLimit) continue;
                gotValidLimit = true;
            }
        }
        if (!gotValidLimit) {
            nSize = t.b();
        }
        return nSize;
    }

    void a(OutputStream stream) {
        int i2;
        PrintStream out = null;
        out = stream instanceof PrintStream ? (PrintStream)stream : new PrintStream(stream);
        int activeServerCount = 0;
        for (i2 = 0; i2 < this.e.length; ++i2) {
            if (this.e[i2].i() != 2) continue;
            ++activeServerCount;
        }
        out.println("    Cluster [" + this.j + "]:");
        out.println("        state is " + this.h());
        out.println("        active servers/threshold are " + activeServerCount + "/" + this.i);
        out.println("        average response time is " + String.valueOf(((p)this).i.a()) + " (msec)");
        out.println("        throughput is " + String.valueOf(((p)this).i.b()) + " (req/sec)");
        out.println("        max throughput is " + String.valueOf(((p)this).i.d()) + " (req/sec)");
        out.println("        min throughput is " + String.valueOf(((p)this).i.e()) + " (req/sec)");
        out.println("        avg throughput is " + String.valueOf(((p)this).i.c()) + " (req/sec)");
        out.println("        Servers:");
        for (i2 = 0; i2 < this.e.length; ++i2) {
            this.e[i2].a(stream);
        }
    }

    int l() {
        return this.n;
    }
}

