/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.connection;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.config.SmConfigException;
import com.ca.siteminder.sdk.agentapi.config.SmConfigFile;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.resources.SmConnectionMessages;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentPacket;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentSession;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTcpTransport;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliException;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.ResourceBundle;

class SmServerConnection
implements SmAgentApiConstants {
    private static final String CLASS_NAME = "SmServerConnection";
    private static final String MESSAGES_CLASSNAME = SmConnectionMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    static final int STATE_CN_INIT = 0;
    static final int STATE_CN_FREE = 1;
    static final int STATE_CN_BUSY = 2;
    static final int STATE_CN_TIMEDOUT = 3;
    static final int STATE_CN_ABORTING = 4;
    private SmAgentSession m_session;
    private String m_deviceName;
    private String m_sharedSecret;
    private SocketAddress m_sockAddr;
    private SmConfigFile m_configFile;
    private int m_state = 0;
    private long m_lastResponseTimestamp;
    private long m_timedOutTimestamp;
    private long m_requestStartTimestamp;

    SmServerConnection() {
    }

    void init(SocketAddress sa, SmConfigFile configFile, int apiVersion) throws SmAgentApiConnectionException {
        this.init(sa, configFile, apiVersion, 30000L);
    }

    void init(SocketAddress sa, SmConfigFile configFile, int apiVersion, long timeout) throws SmAgentApiConnectionException {
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "init", "Attempt to init connection");
        }
        if (this.m_state == 0) {
            try {
                this.m_deviceName = this.m_configFile.getAttribute(SM_CONF_HOST_NAME);
                this.m_sharedSecret = this.m_configFile.getAttribute(SM_CONF_SHARED_SECRET);
            }
            catch (Exception e2) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "init", "Unable to get agent name or shared secret");
                }
                throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_CONFIG_INFO"), (Throwable)e2);
            }
            this.m_sockAddr = sa;
            this.m_configFile = configFile;
            this.m_state = 2;
            this.m_timedOutTimestamp = 0L;
            this.m_requestStartTimestamp = 0L;
            this.m_lastResponseTimestamp = 0L;
            this.m_session = new SmAgentTliSession(this.m_deviceName, this.m_sharedSecret);
        }
    }

    void init(SocketAddress sa, SmConfigFile configFile, String agentName, String sharedSecret, int apiVersion) {
        this.init(sa, configFile, agentName, sharedSecret, apiVersion, 30000L);
    }

    void init(SocketAddress sa, SmConfigFile configFile, String agentName, String sharedSecret, int apiVersion, long timeout) {
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "init", "Attempt to init connection");
        }
        if (this.m_state == 0) {
            this.m_sockAddr = sa;
            this.m_deviceName = agentName;
            this.m_sharedSecret = sharedSecret;
            this.m_configFile = configFile;
            this.m_state = 2;
            this.m_timedOutTimestamp = 0L;
            this.m_requestStartTimestamp = 0L;
            this.m_lastResponseTimestamp = 0L;
            this.m_session = new SmAgentTliSession(this.m_deviceName, this.m_sharedSecret);
        }
    }

    void release() {
        if (this.m_state != 0) {
            try {
                this.m_session.teardown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_state = 0;
            this.m_session = null;
        }
    }

    String getSharedSecret() {
        return this.m_sharedSecret;
    }

    void setSharedSecret(String sharedSecret) {
        this.m_sharedSecret = sharedSecret;
    }

    int getState() {
        return this.m_state;
    }

    void setState(int newState) {
        this.m_state = newState;
    }

    long getRequestStartTimestamp() {
        return this.m_requestStartTimestamp;
    }

    void setRequestStartTimestamp(long newTS) {
        this.m_requestStartTimestamp = newTS;
    }

    long getLastResponseTimestamp() {
        return this.m_lastResponseTimestamp;
    }

    public long getTimedOutTimestamp() {
        return this.m_timedOutTimestamp;
    }

    public void setTimedOutTimestamp(long timedOutTimestamp) {
        this.m_timedOutTimestamp = timedOutTimestamp;
    }

    void setLastResponseTimestamp(long newTS) {
        this.m_lastResponseTimestamp = newTS;
    }

    boolean connect() {
        String methodName = "connect";
        boolean bRc = false;
        try {
            SmAgentTcpTransport xport = SmAgentTcpTransport.newInstance(this.m_sockAddr);
            bRc = xport.connect(this.m_sockAddr);
            if (bRc) {
                this.m_session.bindToTransport(xport);
            }
        }
        catch (SmAgentTliException e2) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "connect", "Exception binding to transport: " + e2);
                e2.printStackTrace();
            }
            return false;
        }
        catch (Exception e3) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "connect", "Exception calling TCP transport connect: " + e3);
                e3.printStackTrace();
            }
            return false;
        }
        return bRc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean handshake() throws SmCryptoProviderException, SmConfigException {
        String methodName = "handshake";
        boolean bRc = false;
        try {
            bRc = this.m_session.setup();
        }
        catch (Exception e2) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "handshake", "Failed session setup.");
                e2.printStackTrace();
            }
            return false;
        }
        if (this.m_configFile != null) {
            long timestamp = this.m_session.getNewSharedSecretTimestamp();
            byte[] newSecret = this.m_session.getAndClearNewSharedSecret();
            if (newSecret != null) {
                try {
                    try {
                        String strSecret;
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "handshake", "Updating the shared secret");
                        }
                        if (this.m_configFile.updateSharedSecret(strSecret = new String(newSecret, "UTF-8"), timestamp)) {
                            this.setSharedSecret(SM_CONF_SHARED_SECRET.encrypt(strSecret));
                            if (Util.isLogEnabled()) {
                                Util.display(5, CLASS_NAME, "handshake", "Writing to the configuration file: " + this.m_configFile.getFilename());
                            }
                            this.m_configFile.write();
                        }
                    }
                    catch (UnsupportedEncodingException e3) {
                        if (Util.isLogEnabled()) {
                            Util.display(2, CLASS_NAME, "handshake", "Failed shared secret rollover.");
                            e3.printStackTrace();
                        }
                        boolean bl2 = false;
                        Object var9_9 = null;
                        Arrays.fill(newSecret, (byte)0);
                        return bl2;
                    }
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    Arrays.fill(newSecret, (byte)0);
                    newSecret = null;
                    throw throwable;
                }
                Arrays.fill(newSecret, (byte)0);
                return bRc;
            }
        }
        return bRc;
    }

    SmAgentPacket read(int[] returnStatus) throws IOException {
        SmAgentPacket retPkt;
        int status;
        block3: {
            String methodName = "read";
            status = 0;
            retPkt = null;
            try {
                retPkt = this.m_session.read();
            }
            catch (SmAgentTliException e2) {
                status = e2.isErrorCodeUsed() ? e2.getErrorCode() : -1;
                if (!Util.isLogEnabled()) break block3;
                Util.display(2, CLASS_NAME, "read", "TLI Exception reading the packet with status = " + status + ": " + e2);
                e2.printStackTrace();
            }
        }
        if (returnStatus != null && returnStatus.length > 0) {
            returnStatus[0] = status;
        }
        return retPkt;
    }

    SmAgentPacket read(long timeout, int[] returnStatus) throws IOException {
        SmAgentPacket retPkt;
        int status;
        block3: {
            String methodName = "read";
            status = 0;
            retPkt = null;
            try {
                retPkt = this.m_session.read(timeout);
            }
            catch (SmAgentTliException e2) {
                status = e2.isErrorCodeUsed() ? e2.getErrorCode() : -1;
                if (!Util.isLogEnabled()) break block3;
                Util.display(2, CLASS_NAME, "read", "TLI Exception reading the packet with status = " + status + ": " + e2);
                e2.printStackTrace();
            }
        }
        if (returnStatus != null && returnStatus.length > 0) {
            returnStatus[0] = status;
        }
        return retPkt;
    }

    int write(SmAgentPacket pkt) throws IOException {
        int bytesWritten;
        String methodName = "write";
        try {
            bytesWritten = this.m_session.write(pkt);
        }
        catch (SmAgentTliException e2) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "write", "Exception reading the packet: " + e2);
                e2.printStackTrace();
            }
            if (e2.isErrorCodeUsed()) {
                return e2.getErrorCode();
            }
            return -1;
        }
        if (bytesWritten > 0) {
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "write", "Successfully wrote total bytes = " + bytesWritten);
            }
            return 0;
        }
        if (bytesWritten == 0) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "write", "Failed to write bytes");
            }
            return -1;
        }
        return bytesWritten;
    }

    int write(SmAgentPacket pkt, long timeout) throws IOException {
        int bytesWritten;
        String methodName = "write";
        try {
            bytesWritten = this.m_session.write(pkt, timeout);
        }
        catch (SmAgentTliException e2) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "write", "Exception reading the packet: " + e2);
                e2.printStackTrace();
            }
            if (e2.isErrorCodeUsed()) {
                return e2.getErrorCode();
            }
            return -1;
        }
        if (bytesWritten > 0) {
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "write", "Successfully wrote total bytes = " + bytesWritten);
            }
            return 0;
        }
        if (bytesWritten == 0) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "write", "Failed to write bytes");
            }
            return -1;
        }
        return bytesWritten;
    }

    int flush() {
        String methodName = "flush";
        SmAgentPacket tmpPkt = null;
        try {
            tmpPkt = this.m_session.read(-1L);
        }
        catch (IOException e2) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "flush", "Failed flushing connection: " + this.toString() + ": " + e2);
                e2.printStackTrace();
            }
            return -1;
        }
        catch (SmAgentTliException e3) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "flush", "exFailed flushing connection: " + this.toString() + ": " + e3);
                e3.printStackTrace();
            }
            if (e3.isErrorCodeUsed()) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "flush", "geterror " + e3.getErrorCode());
                }
                return e3.getErrorCode();
            }
            return -1;
        }
        return tmpPkt == null ? -1 : 0;
    }

    public String toString() {
        return "deviceName = " + this.m_deviceName + ", state = " + this.m_state;
    }
}

