/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.connection;

import com.ca.siteminder.sdk.agentapi.config.SmConfigException;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.connection.SmRequestCounter;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentPacket;
import java.io.OutputStream;

abstract class SmHandle {
    static final int STATE_INIT = 0;
    static final int STATE_INACTIVE = 1;
    static final int STATE_ACTIVE = 2;
    static final int STATE_DISABLED = 3;
    static final int STATE_INTERMEDIATE = 4;
    static final int STATE_FAILED = 5;
    private static final String[] c_status = new String[]{"INIT", "INACTIVE", "ACTIVE", "DISABLED", "INTER", "FAILED"};
    private int m_state = 0;
    protected SmRequestCounter m_counter = null;

    SmHandle() {
    }

    abstract SmAgentPacket processRequest(SmAgentPacket var1, int[] var2) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException;

    abstract boolean enable() throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException;

    abstract void disable() throws SmAgentApiConnectionException;

    String getStatus() {
        return c_status[this.m_state];
    }

    int getState() {
        return this.m_state;
    }

    private void setState(int state) {
        if (this.m_state != state) {
            this.m_state = state;
            if (this.m_state != 2 && this.m_counter != null) {
                this.m_counter.reset();
            }
        }
    }

    boolean setState(int fromState, int toState) {
        if (this.m_state != fromState) {
            return false;
        }
        this.setState(toState);
        return true;
    }

    abstract int getMaxBufferSize() throws SmAgentApiConnectionException;

    SmRequestCounter getRequestCounter() {
        return this.m_counter;
    }

    abstract void logStats(OutputStream var1);

    void logStats() {
        this.logStats(System.out);
    }
}

