/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.policyapi;

import com.netegrity.sdk.policyapi.SmObjId;
import com.netegrity.sdk.policyapi.SmObjectImpl;
import java.util.Hashtable;

public final class SmCertMap
extends SmObjectImpl {
    public static final String PropCertMaps = "CertMaps";
    public static final String PropIssuerDN = "IssuerDN";
    public static final String PropUserDirectory = "UserDirectory";
    public static final String PropMapToLDAP = "MapToLDAP";
    public static final String PropLDAPCaDN = "LDAPCaDN";
    public static final String PropDirType = "DirType";
    public static final String PropFlags = "Flags";
    public static final int DirType_LDAP = 1;
    public static final int DirType_WinNT = 2;
    public static final int DirType_ODBC = 3;
    public static final int CertMapAttrType_Single = 1;
    public static final int CertMapAttrType_Custom = 2;
    public static final int CertMapAttrType_Exact = 3;
    public static final int CertMapFlags_CertRequired = 1;
    public static final int CertMapFlags_UseDistributionPoints = 2;
    public static final int CertMapFlags_VerifySignature = 4;
    public static final int CertMapFlags_CRLCheck = 8;
    public static final int CertMapFlags_Cache = 16;
    private SmObjId m_UserDir = SmObjId.valueOf(SmObjId.NULL_OID.toString());
    private String m_szIssuerDN = "";
    private String m_szCADN = "";
    private String m_szMapAttr = "%{UID}";
    private int m_nFlags = 0;
    private int m_nAttrType = 1;
    private int m_nDirType = 1;

    public SmCertMap() {
        super("CertMap", "", "");
    }

    public SmCertMap(String string) {
        this();
        this.setOid(string);
    }

    public String getName() {
        return null;
    }

    public String toString() {
        String string;
        switch (this.m_nDirType) {
            case 1: {
                string = "LDAP";
                break;
            }
            case 2: {
                string = "WinNT";
                break;
            }
            case 3: {
                string = "ODBC";
                break;
            }
            default: {
                String string2 = "";
                return null;
            }
        }
        string = string + " + " + this.getIssuerDN();
        return string;
    }

    public void setName(String string) {
    }

    public void setDescription(String string) {
        this.m_szDesc = null;
    }

    public String getDescription() {
        return null;
    }

    public void setUserDir(Object object) {
        this.m_UserDir = SmObjId.valueOf(object.toString());
    }

    public SmObjId getUserDir() {
        return this.m_UserDir;
    }

    public void setIssuerDN(String string) {
        this.m_szIssuerDN = string;
    }

    public String getIssuerDN() {
        return this.m_szIssuerDN;
    }

    public void setCADN(String string) {
        this.m_szCADN = string;
    }

    public String getCADN() {
        return this.m_szCADN;
    }

    public void setFlags(int n) {
        this.m_nFlags = n;
    }

    public int getFlags() {
        return this.m_nFlags;
    }

    public void setAttrType(int n) {
        this.m_nAttrType = n;
    }

    public int getAttrType() {
        return this.m_nAttrType;
    }

    public void setMapAttr(String string) {
        this.m_szMapAttr = string;
    }

    public String getMapAttr() {
        return this.m_szMapAttr;
    }

    public void setDirType(int n) {
        this.m_nDirType = n;
        super.setName(this.toString());
    }

    public int getDirType() {
        return this.m_nDirType;
    }

    public void writeProperties(Hashtable hashtable) {
        super.writeProperties(hashtable);
        if (this.getIssuerDN() != null) {
            hashtable.put(PropIssuerDN, this.getIssuerDN());
        }
        if (this.getUserDir() != null) {
            hashtable.put(PropUserDirectory, this.getUserDir());
        }
        if (this.getMapAttr() != null) {
            hashtable.put(PropMapToLDAP, this.getMapAttr());
        }
        if (this.getCADN() != null) {
            hashtable.put(PropLDAPCaDN, this.getCADN());
        }
        hashtable.put(PropDirType, new Integer(this.getDirType()));
        hashtable.put(PropFlags, new Integer(this.getFlags()));
    }

    public void readProperties(Hashtable hashtable) {
        super.readProperties(hashtable);
        this.setIssuerDN(this.getStringProp(hashtable, PropIssuerDN));
        this.setUserDir(this.getObjIdProp(hashtable, PropUserDirectory));
        this.setMapAttr(this.getStringProp(hashtable, PropMapToLDAP));
        this.setCADN(this.getStringProp(hashtable, PropLDAPCaDN));
        this.setDirType(this.getIntProp(hashtable, PropDirType));
        this.setFlags(this.getIntProp(hashtable, PropFlags));
        this.m_szMapAttr = this.m_szMapAttr.trim();
        if (this.m_szMapAttr == null || this.m_szMapAttr.length() == 0) {
            this.m_nAttrType = 3;
        } else if (this.m_szMapAttr.startsWith("%{")) {
            this.m_nAttrType = 1;
        } else if (this.m_szMapAttr != null || this.m_szMapAttr.length() != 0) {
            this.m_nAttrType = 2;
        }
    }
}

