/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.dmsapi;

import com.netegrity.sdk.apiutil.SmApiObject;
import com.netegrity.sdk.apiutil.SmApiSession;
import com.netegrity.sdk.dmsapi.SmDmsConfig;
import com.netegrity.sdk.dmsapi.SmDmsGroup;
import com.netegrity.sdk.dmsapi.SmDmsObject;
import com.netegrity.sdk.dmsapi.SmDmsOrganization;
import com.netegrity.sdk.dmsapi.SmDmsRole;
import com.netegrity.sdk.dmsapi.SmDmsSearchResultParams;
import com.netegrity.sdk.dmsapi.SmDmsUser;
import com.netegrity.sdk.policyapi.SmRealm;
import com.netegrity.sdk.policyapi.SmUserDirectory;
import java.util.Hashtable;
import java.util.Vector;

public class SmDmsSearch {
    public static final int Reset = 0;
    public static final int Forward = 1;
    public static final int Back = 2;
    public static final int Refresh = 3;
    private int m_nMaxItems = 50;
    private int m_nItemsReturned = 0;
    private int m_nItemsFound = 0;
    private int m_nNextItem = -1;
    private int m_nPreviousItem = -1;
    private int m_nEOSfound = 0;
    private int m_nClassId = 0;
    private int m_nScope = -1;
    private int m_nMaxResults = -1;
    private int m_nTimeout = -1;
    private String m_szFilter = "";
    private String m_szRoot = "";
    private String m_szNextDn = "";
    private String m_szPreviousDn = "";
    private String[] m_PropertyNames = null;
    private Vector m_Results = null;
    private SmApiSession m_ApiSession = null;
    private SmRealm m_Realm = null;
    private SmUserDirectory m_UserDirectory = null;
    private SmDmsConfig m_dmsConfig = null;
    private String m_OrgDn = "";
    private static final int VersionNumber = 1;
    private static final String PropNameVersion = "version";
    private static final String PropNameMaxItems = "maxitems";
    private static final String PropNameItemsFound = "numitemsfound";
    private static final String PropNameItemsReturned = "numitems";
    private static final String PropNameFilter = "filter";
    private static final String PropNameRoot = "root";
    private static final String PropNameOrgDn = "orgdn";
    private static final String PropNameProperties = "properties";
    private static final String PropNameResults = "results";
    private static final String PropNameNextItem = "nextitem";
    private static final String PropNamePreviousItem = "previousitem";
    private static final String PropNameNextDn = "nextdn";
    private static final String PropNamePreviousDn = "previousdn";
    private static final String PropScope = "scope";
    private static final String PropMaxResults = "maxresults";
    private static final String PropTimeout = "timeout";
    private static final String PropClassId = "classid";
    private static final String EndOfSearch = "uid=###eos###";

    public SmDmsSearch() {
    }

    public SmDmsSearch(String string) {
        this.setFilter(string);
    }

    public SmDmsSearch(String string, String string2) {
        this.setFilter(string);
        this.setRoot(string2);
    }

    public SmDmsSearch(String string, String string2, int n) {
        this(string, string2);
        this.setMaxItems(n);
    }

    public SmDmsSearch(String string, String string2, String[] stringArray) {
        this(string, string2);
        this.setPropertyNames(stringArray);
    }

    public SmDmsSearch(String string, String string2, String[] stringArray, int n) {
        this(string, string2, n);
        this.setPropertyNames(stringArray);
    }

    public int getMaxItems() {
        return this.m_nMaxItems;
    }

    public void setMaxItems(int n) {
        this.m_nMaxItems = n;
    }

    public int getClassId() {
        return this.m_nClassId;
    }

    public void setClassId(int n) {
        this.m_nClassId = n;
    }

    public int getScope() {
        return this.m_nScope;
    }

    public void setScope(int n) {
        this.m_nScope = n;
    }

    public int getMaxResults() {
        return this.m_nMaxResults;
    }

    public void setMaxResults(int n) {
        this.m_nMaxResults = n;
    }

    public int getTimeout() {
        return this.m_nTimeout;
    }

    public void setTimeout(int n) {
        this.m_nTimeout = n;
    }

    public int getNumberItemsFound() {
        return this.m_nItemsFound;
    }

    public int getNumberItemsReturned() {
        return this.m_nItemsReturned;
    }

    public int getNextItem() {
        return this.m_nNextItem;
    }

    public void setNextItem(int n) {
        this.m_nNextItem = n;
    }

    public int getPreviousItem() {
        return this.m_nPreviousItem;
    }

    public void setPreviousItem(int n) {
        this.m_nPreviousItem = n;
    }

    public String getFilter() {
        return this.m_szFilter;
    }

    public void setFilter(String string) {
        this.m_szFilter = string;
    }

    public String getRoot() {
        return this.m_szRoot;
    }

    public void setRoot(String string) {
        this.m_szRoot = string;
    }

    public String[] getPropertyNames() {
        return this.m_PropertyNames;
    }

    public void setPropertyNames(String[] stringArray) {
        this.m_PropertyNames = stringArray;
    }

    public Vector getResults() {
        SmDmsSearchResultParams smDmsSearchResultParams = new SmDmsSearchResultParams(this.m_nItemsReturned, this.m_nItemsFound, this.m_nNextItem + 1, this.m_nPreviousItem + 1);
        if (this.m_Results == null) {
            this.m_Results = new Vector();
        }
        this.m_Results.insertElementAt(smDmsSearchResultParams, 0);
        return this.m_Results;
    }

    public void clearResults() {
        if (this.m_Results != null) {
            this.m_Results.setSize(0);
        }
        this.m_nEOSfound = 0;
    }

    public void writeProperties(Hashtable hashtable) {
        hashtable.clear();
        hashtable.put(PropNameVersion, new Integer(1));
        hashtable.put(PropNameMaxItems, new Integer(this.getMaxItems()));
        hashtable.put(PropNameNextItem, new Integer(this.m_nNextItem));
        hashtable.put(PropNamePreviousItem, new Integer(this.m_nPreviousItem));
        hashtable.put(PropNameFilter, this.getFilter());
        hashtable.put(PropNameRoot, this.getRoot());
        hashtable.put(PropNameOrgDn, this.m_OrgDn);
        hashtable.put(PropNameNextDn, this.m_szNextDn);
        hashtable.put(PropNamePreviousDn, this.m_szPreviousDn);
        hashtable.put(PropScope, new Integer(this.m_nScope));
        hashtable.put(PropMaxResults, new Integer(this.m_nMaxResults));
        hashtable.put(PropTimeout, new Integer(this.m_nTimeout));
        hashtable.put(PropClassId, new Integer(this.m_nClassId));
        if (this.getPropertyNames() != null) {
            hashtable.put(PropNameProperties, this.getPropertyNames());
        }
    }

    public void readProperties(Hashtable hashtable) {
        try {
            int n = this.toInt(hashtable.get(PropNameVersion), 0);
            this.m_nItemsFound = this.toInt(hashtable.get(PropNameItemsFound), 0);
            this.m_nItemsReturned = this.toInt(hashtable.get(PropNameItemsReturned), 0);
            this.m_nNextItem = this.toInt(hashtable.get(PropNameNextItem), -1);
            this.m_nPreviousItem = this.toInt(hashtable.get(PropNamePreviousItem), -1);
            this.m_szNextDn = (String)hashtable.get(PropNameNextDn);
            this.m_szPreviousDn = (String)hashtable.get(PropNamePreviousDn);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("read Properties Error");
        }
        this.readResults(hashtable);
    }

    protected void setApiSession(SmApiSession smApiSession) {
        this.m_ApiSession = smApiSession;
    }

    protected void setRealm(SmRealm smRealm) {
        this.m_Realm = smRealm;
    }

    protected void setUserDirectory(SmUserDirectory smUserDirectory) {
        this.m_UserDirectory = smUserDirectory;
    }

    protected void setDmsConfig(SmDmsConfig smDmsConfig) {
        this.m_dmsConfig = smDmsConfig;
    }

    protected void setOrgDn(String string) {
        this.m_OrgDn = string;
    }

    private void readResults(Hashtable hashtable) {
        int n = this.getNumberItemsReturned();
        this.m_nEOSfound = 0;
        if (n < 1) {
            this.m_Results = new Vector(0);
            return;
        }
        this.m_Results = new Vector(n);
        for (int i = 0; i < n; ++i) {
            Integer n2 = new Integer(i);
            String string = "object#" + n2.toString();
            SmApiObject smApiObject = (SmApiObject)hashtable.get(string);
            if (smApiObject == null) continue;
            String string2 = smApiObject.getDn();
            SmDmsObject smDmsObject = this.makeDmsObject(smApiObject.getClassId(), string2);
            if (string2.compareTo(EndOfSearch) == 0) {
                this.m_nEOSfound = 1;
                continue;
            }
            smDmsObject.setDn(string2);
            smDmsObject.setAttributes(smApiObject.getProperties());
            this.m_Results.addElement(smDmsObject);
        }
    }

    private int toInt(Object object, int n) {
        try {
            Integer n2 = new Integer(object.toString());
            return n2;
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    private SmDmsObject makeDmsObject(int n, String string) {
        switch (n) {
            case 1: {
                return new SmDmsUser(this.m_ApiSession, this.m_Realm, this.m_UserDirectory, this.m_dmsConfig, string, this.m_OrgDn);
            }
            case 2: {
                return new SmDmsGroup(this.m_ApiSession, this.m_Realm, this.m_UserDirectory, this.m_dmsConfig, string, this.m_OrgDn);
            }
            case 5: {
                return new SmDmsOrganization(this.m_ApiSession, this.m_Realm, this.m_UserDirectory, this.m_dmsConfig, string, this.m_OrgDn);
            }
            case 4: {
                return new SmDmsRole(this.m_ApiSession, this.m_Realm, this.m_UserDirectory, this.m_dmsConfig, string, this.m_OrgDn);
            }
        }
        return new SmDmsObject(n, this.m_ApiSession, this.m_Realm, this.m_UserDirectory, this.m_dmsConfig, string, this.m_OrgDn);
    }
}

