/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.dmsapi;

import com.netegrity.sdk.apiutil.SmApiConstants;
import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiObject;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.apiutil.SmApiSession;
import com.netegrity.sdk.dmsapi.SmDmsApi;
import com.netegrity.sdk.dmsapi.SmDmsConfig;
import com.netegrity.sdk.dmsapi.SmDmsContext;
import com.netegrity.sdk.dmsapi.SmDmsDirectory;
import com.netegrity.sdk.dmsapi.SmDmsDirectoryContext;
import com.netegrity.sdk.policyapi.SmObjId;
import com.netegrity.sdk.policyapi.SmPolicyApiImpl;
import com.netegrity.sdk.policyapi.SmRealm;
import com.netegrity.sdk.policyapi.SmSelfReg;
import com.netegrity.sdk.policyapi.SmUserDirectory;

public class SmDmsApiImpl
implements SmDmsApi {
    private SmApiSession m_ApiSession = null;
    private int m_Version = 512;

    public SmDmsApiImpl(SmApiSession smApiSession) {
        this(smApiSession, 512);
    }

    public SmDmsApiImpl(SmApiSession smApiSession, int n) {
        this.m_ApiSession = smApiSession;
        this.m_Version = n;
    }

    public void setApiSession(SmApiSession smApiSession) {
        this.m_ApiSession = smApiSession;
    }

    public SmApiResult getDmsContext(SmRealm smRealm, SmDmsConfig smDmsConfig, SmDmsContext smDmsContext) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setRealmOid(smRealm.getOid().getOidString());
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.m_ApiSession.getSessionSpec(), SmApiConstants.DMSAPI_CMD_GET_DMS_CONTEXT, smApiObject);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        String string = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_DIRECTORY);
        String string2 = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_REALM);
        String string3 = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_REGISTRATION);
        String string4 = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_DOMAIN);
        SmPolicyApiImpl smPolicyApiImpl = new SmPolicyApiImpl(this.m_ApiSession);
        SmUserDirectory smUserDirectory = new SmUserDirectory(string);
        smApiResult = smPolicyApiImpl.getUserDirectory(string, smUserDirectory);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        SmRealm smRealm2 = new SmRealm(string2);
        smApiResult = smPolicyApiImpl.getRealm(string2, string4, smRealm2);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        SmSelfReg smSelfReg = new SmSelfReg(string3);
        smApiResult = smPolicyApiImpl.getSelfReg(string3, smSelfReg);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        smDmsContext.setSelfRegistration(smSelfReg);
        SmDmsDirectory smDmsDirectory = new SmDmsDirectory(this.m_ApiSession, smRealm2, smUserDirectory, smDmsConfig);
        smDmsDirectory.setVersion(this.m_Version);
        smDmsContext.setDmsDirectory(smDmsDirectory);
        return smApiResult;
    }

    public SmApiResult getDmsContextNoAdminCheck(SmRealm smRealm, SmDmsConfig smDmsConfig, SmDmsContext smDmsContext) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setRealmOid(smRealm.getOid().getOidString());
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.m_ApiSession.getSessionSpec(), SmApiConstants.DMSAPI_CMD_GET_DMS_CONTEXT_NO_ADMIN_CHECK, smApiObject);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        String string = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_DIRECTORY);
        String string2 = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_REALM);
        String string3 = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_REGISTRATION);
        String string4 = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_DOMAIN);
        SmPolicyApiImpl smPolicyApiImpl = new SmPolicyApiImpl(this.m_ApiSession);
        SmUserDirectory smUserDirectory = new SmUserDirectory(string);
        smApiResult = smPolicyApiImpl.getUserDirectory(string, smUserDirectory);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        SmRealm smRealm2 = new SmRealm(string2);
        smApiResult = smPolicyApiImpl.getRealm(string2, string4, smRealm2);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        SmSelfReg smSelfReg = new SmSelfReg(string3);
        smApiResult = smPolicyApiImpl.getSelfReg(string3, smSelfReg);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        smDmsContext.setSelfRegistration(smSelfReg);
        SmDmsDirectory smDmsDirectory = new SmDmsDirectory(this.m_ApiSession, smRealm2, smUserDirectory, smDmsConfig);
        smDmsDirectory.setVersion(this.m_Version);
        smDmsContext.setDmsDirectory(smDmsDirectory);
        return smApiResult;
    }

    public SmApiResult getDirectoryContext(SmUserDirectory smUserDirectory, SmDmsConfig smDmsConfig, SmDmsDirectoryContext smDmsDirectoryContext) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        if (smUserDirectory.getOid().getOidString().equals(SmObjId.SmNullOid.getOidString())) {
            smApiObject.setDirOid(smUserDirectory.getName());
        } else {
            smApiObject.setDirOid(smUserDirectory.getOid().getOidString());
        }
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.m_ApiSession.getSessionSpec(), SmApiConstants.DMSAPI_CMD_GET_DIR_CONTEXT, smApiObject);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        String string = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_SEARCHROOT);
        smUserDirectory.setSearchRoot(string);
        SmRealm smRealm = new SmRealm();
        SmDmsDirectory smDmsDirectory = new SmDmsDirectory(this.m_ApiSession, smRealm, smUserDirectory, smDmsConfig);
        smDmsDirectory.setVersion(this.m_Version);
        smDmsDirectoryContext.setDmsDirectory(smDmsDirectory);
        return SmApiResult.CLIENT_SUCCESS;
    }

    public int getVersion() {
        return this.m_Version;
    }
}

