/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.apiutil;

import com.netegrity.sdk.apiutil.SmApiObject;

public class SmApiResult {
    public static final int FACILITY_CONNECTION = 0;
    public static final int FACILITY_DMS = 1;
    public static final int FACILITY_POLICY = 2;
    public static final int FACILITY_APP = 3;
    public static final int FACILITY_SERVER = 4;
    public static final int FACILITY_CLIENT = 5;
    public static final int FACILITY_IMS_CLIENT = 6;
    public static final int FACILITY_IMS_SERVER = 7;
    public static final int SEVERITY_SUCCESS = 0;
    public static final int SEVERITY_INFORMATIONAL = 1;
    public static final int SEVERITY_WARNING = 2;
    public static final int SEVERITY_ERROR = 3;
    public static final int REASON_NONE = 0;
    public static final int SUCCESS = 0;
    public static final SmApiResult CLIENT_SUCCESS = new SmApiResult(0, 0, 0, "");
    public static final SmApiResult INVALID_AGENT_CONNECTION = new SmApiResult(0, 3, 1, "Invalid agent connection");
    public static final SmApiResult BUFFER_CREATION_FAILURE = new SmApiResult(0, 3, 2, "Could not create buffer for agent transaction");
    public static final SmApiResult INCORRECT_BUFFER_LENGTH = new SmApiResult(0, 3, 3, "Length of returned buffer is less than zero");
    public static final SmApiResult SERVER_CONFIGURATION_FAILURE = new SmApiResult(0, 3, 4, "Unable to get server configuration");
    public static final SmApiResult AGENT_INITIALIZATION_FAILURE = new SmApiResult(0, 3, 5, "Agent initialization failed");
    public static final SmApiResult NO_SERVER_CONNECTION = new SmApiResult(0, 3, 6, "No server connection");
    public static final SmApiResult CONNECTION_TIMEOUT = new SmApiResult(0, 3, 7, "Connection timed out");
    public static final SmApiResult AGENT_FAILURE = new SmApiResult(0, 3, 8, "Tunnel Agent failure");
    public static final SmApiResult CORRUPT_BUFFER = new SmApiResult(0, 3, 9, "Corrupt buffer");
    public static final SmApiResult DMS_MISMATCH_ARGUMENTS = new SmApiResult(1, 3, 1, "Mismatched arguments in the filter");
    public static final SmApiResult POLICY_INVALID_ADDRESS_MODE = new SmApiResult(2, 3, 1, "Invalid IP Address mode");
    public static final SmApiResult POLICY_INVALID_AUTHAZ_MAP_TYPE = new SmApiResult(2, 3, 2, "Invalid authentication and authorization map type");
    public static final SmApiResult POLICY_INVALID_GROUP_TYPE = new SmApiResult(2, 3, 3, "Invalid group type");
    public static final SmApiResult POLICY_INVALID_ADDRESS = new SmApiResult(2, 3, 4, "Invalid IP Address");
    public static final SmApiResult SERVER_FAILURE = new SmApiResult(4, 3, 2, "Operation has failed");
    public static final SmApiResult SERVER_BAD_FORMAT = new SmApiResult(4, 3, 3, "Badly formatted command");
    public static final SmApiResult SERVER_RESPONSE_TOO_BIG = new SmApiResult(4, 3, 4, "The response is too big");
    public static final SmApiResult SERVER_NOT_IMPLEMENTED = new SmApiResult(4, 3, 5, "Not implemented");
    public static final SmApiResult SERVER_NO_COMMAND = new SmApiResult(4, 3, 6, "Unrecognized command");
    public static final SmApiResult SERVER_EXCEPTION = new SmApiResult(4, 3, 7, "Server exception");
    public static final SmApiResult SERVER_NO_SESSION = new SmApiResult(4, 3, 8, "No session");
    public static final SmApiResult SERVER_EXPIRED_SESSION = new SmApiResult(4, 3, 9, "The session has expired");
    public static final SmApiResult SERVER_INVALID_SESSION = new SmApiResult(4, 3, 10, "The session is invalid");
    public static final SmApiResult SERVER_AUTH_REJECT = new SmApiResult(4, 3, 11, "Invalid credentials");
    public static final SmApiResult SERVER_NOT_AUTHORIZED = new SmApiResult(4, 3, 12, "User is not authorized to perform this operation");
    public static final SmApiResult SERVER_INVALID_PASSWORD = new SmApiResult(4, 3, 13, "Password is invalid");
    public static final SmApiResult SERVER_CHANGE_PASSWORD = new SmApiResult(4, 3, 14, "Failed to change password");
    public static final SmApiResult SERVER_GET_TEMP_PASSWORD = new SmApiResult(4, 3, 15, "Could not generate temporary password");
    public static final SmApiResult SERVER_WORKFLOW_INIT = new SmApiResult(4, 3, 16, "Could not load or init workflow library");
    public static final SmApiResult SERVER_WORKFLOW_EXCEPTION = new SmApiResult(4, 3, 17, "Exception caught in the workflow library");
    public static final SmApiResult SERVER_WORKFLOW_PREPROCESS = new SmApiResult(4, 3, 18, "Workflow preprocess error");
    public static final SmApiResult SERVER_WORKFLOW_POSTPROCESS = new SmApiResult(4, 3, 19, "Workflow postprocess error");
    public static final SmApiResult SERVER_INVALID_OBJECTCLASS = new SmApiResult(4, 3, 20, "Invalid object class");
    public static final SmApiResult SERVER_INVALID_DIRECTORY = new SmApiResult(4, 3, 21, "Invalid user directory configuration");
    public static final SmApiResult SERVER_DIRECTORY_OBJECT = new SmApiResult(4, 3, 22, "Directory connection failed or object does not exist");
    public static final SmApiResult SERVER_CREATE = new SmApiResult(4, 3, 23, "Could not create directory object");
    public static final SmApiResult SERVER_GET_PROPS = new SmApiResult(4, 3, 24, "Could not get object properties");
    public static final SmApiResult SERVER_SET_PROPS = new SmApiResult(4, 3, 25, "Could not set object properties");
    public static final SmApiResult SERVER_GET_GROUPS = new SmApiResult(4, 3, 26, "Could not get groups");
    public static final SmApiResult SERVER_GET_ROLES = new SmApiResult(4, 3, 27, "Could not get roles");
    public static final SmApiResult SERVER_ADD_MEMBER = new SmApiResult(4, 3, 28, "Could not add member to group entity");
    public static final SmApiResult SERVER_REMOVE_MEMBER = new SmApiResult(4, 3, 29, "Could not remove member from group entity");
    public static final SmApiResult SERVER_SEARCH = new SmApiResult(4, 3, 30, "Search failure");
    public static final SmApiResult SERVER_DELETE = new SmApiResult(4, 3, 31, "Could not delete object");
    public static final SmApiResult SERVER_FETCH_REALM = new SmApiResult(4, 3, 32, "Failed to fetch SiteMinder realm");
    public static final SmApiResult SERVER_FETCH_DOMAIN = new SmApiResult(4, 3, 33, "Failed to fetch SiteMinder domain");
    public static final SmApiResult SERVER_FETCH_REG_SCHEME = new SmApiResult(4, 3, 34, "Failed to fetch SiteMinder registration scheme");
    public static final SmApiResult SERVER_FETCH_USER_DIR = new SmApiResult(4, 3, 35, "Failed to fetch SiteMinder user directory");
    public static final SmApiResult SERVER_POLICY_API = new SmApiResult(4, 3, 36, "Policy API error");
    public static final SmApiResult SERVER_AUTH_CHALLENGE = new SmApiResult(4, 2, 37, "Authentication challenge");
    public static final SmApiResult SERVER_NO_ITEMS_FOUND = new SmApiResult(4, 2, 38, "No items found");
    public static final SmApiResult SERVER_TOO_MANY_ITEMS_FOUND = new SmApiResult(4, 2, 39, "Too many items found");
    public static final SmApiResult SERVER_USER_DIR_NOT_CONFIGURED = new SmApiResult(4, 3, 40, "User directory not configured");
    public static final SmApiResult SERVER_BAD_ATTR_FORMAT = new SmApiResult(4, 3, 41, "Attribute value not formatted properly");
    public static final SmApiResult SERVER_MISMATCH = new SmApiResult(4, 3, 42, "Mismatch");
    public static final SmApiResult SERVER_PASSWORDSTATE = new SmApiResult(4, 3, 43, "PasswordState can not be accessed correctly.");
    public static final SmApiResult SERVER_IMEXPORT_CRYPTO_ERROR1 = new SmApiResult(4, 3, 44, "Unable to get crypto configuration. [1]");
    public static final SmApiResult SERVER_IMEXPORT_CRYPTO_ERROR2 = new SmApiResult(4, 3, 45, "Unable to get crypto configuration. [2]");
    public static final SmApiResult SERVER_IMEXPORT_CRYPTO_ERROR3 = new SmApiResult(4, 3, 46, "Unable to get crypto configuration. [3]");
    public static final SmApiResult SERVER_IMEXPORT_CRYPTO_INITIALIZE_ERROR = new SmApiResult(4, 3, 47, "Unable to initialize crypto factory");
    public static final SmApiResult SERVER_IMEXPORT_POLICY_STORE_ERROR = new SmApiResult(4, 3, 48, "Could not open policy store");
    public static final SmApiResult SERVER_IMEXPORT_SITEMINDER_CREDENTIALS_ERROR = new SmApiResult(4, 3, 49, "Could not authenticate SiteMinder administrator. Credentials are not valid");
    public static final SmApiResult SERVER_IMEXPORT_NO_DOMAIN = new SmApiResult(4, 3, 50, "Could not find Passed domain");
    public static final SmApiResult SERVER_IMEXPORT_NO_IMS_ENV = new SmApiResult(4, 3, 51, "Could not find passed IMS environment");
    public static final SmApiResult SERVER_IMEXPORT_NO_IMS_DIRECTORY = new SmApiResult(4, 3, 52, "Could not find passed IMS directory");
    public static final SmApiResult SERVER_IMEXPORT_MIGRATION_CREATE_ERROR = new SmApiResult(4, 3, 53, "Fatal Error: Failed to create a migration object");
    public static final SmApiResult SERVER_IMEXPORT_INVALID_OBJECT = new SmApiResult(4, 3, 54, "Fatal Error: Invalid object");
    public static final SmApiResult SERVER_IMEXPORT_INVALID_PROPERTY = new SmApiResult(4, 3, 55, "Fatal Error: Invalid property");
    public static final SmApiResult SERVER_IMEXPORT_INVALID_OID = new SmApiResult(4, 3, 56, "Fatal Error: Invalid OID");
    public static final SmApiResult SERVER_IMEXPORT_INVALID_MATCH = new SmApiResult(4, 3, 57, "Fatal Error: Invalid Match");
    public static final SmApiResult SERVER_IMEXPORT_INVALID_PARENT = new SmApiResult(4, 3, 58, "Fatal Error: Invalid Parent Object");
    public static final SmApiResult SERVER_IMEXPORT_OBJECT_NOTFOUND = new SmApiResult(4, 3, 59, "Fatal Error: Object not found");
    public static final SmApiResult SERVER_IMEXPORT_PROPERTY_NOTFOUND = new SmApiResult(4, 3, 60, "Fatal Error: Property not found");
    public static final SmApiResult SERVER_IMEXPORT_OBJECT_FETCH_ERROR = new SmApiResult(4, 3, 61, "Fatal Error: Unable to fetch object");
    public static final SmApiResult SERVER_IMEXPORT_PROPERTY_ACCESS_ERROR = new SmApiResult(4, 3, 62, "Fatal Error: Unable to access property");
    public static final SmApiResult SERVER_IMEXPORT_OVERWRITE_ERROR = new SmApiResult(4, 3, 63, "Fatal Error: Cannot overwrite");
    public static final SmApiResult SERVER_IMEXPORT_ODBS_ERROR = new SmApiResult(4, 3, 64, "Fatal Error: ODBC error");
    public static final SmApiResult SERVER_IMEXPORT_INITIALIZATION_ERROR = new SmApiResult(4, 3, 65, "Fatal Error: Failed initialization");
    public static final SmApiResult SERVER_IMEXPORT_FILE_ERROR = new SmApiResult(4, 3, 66, "Fatal Error: File error");
    public static final SmApiResult SERVER_IMEXPORT_UNKNOWN_ERROR = new SmApiResult(4, 3, 67, "Fatal Error: Unknown error");
    public static final SmApiResult SERVER_IMEXPORT_WRITE_ERROR = new SmApiResult(4, 3, 68, "Could not write to file while import");
    public static final SmApiResult SERVER_IMEXPORT_READ_ERROR = new SmApiResult(4, 3, 69, "Could not read from file while export");
    public static final SmApiResult SERVER_USER_POLICY_IN_CONSISTENT_AND_BIT_MASK = new SmApiResult(4, 3, 70, "Mismatched setting of AND bit between user policies of same user directory");
    public static final SmApiResult CLIENT_NULL_PARAM_ERROR = new SmApiResult(4, 3, 71, "Parameter can not be null");
    public static final SmApiResult CLIENT_NOT_IMPLEMENTED = new SmApiResult(5, 1, 1, "Not implemented");
    public static final SmApiResult CLIENT_EXPORT_FILENAME_F = new SmApiResult(5, 3, 2, "Export Status: Overwrite option is specified, still no file name is set.");
    public static final SmApiResult CLIENT_EXPORT_SMDIFFILE_F = new SmApiResult(5, 3, 3, "Export Status: smdif file already exists. Use overwrite option, while setting the file name.");
    public static final SmApiResult CLIENT_EXPORT_CONFIG_F = new SmApiResult(5, 3, 4, "Export Status: config file already exists. Use overwrite option, while setting the file name.");
    public static final SmApiResult CLIENT_IMPORT_NO_INPUTFILE_I = new SmApiResult(5, 3, 5, "Import Status: no input filename is set.");
    public static final SmApiResult CLIENT_IMPORT_OPEN_ERROR = new SmApiResult(5, 3, 6, "Import Status: Unable to open set smdif file");
    public static final SmApiResult CLIENT_EXPORT_FILE_WRITE_ERROR = new SmApiResult(5, 3, 7, "Error in writing data to the file");
    public static final SmApiResult CLIENT_IMPORT_FILE_READ_ERROR = new SmApiResult(5, 3, 8, "Error in reading data from the file");
    public static final SmApiResult INVALID_PARAMETERS = new SmApiResult(3, 3, 1, "Incorrect parameters passed to the API call.");
    public static final SmApiResult CLIENT_INVALID_AGENTTYPE_ACTION = new SmApiResult(5, 3, 9, "Only Authenticate Action allowed for RADIUS agent");
    public static final SmApiResult CLIENT_INVALID_AGENTTYPE_RESOURCE = new SmApiResult(5, 3, 10, "Invalid Resource type set for agent.");
    public static final SmApiResult CLIENT_INVALID_AGENTTYPE_SPECIFIC = new SmApiResult(5, 3, 11, "Invalid Agent type Specific set for agent.");
    public static final SmApiResult CLIENT_NO_AGENTTYPE = new SmApiResult(5, 3, 12, "No AgentType set for AgentTypeAttr.");
    public static final SmApiResult CLIENT_INVALID_AGENTTYPEATTR_ID = new SmApiResult(5, 3, 13, "AgentTypeAttr Identifier should be between 0 to 255");
    public static final SmApiResult CLIENT_INVALID_AGENTTYPEATTR_DATATYPE = new SmApiResult(5, 3, 14, "Invalid AgentTypeAttr DataType.");
    public static final SmApiResult CLIENT_INVALID_AGENTTYPEATTR_RADIUSTYPE = new SmApiResult(5, 3, 15, "Invalid AgentTypeAttr RADIUS Type.");
    public static final SmApiResult CLIENT_INVALID_AGENTTYPEATTR_RADIUSBEHAVIOR = new SmApiResult(5, 3, 16, "Invalid AgentTypeAttr RADIUS Behavior.");
    public static final SmApiResult CLIENT_INVALID_AGENTTYPEATTR_DATATYPE_VALUE = new SmApiResult(5, 3, 17, "Values allowed only for number data type.");
    public static final SmApiResult CLIENT_INVALID_AGENTTYPEATTR_NUMERICVALUE = new SmApiResult(5, 3, 18, "Invalid Numeric Value.");
    public static final SmApiResult CLIENT_INVALID_AUTHVALIDATEMAP_MAPPING_TYPE = new SmApiResult(5, 3, 19, "Invalid authentication and validation mapping type");
    public static final SmApiResult CLIENT_MISSING_AUTHVALIDATEMAP_PROPERTY = new SmApiResult(5, 3, 20, "Missing required property for AuthValidateMap.");
    public static final SmApiResult CLIENT_INVALID_AUTHDIRNAME = new SmApiResult(5, 3, 21, "Invalid Authentication Directory Name");
    public static final SmApiResult CLIENT_INVALID_AGENTTYPE = new SmApiResult(5, 3, 22, "Invalid Agent Type.");
    public static final SmApiResult CLIENT_INVALID_OID = new SmApiResult(5, 3, 23, "Invalid OID");
    private SmApiObject m_obj = null;
    private int m_Facility = 0;
    private int m_StatusCode = 0;
    private int m_Severity = 0;
    private int m_Reason = 0;
    private int m_ErrorCode = 0;
    private String m_Message = "";
    protected static final int SEVERITY_MASK = 3;
    protected static final int FACILITY_MASK = 60;
    protected static final int STATUS_MASK = 65472;
    protected static final int REASON_MASK = -65536;
    protected static final int ERROR_MASK = 65535;
    private static final int SEVERITY_BITS = 0;
    private static final int FACILITY_BITS = 2;
    private static final int STATUS_BITS = 6;
    private static final int REASON_BITS = 16;
    private static final int ERROR_BITS = 0;

    public SmApiResult() {
    }

    public SmApiResult(int n, String string, SmApiObject smApiObject) {
        this();
        this.m_ErrorCode = (n & 0xFFFF) >> 0;
        this.m_Reason = (n & 0xFFFF0000) >> 16;
        this.m_Message = string;
        this.m_Severity = (this.m_ErrorCode & 3) >> 0;
        this.m_Facility = (this.m_ErrorCode & 0x3C) >> 2;
        this.m_StatusCode = (this.m_ErrorCode & 0xFFC0) >> 6;
        this.m_obj = smApiObject;
    }

    public boolean isSuccess() {
        return this.m_StatusCode == 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.getError() == ((SmApiResult)object).getError();
    }

    public int getReason() {
        return this.m_Reason;
    }

    public int getStatus() {
        return this.m_StatusCode;
    }

    public int getError() {
        return this.m_ErrorCode;
    }

    public int getFacility() {
        return this.m_Facility;
    }

    public int getSeverity() {
        return this.m_Severity;
    }

    public String getMessage() {
        return this.m_Message;
    }

    public static int getStatus(int n) {
        return (n & 0xFFC0) >> 6;
    }

    public SmApiObject getDecoderObject() {
        return this.m_obj;
    }

    public String toString() {
        return new String("[facility=" + this.m_Facility + " severity=" + this.m_Severity + " reason=" + this.m_Reason + " status=" + this.m_StatusCode + " message=" + this.m_Message + "]");
    }

    protected SmApiResult(int n, int n2, int n3, String string) {
        this.m_Severity = n2;
        this.m_Facility = n;
        this.m_Reason = 0;
        this.m_StatusCode = n3;
        this.m_Message = string;
        this.m_ErrorCode = n2 << 0 | n << 2 | n3 << 6;
    }
}

