/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.apiutil;

import com.netegrity.sdk.apiutil.SmApiConstants;
import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiObject;
import com.netegrity.sdk.apiutil.SmApiResult;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import netegrity.siteminder.javaagent.AgentAPI;
import netegrity.siteminder.javaagent.Attribute;
import netegrity.siteminder.javaagent.AttributeList;
import netegrity.siteminder.javaagent.BinaryBuffer;
import netegrity.siteminder.javaagent.InitDef;
import netegrity.siteminder.javaagent.ResourceContextDef;
import netegrity.siteminder.javaagent.ServerDef;
import netegrity.siteminder.javaagent.TunnelServiceRequest;

public class SmApiConnection {
    private static final String SERVICE_LIBRARY = "smtransactems2";
    private static final String SERVICE_FUNCTION = "SmExecuteCommand";
    private static AgentAPI m_DefaultAgentApiConnection;
    private boolean m_bDefaultAgentConnection = true;
    private boolean m_disableLoadBalancing = true;
    private AgentAPI m_AgentApiConnection = null;
    private InitDef m_InitDef = new InitDef();
    private static DateFormat dateFormat;

    public SmApiConnection(boolean bl, boolean bl2) throws SmApiException {
        this.m_disableLoadBalancing = bl2;
        this.m_bDefaultAgentConnection = bl;
        if (this.m_bDefaultAgentConnection) {
            this.getAgentHandle("");
        }
    }

    public SmApiConnection(AgentAPI agentAPI) {
        this.m_AgentApiConnection = agentAPI;
        this.m_bDefaultAgentConnection = false;
    }

    public void setAgentApiConnection(AgentAPI agentAPI) throws SmApiException {
        if (agentAPI != null) {
            this.m_AgentApiConnection = agentAPI;
            this.m_bDefaultAgentConnection = false;
        } else {
            this.m_AgentApiConnection = null;
            this.m_bDefaultAgentConnection = true;
            if (m_DefaultAgentApiConnection == null) {
                throw new SmApiException(SmApiResult.INVALID_AGENT_CONNECTION);
            }
        }
    }

    public AgentAPI getAgentApiConnection() throws SmApiException {
        if (this.isValidApiConnection()) {
            return this.getAgentHandle("");
        }
        throw new SmApiException(SmApiResult.INVALID_AGENT_CONNECTION);
    }

    public boolean isValidApiConnection() {
        return this.m_AgentApiConnection != null || m_DefaultAgentApiConnection != null;
    }

    public SmApiResult execute(String string, SmApiConstants smApiConstants, SmApiObject smApiObject) throws SmApiException {
        return this.execute(string, SERVICE_LIBRARY, smApiConstants, smApiObject);
    }

    public SmApiResult execute(String string, String string2, SmApiConstants smApiConstants, SmApiObject smApiObject) throws SmApiException {
        int n;
        AgentAPI agentAPI = null;
        String string3 = smApiConstants.toString();
        agentAPI = this.getAgentHandle("");
        if (agentAPI == null) {
            SmApiConnection.writeLog("SmApiConnection: Could not connect through AgentApi");
            return SmApiResult.INVALID_AGENT_CONNECTION;
        }
        StringBuffer stringBuffer = smApiObject.encodeCommand(string, string3);
        BinaryBuffer binaryBuffer = this.makeBuffer(stringBuffer);
        if (binaryBuffer == null) {
            throw new SmApiException(SmApiResult.BUFFER_CREATION_FAILURE);
        }
        this.printRequest(string3, smApiObject);
        ResourceContextDef resourceContextDef = new ResourceContextDef("", "", "", "");
        AttributeList attributeList = new AttributeList();
        TunnelServiceRequest tunnelServiceRequest = new TunnelServiceRequest(string2, SERVICE_FUNCTION, "", binaryBuffer.buff);
        binaryBuffer = null;
        int n2 = agentAPI.tunnel((short)1, "", "", resourceContextDef, tunnelServiceRequest, attributeList);
        if (n2 != 1) {
            this.serverException(n2);
        }
        if ((n = attributeList.getAttributeCount()) < 0) {
            SmApiConnection.writeLog("SmApiConnection Execute: length of returned buffer is < 0 ");
            throw new SmApiException(SmApiResult.INCORRECT_BUFFER_LENGTH);
        }
        String string4 = null;
        for (int i = 0; i < n; ++i) {
            Attribute attribute = attributeList.getAttributeAt(i);
            if (attribute.id == 158 || attribute.id != 164) continue;
            int n3 = attribute.value.length - 1;
            if (n3 < 0) {
                SmApiConnection.writeLog("SmApiConnection Execute: length of returned buffer is < 0 ");
                throw new SmApiException(SmApiResult.INCORRECT_BUFFER_LENGTH);
            }
            try {
                string4 = new String(attribute.value, 0, n3, "UTF8");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                SmApiConnection.writeLog("Unsupported encoding exception");
            }
        }
        SmApiResult smApiResult = smApiObject.decode(string4);
        this.printResponse(string3, smApiResult, smApiObject);
        return smApiResult;
    }

    private AgentAPI getAgentHandle(String string) throws SmApiException {
        Object object;
        Object object2;
        String string2;
        int n = 0;
        if (this.m_AgentApiConnection != null) {
            if (!this.m_bDefaultAgentConnection) {
                return this.m_AgentApiConnection;
            }
            throw new SmApiException(SmApiResult.INVALID_AGENT_CONNECTION);
        }
        if (m_DefaultAgentApiConnection != null) {
            if (this.m_bDefaultAgentConnection) {
                return m_DefaultAgentApiConnection;
            }
            throw new SmApiException(SmApiResult.INVALID_AGENT_CONNECTION);
        }
        m_DefaultAgentApiConnection = new AgentAPI();
        SmApiConnection.writeLog("SmApiConnection\t start getAgent()");
        SmApiConnection.writeLog("SmApiConnection\t about to load properties");
        System.out.flush();
        Object object3 = "";
        boolean bl = false;
        String string3 = System.getProperty("java.class.path");
        if (string3 == null) {
            SmApiConnection.writeLog("SmApiConnection: classpath is empty");
            bl = false;
        } else {
            string2 = System.getProperty("path.separator");
            string3 = string3 + string2;
            object2 = new StringTokenizer(string3, string2);
            while (((StringTokenizer)object2).hasMoreElements() && !bl) {
                File file;
                String string4 = ((StringTokenizer)object2).nextToken();
                if (string4.indexOf(".jar") >= 0 || !(file = new File((String)(object = string4 + System.getProperty("file.separator") + "WebAgent.conf"))).exists()) continue;
                bl = true;
                object3 = object;
            }
        }
        if (!bl) {
            object3 = "";
        }
        if ((n = m_DefaultAgentApiConnection.getConfig(this.m_InitDef, string, (String)object3)) != 0) {
            this.m_bDefaultAgentConnection = true;
            m_DefaultAgentApiConnection = null;
            SmApiConnection.writeLog("SmApiConnection\t Unable to get server configuration");
            throw new SmApiException(SmApiResult.SERVER_CONFIGURATION_FAILURE);
        }
        if (!this.m_InitDef.isFailOver() && this.m_disableLoadBalancing) {
            string2 = this.m_InitDef.getHostName();
            object2 = this.m_InitDef.getSharedSecret();
            boolean bl2 = true;
            object = this.m_InitDef.getServers();
            this.m_InitDef = new InitDef(string2, (String)object2, bl2, (ServerDef)((Vector)object).elementAt(0));
            for (int i = 1; i < ((Vector)object).size(); ++i) {
                this.m_InitDef.addServerDef((ServerDef)((Vector)object).elementAt(i));
            }
        }
        SmApiConnection.writeLog("SmApiConnection\t Agent name: " + this.m_InitDef.getHostName());
        SmApiConnection.writeLog("SmApiConnection\t Fail over : " + this.m_InitDef.isFailOver());
        SmApiConnection.writeLog("SmApiConnection\t Server IP : " + this.m_InitDef.getServerAt((int)0).serverIpAddress);
        SmApiConnection.writeLog("SmApiConnection\t Auth port : " + this.m_InitDef.getServerAt((int)0).authenticationPort);
        SmApiConnection.writeLog("SmApiConnection\t Az port   : " + this.m_InitDef.getServerAt((int)0).authorizationPort);
        SmApiConnection.writeLog("SmApiConnection\t Acct port : " + this.m_InitDef.getServerAt((int)0).accountingPort);
        SmApiConnection.writeLog("SmApiConnection\t Max conn. : " + this.m_InitDef.getServerAt((int)0).connectionMax);
        SmApiConnection.writeLog("SmApiConnection\t Min conn. : " + this.m_InitDef.getServerAt((int)0).connectionMin);
        SmApiConnection.writeLog("SmApiConnection\t Step conn.: " + this.m_InitDef.getServerAt((int)0).connectionStep);
        if (m_DefaultAgentApiConnection.init(this.m_InitDef) != 0) {
            this.m_bDefaultAgentConnection = true;
            m_DefaultAgentApiConnection = null;
            SmApiConnection.writeLog("SmApiConnection\tAgent initialization failed");
            throw new SmApiException(SmApiResult.AGENT_INITIALIZATION_FAILURE);
        }
        return m_DefaultAgentApiConnection;
    }

    private static void writeLog(String string) {
        String string2 = System.getProperty("SMJAVASDK_LOG_INFO");
        if (string2 != null && string2.equals("true")) {
            System.out.println(string);
        }
    }

    private void printRequest(String string, SmApiObject smApiObject) {
        String string2 = System.getProperty("SMJAVASDK_LOG_INFO");
        if (string2 != null && string2.equals("true")) {
            String string3 = dateFormat.format(new Date());
            SmApiConnection.writeLog("[" + string3 + " <Request>" + "<command=" + string + ">]");
            SmApiConnection.writeLog(smApiObject.toString());
        }
    }

    private void printResponse(String string, SmApiResult smApiResult, SmApiObject smApiObject) {
        String string2 = System.getProperty("SMJAVASDK_LOG_INFO");
        if (string2 != null && string2.equals("true")) {
            String string3 = dateFormat.format(new Date());
            SmApiConnection.writeLog("[" + string3 + " <Response>" + "<command=" + string + ">]");
            SmApiConnection.writeLog(smApiResult.toString());
            SmApiConnection.writeLog(smApiObject.toString());
        }
    }

    private BinaryBuffer makeBuffer(StringBuffer stringBuffer) {
        try {
            AgentAPI agentAPI = this.getAgentHandle("");
            if (agentAPI == null) {
                SmApiConnection.writeLog("SmApiConnection: Could not connect through AgentApi");
                return null;
            }
            String string = stringBuffer.toString();
            byte[] byArray = null;
            try {
                byArray = string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
            BinaryBuffer binaryBuffer = new BinaryBuffer();
            binaryBuffer.buff = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, binaryBuffer.buff, 0, byArray.length);
            binaryBuffer.buff[byArray.length] = 0;
            return binaryBuffer;
        }
        catch (Exception exception) {
            SmApiConnection.writeLog("SmApiConnection: Exception creating buffer:" + exception.toString());
            return null;
        }
    }

    private void serverException(int n) throws SmApiException {
        switch (n) {
            case -3: {
                SmApiConnection.writeLog("SmApiConnection Execute: error is No server connection");
                throw new SmApiException(SmApiResult.NO_SERVER_CONNECTION);
            }
            case -2: {
                SmApiConnection.writeLog("SmApiConnection Execute: error is Connection timed out");
                throw new SmApiException(SmApiResult.CONNECTION_TIMEOUT);
            }
        }
        SmApiConnection.writeLog("SmApiConnection Execute: error is Tunnel Agent failed");
        throw new SmApiException(SmApiResult.AGENT_FAILURE);
    }

    static {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            String string = "123.123.123.123";
        }
        m_DefaultAgentApiConnection = null;
        dateFormat = new SimpleDateFormat("dd/MMM/yyyy:H:mm:ss z");
    }
}

