/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.provider;

import com.rsa.crypto.AlgParamGenerator;
import com.rsa.crypto.CryptoException;
import com.rsa.crypto.CryptoModule;
import com.rsa.crypto.NoSuchAlgorithmException;
import com.rsa.crypto.PQGParams;
import com.rsa.crypto.PublicKey;
import com.rsa.crypto.PublicKeyIsValidNotSupportedException;
import com.rsa.cryptoj.c.bj;
import com.rsa.cryptoj.c.ca;
import com.rsa.cryptoj.c.ce;
import com.rsa.cryptoj.c.cf;
import com.rsa.cryptoj.c.cj;
import com.rsa.cryptoj.c.cl;
import com.rsa.cryptoj.c.cx;
import com.rsa.cryptoj.c.fn;
import com.rsa.cryptoj.c.ka;
import com.rsa.cryptoj.c.kn;
import com.rsa.cryptoj.c.ko;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.X942DHParameterSpec;
import com.rsa.jsafe.provider.b;
import com.rsa.jsafe.security.spec.DSADomainParameterGenerationSpec;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;

public final class Assurance {
    public static final String DIGEST_SHA1 = "SHA1";
    public static final String DIGEST_SHA224 = "SHA224";
    public static final String DIGEST_SHA256 = "SHA256";
    public static final String DIGEST_SHA384 = "SHA384";
    public static final String DIGEST_SHA512 = "SHA512";
    public static final int VERSION_FIPS186_2 = 2;
    public static final int VERSION_FIPS186_3 = 3;

    private Assurance() {
    }

    public static boolean isValidPublicKey(java.security.PublicKey publicKey) throws InvalidKeyException {
        return Assurance.isValidPublicKey(publicKey, null, null);
    }

    public static boolean isValidPublicKey(java.security.PublicKey publicKey, SecureRandom secureRandom, FIPS140Context fIPS140Context) throws InvalidKeyException {
        cf cf2 = fIPS140Context == null ? ce.a() : b.a(fIPS140Context);
        PublicKey publicKey2 = kn.a(publicKey, publicKey.getAlgorithm(), cl.a(cf2, Assurance.a()));
        if (publicKey2 == null) {
            publicKey2 = ((fn)publicKey).b();
        }
        try {
            return publicKey2.isValid(cx.a(secureRandom, cf2));
        }
        catch (PublicKeyIsValidNotSupportedException publicKeyIsValidNotSupportedException) {
            return true;
        }
    }

    private static List<ca> a() {
        return ka.a;
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string) {
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, null, null);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        return Assurance.a("DSA", dSADomainParameterGenerationSpec, string, secureRandom, fIPS140Context);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, int n2, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        if (dSADomainParameterGenerationSpec == null) {
            throw new InvalidParameterException("A DSADomainParameterGenerationSpec spec must be specified");
        }
        if (n2 == 2 && !DIGEST_SHA1.equals(string)) {
            return false;
        }
        return Assurance.a("DSA", dSADomainParameterGenerationSpec, string, secureRandom, fIPS140Context);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, int n2) {
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, n2, null, null);
    }

    public static boolean verifyX942DHParams(X942DHParameterSpec x942DHParameterSpec, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        if (x942DHParameterSpec == null) {
            throw new InvalidParameterException("An X942DHParameter spec must be specified");
        }
        try {
            return Assurance.a("DH", x942DHParameterSpec, null, secureRandom, fIPS140Context);
        }
        catch (CryptoException cryptoException) {
            throw new InvalidParameterException(cryptoException.getMessage());
        }
    }

    public static boolean verifyX942DHParams(X942DHParameterSpec x942DHParameterSpec) {
        return Assurance.verifyX942DHParams(x942DHParameterSpec, null, null);
    }

    private static boolean a(String string, AlgorithmParameterSpec algorithmParameterSpec, String string2, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        cj cj2 = cl.a(b.a(fIPS140Context), ca.a);
        try {
            AlgParamGenerator algParamGenerator = cj2.newAlgParamGenerator(string);
            PQGParams pQGParams = "DSA".equals(string) ? ko.a((DSADomainParameterGenerationSpec)algorithmParameterSpec, string2, cj2) : ko.a((X942DHParameterSpec)algorithmParameterSpec, (CryptoModule)cj2);
            algParamGenerator.initVerify(pQGParams, cx.a(secureRandom, b.a(fIPS140Context)));
            return algParamGenerator.verify();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (bj bj2) {
        }
        catch (CryptoException cryptoException) {
            return false;
        }
        return false;
    }
}

