/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.security;

import com.ca.siteminder.sdk.adminapi.PolicyData;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.ca.xps.Grant;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.security.SecurityBase;
import com.ca.siteminder.sdk.adminapitest.security.SecuritySetup;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class SmokeTest
extends SecurityBase {
    static Domain domain;

    @Override
    public void setUpSuite() {
        domain = (Domain)SetupConnection.policyData.newObject((IClass)Domain.ddclass);
        domain.setName("domainSecurity" + SetupConnection.random);
        this.createObject((XPSObject)domain);
    }

    @TestBase.STI(value=1)
    public void noGrant() {
        SecuritySetup.connect2();
        PolicyData policyData = SecuritySetup.session2.getPolicyData();
        List list = policyData.search((IClass)Domain.ddclass);
        if (list != null) {
            SmokeTest.assertEquals((String)"noGrant: No domains expected", (int)0, (int)list.size());
        }
    }

    @TestBase.STI(value=2)
    public void searchWithGrant() {
        Administrator administrator = SecuritySetup.admin2;
        Grant grant = SecuritySetup.makeGrant(administrator, null);
        this.createObject((XPSObject)grant);
        this.updateObject((XPSObject)administrator);
        PolicyData policyData = SecuritySetup.policyData2;
        List list = policyData.search((IClass)Domain.ddclass);
        SmokeTest.assertTrue((String)"searchWithGrant: No domains exist", (list.size() > 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void createWithReadOnlyGrant() {
        PolicyData policyData = SecuritySetup.policyData2;
        Domain domain = (Domain)policyData.newObject((IClass)Domain.ddclass);
        domain.setName("SecondDomain" + SetupConnection.random);
        SmokeTest.failCreate2((XPSObject)domain);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SmokeTest.suite());
    }

    public static Test suite() {
        return new SecuritySetup(SmokeTest.class);
    }
}

