/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.functional;

import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.dd.DDClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class TransactionTest
extends TestBase {
    private static final String commitDomain = "CommitDomain" + SetupConnection.random;
    private String strDesc;

    @TestBase.STI(value=1)
    public void testCreateCommit() throws Exception {
        SetupConnection.session.begin();
        try {
            Domain domain = SetupConnection.builder.makeDomain(commitDomain, null);
            SetupConnection.createObject((XPSObject)domain);
        }
        catch (XPSException xPSException) {
            SetupConnection.session.cancel();
            throw xPSException;
        }
        SetupConnection.session.commit();
        SetupConnection.fetchByName(Domain.ddclass, commitDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestBase.STI(value=2)
    public void testCreateCancel() throws Exception {
        SetupConnection.session.begin();
        String string = "TestDomainCreateCancel" + SetupConnection.random;
        try {
            Domain domain = SetupConnection.builder.makeDomain(string, null);
            SetupConnection.createObject((XPSObject)domain);
            SetupConnection.fetchByName(Domain.ddclass, string);
        }
        finally {
            SetupConnection.session.cancel();
        }
        TransactionTest.failFetchByName(Domain.ddclass, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestBase.STI(value=3)
    public void testCreateFail() throws Exception {
        SetupConnection.session.begin();
        String string = "TestDomainCreateFail" + SetupConnection.random;
        try {
            Domain domain = SetupConnection.builder.makeDomain(string, null);
            SetupConnection.createObject((XPSObject)domain);
            domain = SetupConnection.builder.makeDomain(string, null);
            this.failCreate((XPSObject)domain, "Duplicate");
        }
        finally {
            SetupConnection.session.cancel();
        }
        TransactionTest.failFetchByName(Domain.ddclass, string);
    }

    @TestBase.STI(value=4)
    public void testUpdateCommit() throws Exception {
        Domain domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, commitDomain);
        SetupConnection.session.begin();
        String string = "ChangedByTestUpdateCommit";
        try {
            domain.setDesc(string);
            SetupConnection.updateObject((XPSObject)domain);
        }
        catch (XPSException xPSException) {
            SetupConnection.session.cancel();
            throw xPSException;
        }
        SetupConnection.session.commit();
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, commitDomain);
        TransactionTest.assertTrue((String)"Update should get committed", (boolean)string.equalsIgnoreCase(domain.getDesc()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestBase.STI(value=5)
    public void testUpdateCancel() throws Exception {
        Domain domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, commitDomain);
        String string = "ChangedByTestUpdateCancel";
        this.strDesc = domain.getDesc();
        SetupConnection.session.begin();
        try {
            domain.setDesc(string);
            SetupConnection.updateObject((XPSObject)domain);
        }
        finally {
            SetupConnection.session.cancel();
        }
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, commitDomain);
        TransactionTest.assertTrue((String)"Object Update should get rolled back", (boolean)this.strDesc.equalsIgnoreCase(domain.getDesc()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestBase.STI(value=6)
    public void testUpdateFail() throws Exception {
        String string = "TestDomainUpdateFail" + SetupConnection.random;
        Domain domain = SetupConnection.builder.makeDomain(string, null);
        SetupConnection.createObject((XPSObject)domain);
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, commitDomain);
        this.strDesc = domain.getDesc();
        String string2 = "ChangedByTestUpdateFail";
        SetupConnection.session.begin();
        try {
            domain.setDesc(string2);
            SetupConnection.updateObject((XPSObject)domain);
            domain.setName(string);
            this.failUpdate((XPSObject)domain, "Duplicate");
        }
        finally {
            SetupConnection.session.cancel();
        }
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, commitDomain);
        TransactionTest.assertTrue((String)"Object Update should get rolled back", (boolean)this.strDesc.equalsIgnoreCase(domain.getDesc()));
    }

    @TestBase.STI(value=7)
    public void testDeleteCommit() throws Exception {
        String string = "TestDomainDeleteCommit" + SetupConnection.random;
        Domain domain = SetupConnection.builder.makeDomain(string, null);
        SetupConnection.createObject((XPSObject)domain);
        SetupConnection.session.begin();
        try {
            SetupConnection.deleteObject((XPSObject)domain);
        }
        catch (XPSException xPSException) {
            SetupConnection.session.cancel();
            throw xPSException;
        }
        SetupConnection.session.commit();
        TransactionTest.failFetchByName(Domain.ddclass, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestBase.STI(value=8)
    public void testDeleteCancel() throws Exception {
        SetupConnection.session.begin();
        try {
            Domain domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, commitDomain);
            SetupConnection.deleteObject((XPSObject)domain);
            TransactionTest.failFetchByName(Domain.ddclass, commitDomain);
        }
        finally {
            SetupConnection.session.cancel();
        }
        SetupConnection.fetchByName(Domain.ddclass, commitDomain);
    }

    private static void failFetchByName(DDClass<?> dDClass, String string) {
        try {
            SetupConnection.fetchByName(dDClass, string);
            TransactionTest.fail((String)("fetched " + dDClass.getName() + " " + string));
        }
        catch (XPSException xPSException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TransactionTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(TransactionTest.class);
    }
}

