/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.functional;

import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.textui.TestRunner;

public class ServiceTest
extends TestBase {
    Map<String, String> params = new HashMap<String, String>();

    @TestBase.STI(value=1)
    public void withoutParameters() {
        String string = SetupConnection.session.callService("CA", "XPS", "ParseExpression", "1 > 2");
        ServiceTest.assertContains(string, "Result=\"Ok\"");
        ServiceTest.assertContains(string, "InfoLevel=\"0\"");
    }

    @TestBase.STI(value=2)
    public void withParameters() {
        this.params.put("Privileged", "1");
        this.params.put("InfoLevel", "2");
        String string = SetupConnection.session.callService("CA", "XPS", "ParseExpression", "1 > 2", this.params);
        ServiceTest.assertContains(string, "Result=\"Ok\"");
        ServiceTest.assertContains(string, "InfoLevel=\"2\"");
    }

    @TestBase.STI(value=3)
    public void negative() {
        this.params.put("InfoLevel", "2");
        String string = SetupConnection.session.callService("CA", "XPS", "ParseExpression", "1 > aaa", null);
        ServiceTest.assertContains(string, "Syntax Error");
    }

    @TestBase.STI(value=4)
    public void wrongServiceName() {
        try {
            SetupConnection.session.callService("CA", "XPS", "xxx", "", null);
        }
        catch (ServerException serverException) {
            ServiceTest.assertEquals((String)"Exception tag must match \"service\"", (String)serverException.getTag(), (String)"service");
            ServiceTest.assertContains(serverException.getMsg(), "Service could not be found");
        }
    }

    @TestBase.STI(value=5)
    public void wrongServiceProduct() {
        try {
            SetupConnection.session.callService("CA", "XXX", "xxx", null, null);
        }
        catch (ServerException serverException) {
            ServiceTest.assertEquals((String)"Exception tag must match \"service\"", (String)serverException.getTag(), (String)"service");
            ServiceTest.assertContains(serverException.getMsg(), "Product could not be found");
        }
    }

    @TestBase.STI(value=6)
    public void wrongServiceVendor() {
        try {
            SetupConnection.session.callService("XXX", "XXX", "xxx", "", null);
        }
        catch (ServerException serverException) {
            ServiceTest.assertEquals((String)"Exception tag must match \"service\"", (String)serverException.getTag(), (String)"service");
            ServiceTest.assertContains(serverException.getMsg(), "Vendor could not be found");
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ServiceTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(ServiceTest.class);
    }
}

