/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.functional;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthScheme;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.textui.TestRunner;

public class FilterTest
extends TestBase {
    static Domain domain;

    @Override
    public void setUpSuite() {
        EnumSet<Domain.Mode> enumSet = EnumSet.of(Domain.Mode.Hidden);
        domain = (Domain)SetupConnection.policyData.newObject((IClass)Domain.ddclass);
        domain.setName("FilterDomain" + SetupConnection.random);
        domain.setMode(enumSet);
        domain.setHidingMask(XPSObject.HidingMask.GUI, new XPSObject.HidingMask[0]);
        this.createObject((XPSObject)domain);
        domain = (Domain)InternalTesting.refetch(domain.getXid(), SetupConnection.session);
    }

    @TestBase.STI(value=1)
    public void filterFlagsBit() {
        Set set = domain.getMode();
        Filter filter = new Filter((IAttribute)Domain.MODE, Clause.Operator.EQUAL, (Object)Domain.Mode.Hidden);
        List list = SetupConnection.policyData.search((IClass)Domain.ddclass, filter);
        int n = list.size();
        FilterTest.assertTrue((String)"No Domain object fetched", (n > 0 ? 1 : 0) != 0);
        for (int i = 0; i < n; ++i) {
            Domain domain = (Domain)list.get(i);
            Set set2 = domain.getMode();
            FilterTest.assertEquals((String)"Incorrect mode in the domain object", (Object)set, (Object)set2);
        }
    }

    @TestBase.STI(value=3)
    public void filterFlagsSet() {
        EnumSet<Domain.Mode> enumSet = EnumSet.of(Domain.Mode.Hidden);
        Filter filter = new Filter((IAttribute)Domain.MODE, Clause.Operator.EQUAL, enumSet);
        List list = SetupConnection.policyData.search((IClass)Domain.ddclass, filter);
        int n = list.size();
        FilterTest.assertTrue((String)"No Objects of Domain type are fetched", (n > 0 ? 1 : 0) != 0);
        for (int i = 0; i < n; ++i) {
            Domain domain = (Domain)list.get(i);
            Set set = domain.getMode();
            FilterTest.assertEquals((String)"Incorrect mode for the domain object", enumSet, (Object)set);
        }
    }

    @TestBase.STI(value=5)
    public void filterEnum() {
        Filter filter = new Filter((IAttribute)AgentType.VENDORTYPE, Clause.Operator.EQUAL, (Object)AgentType.VendorType.WebAgent);
        List list = SetupConnection.policyData.search((IClass)AgentType.ddclass, filter);
        int n = list.size();
        FilterTest.assertTrue((String)"No Objects of AgentType are fetched", (n > 0 ? 1 : 0) != 0);
        for (int i = 0; i < n; ++i) {
            AgentType agentType = (AgentType)list.get(i);
            AgentType.VendorType vendorType = agentType.getVendorType();
            FilterTest.assertEquals((String)"Incorrect vendor type for the AgentType object", (Object)AgentType.VendorType.WebAgent, (Object)vendorType);
        }
    }

    @TestBase.STI(value=7)
    public void filterInt() {
        int n = 0;
        Filter filter = new Filter((IAttribute)AgentType.RFCID, Clause.Operator.EQUAL, (Object)n);
        List list = SetupConnection.policyData.search((IClass)AgentType.ddclass, filter);
        int n2 = list.size();
        FilterTest.assertTrue((String)"No Objects of AgentType RFCID are fetched", (n2 > 0 ? 1 : 0) != 0);
        for (int i = 0; i < n2; ++i) {
            AgentType agentType = (AgentType)list.get(i);
            int n3 = agentType.getRfcId();
            FilterTest.assertEquals((String)"Incorrect RFCID for the AgentType object", (int)n, (int)n3);
        }
    }

    @TestBase.STI(value=9)
    public void filterBool() {
        boolean bl = false;
        Filter filter = new Filter((IAttribute)AuthScheme.ISTEMPLATE, Clause.Operator.EQUAL, (Object)bl);
        List list = SetupConnection.policyData.search((IClass)AuthScheme.ddclass, filter);
        int n = list.size();
        FilterTest.assertTrue((String)"No AuthScheme objects are fetched", (n > 0 ? 1 : 0) != 0);
        for (int i = 0; i < n; ++i) {
            boolean bl2 = ((AuthScheme)list.get(i)).getIsTemplate();
            FilterTest.assertEquals((String)"Incorrect AuthScheme template", (boolean)bl, (boolean)bl2);
        }
    }

    @TestBase.STI(value=11)
    public void filterLink() {
        Agent agent = SetupConnection.builder.makeAgent("filter agent" + SetupConnection.random);
        this.createObject((XPSObject)agent);
        AgentType agentType = agent.getAgentType();
        Filter filter = new Filter((IAttribute)Agent.AGENTTYPE, Clause.Operator.EQUAL, (Object)agentType);
        List list = SetupConnection.policyData.search((IClass)Agent.ddclass, filter);
        int n = list.size();
        FilterTest.assertTrue((String)"No Agent objects are fetched", (n > 0 ? 1 : 0) != 0);
        for (int i = 0; i < n; ++i) {
            AgentType agentType2 = ((Agent)list.get(i)).getAgentType();
            FilterTest.assertEquals((String)"AgentType object XID incorrect", (String)agentType.getXid(), (String)agentType2.getXid());
        }
    }

    @TestBase.STI(value=12)
    public void filterParent() {
        String string = "Policy" + SetupConnection.random;
        Policy policy = SetupConnection.builder.makePolicy(string, domain);
        this.createObject((XPSObject)policy);
        Filter filter = new Filter((IAttribute)XPSObject.PARENT, Clause.Operator.EQUAL, (Object)domain);
        List list = SetupConnection.policyData.search((IClass)Policy.ddclass, filter);
        FilterTest.assertEquals((String)"Only one parent expected for the policy object", (int)1, (int)list.size());
        FilterTest.assertEquals((String)"The policy, created, is not reflected in existing policies", (Object)policy, list.get(0));
    }

    @TestBase.STI(value=13)
    public void filterOrigin() {
        Filter filter = new Filter((IAttribute)XPSObject.ORIGIN, Clause.Operator.EQUAL, (Object)XPSObject.Origin.REMOTE_API);
        List list = SetupConnection.policyData.search((IClass)Domain.ddclass, filter);
        FilterTest.assertTrue((String)"No domain objects fetched", (list.size() > 0 ? 1 : 0) != 0);
        for (Domain domain : list) {
            FilterTest.assertEquals((String)"Mismatch in origin", (Object)XPSObject.Origin.REMOTE_API, (Object)domain.getOrigin());
        }
    }

    @TestBase.STI(value=14)
    public void filterUpdatedBy() {
        String string = domain.getUpdatedBy();
        Filter filter = new Filter((IAttribute)XPSObject.UPDATEDBY, Clause.Operator.EQUAL, (Object)string);
        List list = SetupConnection.policyData.search((IClass)Domain.ddclass, filter);
        FilterTest.assertTrue((String)"No Domain objects fetched", (list.size() > 0 ? 1 : 0) != 0);
        for (Domain domain : list) {
            FilterTest.assertEquals((String)("The object is not updated by " + string), (String)string, (String)domain.getUpdatedBy());
        }
    }

    @TestBase.STI(value=15)
    public void filterCreated() {
        Date date = domain.getCreated();
        Filter filter = new Filter((IAttribute)XPSObject.CREATED, Clause.Operator.EQUAL, (Object)date);
        List list = SetupConnection.policyData.search((IClass)Domain.ddclass, filter);
        FilterTest.assertTrue((String)"No Domain objects fetched", (list.size() > 0 ? 1 : 0) != 0);
        for (Domain domain : list) {
            FilterTest.assertEquals((String)("The object is not created at " + date), (Object)date, (Object)domain.getCreated());
        }
    }

    @TestBase.STI(value=16)
    public void filterNullValue() {
        Filter filter = new Filter((IAttribute)Domain.USERDIRECTORIES, Clause.Operator.EQUAL, null);
        List list = SetupConnection.policyData.search((IClass)Domain.ddclass, filter);
        FilterTest.assertTrue((String)"No Domain object fetched", (list.size() > 0 ? 1 : 0) != 0);
        for (Domain domain : list) {
            FilterTest.assertFalse((String)"The domain has user directories", (boolean)domain.hasUserDirectories());
        }
    }

    @TestBase.STI(value=17)
    public void filterCaseSensitiveEquals() {
        String string = domain.getName();
        String string2 = string.toUpperCase();
        Filter filter = new Filter((IAttribute)Domain.NAME, Clause.Operator.EQUAL, (Object)string2, false);
        List list = SetupConnection.policyData.search((IClass)Domain.ddclass, filter);
        FilterTest.assertEquals((String)"only one domain object expected with the given domain name", (int)1, (int)list.size());
        filter = new Filter((IAttribute)Domain.NAME, Clause.Operator.EQUAL, (Object)string2, true);
        list = SetupConnection.policyData.search((IClass)Domain.ddclass, filter);
        FilterTest.assertEquals((String)"No domains expected", (int)0, (int)list.size());
    }

    @TestBase.STI(value=18)
    public void filterCaseSensitiveContains() {
        String string = domain.getName();
        String string2 = string.toUpperCase();
        Filter filter = new Filter((IAttribute)Domain.NAME, Clause.Operator.CONTAINS, (Object)string2, false);
        List list = SetupConnection.policyData.search((IClass)Domain.ddclass, filter);
        FilterTest.assertEquals((String)"Only one domain expected", (int)1, (int)list.size());
        filter = new Filter((IAttribute)Domain.NAME, Clause.Operator.CONTAINS, (Object)string2, true);
        list = SetupConnection.policyData.search((IClass)Domain.ddclass, filter);
        FilterTest.assertEquals((String)"No domains expected", (int)0, (int)list.size());
    }

    @TestBase.STI(value=19)
    public void filterMetaAttributes() {
        XPSObject.HidingMask hidingMask = XPSObject.HidingMask.GUI;
        Filter filter = new Filter((IAttribute)XPSObject.HIDINGMASK, Clause.Operator.EQUAL, (Object)hidingMask);
        List list = SetupConnection.policyData.search((IClass)Domain.ddclass, filter);
        FilterTest.assertTrue((String)"No Domain objects fetched", (list.size() > 0 ? 1 : 0) != 0);
        for (Domain domain : list) {
            Set set = domain.getHidingMask();
            FilterTest.assertNotNull((String)"the Hiding mask should not be null", (Object)set);
            FilterTest.assertTrue((String)"Incorrect mask for the domain object", (boolean)set.contains(hidingMask));
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)FilterTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(FilterTest.class);
    }
}

