/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.functional;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.PolicyData;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.xps.Class;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class ExportTest
extends TestBase {
    static Domain domain;
    static Policy policy1;
    static Policy policy2;
    static String policy1Xid;
    static String policy2Xid;
    static PolicyData policyData;
    static Session session;
    static String replaceFile;
    static String overlayFile;
    static String addFile;
    static String MergePreferOld;
    static String mergePreferNew;
    static String domainName;
    static String policy1Name;
    static String policy2Name;

    @TestBase.STI(value=1)
    public void exportReplace() {
        policyData = SetupConnection.policyData;
        session = SetupConnection.session;
        domainName = "TestDomain_" + SetupConnection.random;
        policy1Name = "TestPolicy1_" + SetupConnection.random;
        policy2Name = "TestPolicy2_" + SetupConnection.random;
        domain = (Domain)policyData.newObject((IClass)Domain.ddclass);
        domain.setName(domainName);
        this.createObject((XPSObject)domain);
        policy1 = (Policy)policyData.newObject((IClass)Policy.ddclass);
        policy1.setParent(domain);
        policy1.setName(policy1Name);
        policy1.setDesc("replace");
        this.createObject((XPSObject)policy1);
        policy1Xid = policy1.getXid();
        replaceFile = InternalTesting.exportObject(session, (XPSObject)domain, "r/replace.xml", Class.ImportType.Replace);
    }

    @TestBase.STI(value=2)
    public void exportOverlay() {
        policy1.setDesc("overlay");
        policyData.updateObject((XPSObject)policy1);
        overlayFile = InternalTesting.exportObject(session, (XPSObject)domain, "r/overlay.xml", Class.ImportType.Overlay);
    }

    @TestBase.STI(value=3)
    public void exportAdd() {
        policy1.setDesc("add");
        policyData.updateObject((XPSObject)policy1);
        policy2 = policy1.duplicate();
        policy2.setName(policy2Name);
        this.createObject((XPSObject)policy2);
        policy2Xid = policy2.getXid();
        addFile = InternalTesting.exportObject(session, (XPSObject)domain, "r/add.xml", Class.ImportType.Add);
    }

    @TestBase.STI(value=4)
    public void exportMergePreferOld() {
        policy1.setDesc("existing");
        policyData.updateObject((XPSObject)policy1);
        policy2.clearDesc();
        policyData.updateObject((XPSObject)policy2);
        MergePreferOld = InternalTesting.exportObject(session, (XPSObject)domain, "r/existing.xml", Class.ImportType.MergePreferOld);
    }

    @TestBase.STI(value=5)
    public void exportMergePreferNew() {
        policy1.setDesc("new");
        policyData.updateObject((XPSObject)policy1);
        mergePreferNew = InternalTesting.exportObject(session, (XPSObject)domain, "r/new.xml", Class.ImportType.MergePreferNew);
    }

    @TestBase.STI(value=6)
    public void importReplace() {
        this.importFile(replaceFile, "replace", null);
    }

    @TestBase.STI(value=7)
    public void importAdd() {
        this.importFile(addFile, "replace", "add");
    }

    @TestBase.STI(value=8)
    public void importOverlay() {
        this.importFile(overlayFile, "overlay", "add");
    }

    @TestBase.STI(value=9)
    public void importExisting() {
        policy1.clearDesc();
        policyData.updateObject((XPSObject)policy1);
        this.importFile(MergePreferOld, "existing", "add");
    }

    @TestBase.STI(value=10)
    public void importNew() {
        this.importFile(mergePreferNew, "new", "add");
    }

    void importFile(String string, String string2, String string3) {
        int n = string3 == null ? 1 : 2;
        InternalTesting.importFile(session, string);
        InternalTesting.removeFromCache((XPSObject)policy1);
        InternalTesting.removeFromCache((XPSObject)policy2);
        List list = domain.getChildren((IClass)Policy.ddclass);
        ExportTest.assertSize("list", list, n);
        if (n == 1) {
            policy1 = (Policy)list.get(0);
            ExportTest.assertEquals((String)"policy desc", (String)string2, (String)policy1.getDesc());
            return;
        }
        policy1 = (Policy)list.get(0);
        policy2 = (Policy)list.get(1);
        if (policy2Xid.equals(policy1.getXid())) {
            policy1 = (Policy)list.get(1);
            policy2 = (Policy)list.get(0);
        }
        ExportTest.assertEquals((String)"Policy1 desc", (String)string2, (String)policy1.getDesc());
        ExportTest.assertEquals((String)"Policy2 desc", (String)string3, (String)policy2.getDesc());
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ExportTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(ExportTest.class);
    }
}

