/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.Directory;
import com.ca.siteminder.sdk.adminapi.ResultEntry;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.User;
import com.ca.siteminder.sdk.adminapi.ValidatePasswordResponse;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.ca.sm.Admin;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class UserTestAdminWithReadRights
extends TestBaseDMS {
    private static final Logger logger = Logger.getLogger(UserTestAdminWithReadRights.class);
    private static Session newAdminSession = null;
    private static Directory dir1 = null;

    @Override
    public void setUpSuite() {
        super.setUpSuite();
        UserTestAdminWithReadRights.breakdown(SetupConnection.session);
        EnumSet<Admin.Rights> enumSet = EnumSet.noneOf(Admin.Rights.class);
        EnumSet<Administrator.Flags> enumSet2 = EnumSet.noneOf(Administrator.Flags.class);
        UserTestAdminWithReadRights.createNewAdmin(SetupConnection.session, "CA.XPS::SecurityCategory@!Directory Administration", enumSet, enumSet2, null);
        String string = UserTestAdminWithReadRights.getSpec(SetupConnection.session);
        newAdminSession = UserTestAdminWithReadRights.login(SetupConnection.session, string);
        try {
            UserDirectory userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, udName);
            dir1 = newAdminSession.getDirectoryManager().getDirectory(userDirectory.getXid());
        }
        catch (Exception exception) {
            throw new XPSException(exception.getMessage());
        }
        if (dir1 == null) {
            throw new XPSException("Cannot create user directory");
        }
    }

    @TestBase.STI(value=1)
    public void testDisable() throws XPSException {
        logger.debug((Object)"***Testing User disable (NEGATIVE)***");
        List list = null;
        User user = dir1.fetchUser(fullUserDsbDN, list);
        try {
            if (user.enable(1)) {
                UserTestAdminWithReadRights.fail((String)"User disabled with Admin having Read-Only rights");
            }
        }
        catch (ServerException serverException) {
            UserTestAdminWithReadRights.assertEquals((String)"Exception tag must match with user.enable", (String)serverException.getTag(), (String)"user.enable");
        }
    }

    @TestBase.STI(value=2)
    public void testEnable() throws XPSException {
        logger.debug((Object)"***Testing User enable (NEGATIVE)***");
        List list = null;
        User user = dir1.fetchUser(fullUserDsbDN, list);
        try {
            if (user.enable(0)) {
                UserTestAdminWithReadRights.fail((String)"User enabled using Admin with Read-only rights");
            }
        }
        catch (ServerException serverException) {
            UserTestAdminWithReadRights.assertEquals((String)"Exception tag must match with user.enable", (String)serverException.getTag(), (String)"user.enable");
        }
    }

    @TestBase.STI(value=4)
    public void testGetGroups() throws XPSException {
        logger.debug((Object)"***Testing User getGroups (POSITIVE)***");
        List list = null;
        User user = dir1.fetchUser(fullUserGrpDN, list);
        List list2 = null;
        list2 = user.getGroups(true);
        UserTestAdminWithReadRights.assertTrue((list2.size() == 2 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=5)
    public void testIsInGroup() throws XPSException {
        logger.debug((Object)"***Testing User isInGroup (POSITIVE)***");
        List list = null;
        User user = dir1.fetchUser(fullUserGrpDN, list);
        List list2 = user.getGroups(true);
        UserTestAdminWithReadRights.assertNotNull((Object)list2);
        boolean bl = user.isInGroup(((ResultEntry)list2.get(0)).getDN());
        UserTestAdminWithReadRights.assertTrue((boolean)bl);
    }

    @TestBase.STI(value=6)
    public void testIsInGroup_InvalidGroup() throws XPSException {
        logger.debug((Object)"***Testing User isInGroup (NEGATIVE)***");
        List list = null;
        User user = dir1.fetchUser(fullUserGrpDN, list);
        boolean bl = user.isInGroup("jnjrehfuhhnn");
        UserTestAdminWithReadRights.assertFalse((boolean)bl);
    }

    @TestBase.STI(value=7)
    public void testSetPasswordMustChange() throws XPSException {
        logger.debug((Object)"***Testing User setPasswordMustChange (NEGATIVE)***");
        List list = null;
        User user = dir1.fetchUser(fullUserPwdDN, list);
        try {
            user.setPasswordMustChange();
            user.enable(0);
            UserTestAdminWithReadRights.fail((String)"An Admin with READ only rights must not be allowed to invoke this method");
        }
        catch (ServerException serverException) {
            // empty catch block
        }
    }

    @TestBase.STI(value=8)
    public void testValidatePassword() throws XPSException {
        logger.debug((Object)"***Testing User validatePassword (NEGATIVE)***");
        List list = null;
        User user = dir1.fetchUser(fullUserPwdDN, list);
        try {
            user.enable(0);
            user.validatePassword("TestPassword1234&Abc", false, false);
            UserTestAdminWithReadRights.fail((String)"validated bad password");
        }
        catch (ServerException serverException) {
            // empty catch block
        }
    }

    @TestBase.STI(value=9)
    public void testGetAttributes() throws XPSException {
        logger.debug((Object)"***Testing User getDisabled (POSITIVE)***");
        ArrayList<String> arrayList = null;
        User user = dir1.fetchUser(fullUserPwdDN, arrayList);
        arrayList = new ArrayList<String>();
        arrayList.add(pwdDataAttr);
        Map map = user.getAttributes(arrayList);
        UserTestAdminWithReadRights.assertNotNull((String)"user.getAttributes() returned null ", (Object)map);
        List list = (List)map.get(pwdDataAttr);
        UserTestAdminWithReadRights.assertNotNull((String)"fetch password-attribute value resulted in null ", (Object)list);
    }

    @TestBase.STI(value=10)
    public void testSetAttributes() throws XPSException {
        logger.debug((Object)"***Testing User getDisabled (POSITIVE)***");
        ArrayList<String> arrayList = null;
        User user = dir1.fetchUser(fullUserPwdDN, arrayList);
        arrayList = new ArrayList<String>();
        arrayList.add(pwdDataAttr);
        Map map = user.getAttributes(arrayList);
        UserTestAdminWithReadRights.assertNotNull((String)"user.getAttributes() returned null ", (Object)map);
        List list = (List)map.get(pwdDataAttr);
        list.set(0, "2");
        HashMap<String, List> hashMap = new HashMap<String, List>();
        hashMap.put(pwdDataAttr, list);
        int n = user.setAttributes(hashMap);
        UserTestAdminWithReadRights.assertEquals((String)"setAttributes returned 0", (int)0, (int)n);
    }

    @TestBase.STI(value=11)
    public void testValidateNewPassword() throws XPSException {
        logger.debug((Object)"***Testing User validateNewPassword (POSITIVE)***");
        List list = null;
        User user = dir1.fetchUser(fullUserPwdDN, list);
        ValidatePasswordResponse validatePasswordResponse = user.validateNewPassword("Password1", "Password2", false, false);
        UserTestAdminWithReadRights.assertTrue((String)"Validate password failed", (boolean)validatePasswordResponse.isValid());
    }

    @TestBase.STI(value=12)
    public void testChangePassword_NotRequireOldPassword() throws XPSException {
        logger.debug((Object)"***Testing User changePassword (POSITIVE)***");
        List list = null;
        User user = dir1.fetchUser(fullUserPwdDN, list);
        try {
            user.changePassword("", "NewPassword11", true);
            UserTestAdminWithReadRights.fail((String)"changePassword failed when NotRequireOldPassword set to TRUE.");
        }
        catch (ServerException serverException) {
            UserTestAdminWithReadRights.assertEquals((String)"Exception tag must match with user.changePassword", (String)serverException.getTag(), (String)"user.changePassword");
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)UserTestAdminWithReadRights.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(UserTestAdminWithReadRights.class);
    }
}

