/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.ResultEntry;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Expression;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class DirectoryTestFilter
extends TestBaseDMS {
    private static final Logger logger = Logger.getLogger(DirectoryTestFilter.class);

    @Override
    public void setUpSuite() {
        super.setUpSuite();
    }

    @TestBase.STI(value=1)
    public void testSearchFilter_ClauseEquals() throws XPSException {
        logger.debug((Object)"*** Testing search equals (POSITIVE) ***");
        Clause clause = new Clause(uid, Clause.Operator.EQUAL, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotNull((String)"directory.search() returned null ", (Object)list);
        DirectoryTestFilter.assertFalse((String)"directory.search() returned empty list", (boolean)list.isEmpty());
        DirectoryTestFilter.assertTrue((String)"directory.search result list must one result", (list.size() == 1 ? 1 : 0) != 0);
        DirectoryTestFilter.assertTrue((String)("directory.search result list must contain user \"" + userSearchName + "\""), (boolean)((ResultEntry)list.get(0)).getDN().contains(userSearchName));
    }

    @TestBase.STI(value=2)
    public void testSearchFilter_ClauseNOTEquals() throws XPSException {
        logger.debug((Object)"*** Testing search equals (POSITIVE) ***");
        Clause clause = new Clause(uid, Clause.Operator.NOTEQUAL, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotNull((String)"directory.search() returned null ", (Object)list);
        DirectoryTestFilter.assertFalse((String)"directory.search() returned empty list", (boolean)list.isEmpty());
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((String)("directory.Search result list should not contain user \"" + userSearchName + "\""), (boolean)string.equals(userSearchName));
        }
    }

    @TestBase.STI(value=3)
    public void testSearchFilter_ClauseGreater() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        Clause clause = new Clause(uid, Clause.Operator.GREATER, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotNull((String)"directory.search() returned null ", (Object)list);
        DirectoryTestFilter.assertFalse((String)"directory.search() returned empty list", (boolean)list.isEmpty());
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((String)("Incorrect user list fetched. user \"" + string + "\" is not alphabetically-greater to " + userSearchName), (string.compareTo(userSearchName) > 0 ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=4)
    public void testSearchFilter_ClauseNotGreater() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        Clause clause = new Clause(uid, Clause.Operator.NOTGREATER, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotNull((String)"directory.search() returned null ", (Object)list);
        DirectoryTestFilter.assertFalse((String)"directory.search() returned empty list", (boolean)list.isEmpty());
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((String)("Incorrect user list fetched. \"" + string + "\"  is alphabetically-greater to " + userSearchName), (string.compareTo(userSearchName) > 0 ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=5)
    public void testSearchFilter_ClauseLess() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        Clause clause = new Clause(uid, Clause.Operator.LESS, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotNull((String)"testSearchFilter_ClauseLess: directory.search() returned null ", (Object)list);
        DirectoryTestFilter.assertFalse((String)"testSearchFilter_ClauseLess: directory.search() returned empty list", (boolean)list.isEmpty());
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((String)("Incorrect user list fetched. \"" + string + "\" is not alphabetically-lower to " + userSearchName), (string.compareTo(userSearchName) < 0 ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=6)
    public void testSearchFilter_ClauseNotLess() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        Clause clause = new Clause(uid, Clause.Operator.NOTLESS, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotNull((String)"directory.search() returned null ", (Object)list);
        DirectoryTestFilter.assertFalse((String)"directory.search() returned empty list", (boolean)list.isEmpty());
        for (ResultEntry resultEntry : list) {
            String string = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((String)("Incorrect user list fetched. \"" + string + "\" is alphabetically-lower to " + userSearchName), (string.compareTo(userSearchName) < 0 ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=7)
    public void testSearchFilter_ClauseBeginsWith() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        String string = userSearchName.substring(0, 1);
        Clause clause = new Clause(uid, Clause.Operator.BEGINSWITH, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotNull((String)"directory.search() returned null ", (Object)list);
        DirectoryTestFilter.assertFalse((String)"directory.search() returned empty list", (boolean)list.isEmpty());
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((String)("Incorrect user list fetched. \"" + string2 + "\" does not begin with " + string), (boolean)string2.toLowerCase().startsWith(string.toLowerCase()));
        }
    }

    @TestBase.STI(value=8)
    public void testSearchFilter_ClauseNotBeginsWith() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        String string = userSearchName.substring(0, 1);
        Clause clause = new Clause(uid, Clause.Operator.NOTBEGINSWITH, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotNull((String)"directory.search() returned null ", (Object)list);
        DirectoryTestFilter.assertFalse((String)"directory.search() returned empty list", (boolean)list.isEmpty());
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((String)("Incorrect user list fetched. \"" + string2 + "\" begins with " + string), (boolean)string2.toLowerCase().startsWith(string));
        }
    }

    @TestBase.STI(value=9)
    public void testSearchFilter_ClauseEndsWith() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        String string = userSearchName.substring(userSearchName.length() - 1, userSearchName.length());
        Clause clause = new Clause(uid, Clause.Operator.ENDSWITH, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotNull((String)"directory.search() returned null ", (Object)list);
        DirectoryTestFilter.assertFalse((String)"directory.search() returned empty list", (boolean)list.isEmpty());
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((String)("Incorrect user list fetched. \"" + string2 + "\" does not end with " + string), (boolean)string2.toLowerCase().endsWith(string));
        }
    }

    @TestBase.STI(value=10)
    public void testSearchFilter_ClauseNotEndsWith() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        String string = userSearchName.substring(userSearchName.length() - 1, userSearchName.length());
        Clause clause = new Clause(uid, Clause.Operator.NOTENDSWITH, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotNull((String)"directory.search() returned null ", (Object)list);
        DirectoryTestFilter.assertFalse((String)"directory.search() returned empty list", (boolean)list.isEmpty());
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((String)("Incorrect userlist fetched. \"" + string2 + "\" ends with " + string), (boolean)string2.toLowerCase().endsWith(string));
        }
    }

    @TestBase.STI(value=11)
    public void testSearchFilter_ClauseContains() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        String string = userSearchName.substring(userSearchName.length() / 2, userSearchName.length() / 2 + 1);
        Clause clause = new Clause(uid, Clause.Operator.CONTAINS, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotNull((String)"directory.search() returned null ", (Object)list);
        DirectoryTestFilter.assertFalse((String)"directory.search() returned empty list", (boolean)list.isEmpty());
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertTrue((String)("Incorrect userlist fetched. \"" + string2 + "\" does not contain " + string), (boolean)string2.toLowerCase().contains(string));
        }
    }

    @TestBase.STI(value=12)
    public void testSearchFilter_ClauseNotContains() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        String string = userSearchName.substring(userSearchName.length() / 2, userSearchName.length() / 2 + 1);
        Clause clause = new Clause(uid, Clause.Operator.NOTCONTAINS, (Object)string);
        Filter filter = new Filter((Expression)clause);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTestFilter.assertNotNull((String)"directory.search() returned null ", (Object)list);
        DirectoryTestFilter.assertFalse((String)"directory.search() returned empty list", (boolean)list.isEmpty());
        for (ResultEntry resultEntry : list) {
            String string2 = this.parseDN(resultEntry.getDN());
            DirectoryTestFilter.assertFalse((String)("Incorrect userlist fetched. \"" + string2 + "\" contains " + string), (boolean)string2.toLowerCase().contains(string));
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DirectoryTestFilter.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(DirectoryTestFilter.class);
    }
}

