/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dictionary;

import com.ca.siteminder.sdk.adminapi.ca.xps.Attribute;
import com.ca.siteminder.sdk.adminapi.ca.xps.Class;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AttributeTest
extends TestBase {
    @TestBase.STI(value=1)
    public void testSMAttributes() throws Exception {
        Object object;
        Class clazz = SetupConnection.dictionary.fetchClass("CA", "SM", "AgentType");
        AttributeTest.assertFalse((String)"Failed to fetch CA::SM.AgentType class", (clazz == null ? 1 : 0) != 0);
        List list = clazz.getAttributes();
        int n = 7;
        AttributeTest.assertEquals((String)"Mismatch in number of attributes", (int)n, (int)list.size());
        for (int i = 0; i < n; ++i) {
            if (((Attribute)list.get(i)).getName().equals("Name")) {
                object = (Attribute)list.get(i);
                AttributeTest.assertEquals((String)"Attribute \"Name\" is not string", (Object)object.getDataType(), (Object)IAttribute.DataType.String);
                AttributeTest.assertEquals((String)"Attribute \"Name\" max length is not 255", (int)object.getMaxLength(), (int)255);
                AttributeTest.assertEquals((String)"Attribute \"Name\" is not of kind unique", (Object)object.getUniqueness(), (Object)Attribute.Uniqueness.WithinClass);
                AttributeTest.assertEquals((String)"Attribute \"Name\" has no ALL access", (Object)object.getAPIAccess(), (Object)IAttribute.APIAccess.All);
            }
            if (((Attribute)list.get(i)).getName().equals("AttributesLink")) {
                object = (Attribute)list.get(i);
                AttributeTest.assertEquals((String)"Attribute \"AttributesLink\" is not of type Link", (Object)object.getDataType(), (Object)IAttribute.DataType.Link);
                AttributeTest.assertEquals((String)"Attribute \"AttributesLink\" is of unique kind", (Object)object.getUniqueness(), (Object)Attribute.Uniqueness.No);
                AttributeTest.assertEquals((String)"Attribute \"AttributesLink\" does not belong to AgentTypeAttr class", (String)object.getLinkToClass().getName(), (String)"AgentTypeAttr");
                AttributeTest.assertEquals((String)"Attribute \"AttributesLink\" is never granularized", (Object)object.getGranularOption(), (Object)Attribute.GranularOption.Never);
                AttributeTest.assertEquals((String)"Attribute \"AttributesLink\" has no link reference", (Object)object.getLinkReference(), (Object)Attribute.LinkReference.Never);
                AttributeTest.assertEquals((String)"Attribute \"AttributesLink\" has no value reference", (Object)object.getValueReference(), (Object)Attribute.ValueReference.Never);
                AttributeTest.assertEquals((String)"Attribute \"AttributesLink\" is no ALL access", (Object)object.getAPIAccess(), (Object)IAttribute.APIAccess.All);
            }
            if (!((Attribute)list.get(i)).getName().equals("ResourceType")) continue;
            object = (Attribute)list.get(i);
            AttributeTest.assertEquals((String)"Attribute \"ResourceType\" is not an integer", (Object)object.getDataType(), (Object)IAttribute.DataType.Integer);
            AttributeTest.assertEquals((String)"Attribute \"ResourceType\" is of kind unique", (Object)object.getUniqueness(), (Object)Attribute.Uniqueness.No);
            AttributeTest.assertEquals((String)"Attribute \"ResourceType\" value is not being handled as an enumerated value", (Object)object.getHandling(), (Object)IAttribute.Handling.Enumeration);
            AttributeTest.assertEquals((String)"Attribute \"ResourceType\" has no ALL access", (Object)object.getAPIAccess(), (Object)IAttribute.APIAccess.All);
        }
        Class clazz2 = SetupConnection.dictionary.fetchClass("CA", "SM", "Rule");
        AttributeTest.assertFalse((String)"Failed to fetch CA::SM.Rule class", (clazz2 == null ? 1 : 0) != 0);
        object = clazz2.getAttributes();
        AttributeTest.assertEquals((String)"Mismatch in number of attributes", (int)object.size(), (int)14);
        for (int i = 0; i < 14; ++i) {
            Attribute attribute;
            if (((Attribute)object.get(i)).getName().equals("Actions")) {
                attribute = (Attribute)object.get(i);
                AttributeTest.assertEquals((String)"Attribute \"Actions\" is not a string", (Object)attribute.getDataType(), (Object)IAttribute.DataType.String);
                AttributeTest.assertEquals((String)"Attribute \"Actions\" is of kind unique", (Object)attribute.getUniqueness(), (Object)Attribute.Uniqueness.No);
                AttributeTest.assertEquals((String)"Attribute \"Actions\" has no ALL access", (Object)attribute.getAPIAccess(), (Object)IAttribute.APIAccess.All);
                AttributeTest.assertEquals((String)"Attribute \"Actions\" has value reference", (Object)attribute.getValueReference(), (Object)Attribute.ValueReference.Never);
                AttributeTest.assertEquals((String)"Attribute \"Actions\" value is not being handled as a Value", (Object)attribute.getHandling(), (Object)IAttribute.Handling.Value);
            }
            if (((Attribute)object.get(i)).getName().equals("DomainLink")) {
                attribute = (Attribute)object.get(i);
                AttributeTest.assertEquals((String)"Attribute \"DomainLink\" is not of type Link", (Object)attribute.getDataType(), (Object)IAttribute.DataType.Link);
                AttributeTest.assertEquals((String)"Attribute \"DomainLink\" is of kind Unique", (Object)attribute.getUniqueness(), (Object)Attribute.Uniqueness.No);
                AttributeTest.assertEquals((String)"Attribute \"DomainLink\" belongs to class Domain", (String)attribute.getLinkToClass().getName(), (String)"Domain");
                AttributeTest.assertEquals((String)"Attribute \"DomainLink\" does not have Always in Granular option", (Object)attribute.getGranularOption(), (Object)Attribute.GranularOption.Always);
                AttributeTest.assertEquals((String)"Attribute \"DomainLink\" has link reference", (Object)attribute.getLinkReference(), (Object)Attribute.LinkReference.Never);
                AttributeTest.assertEquals((String)"Attribute \"DomainLink\" has value reference", (Object)attribute.getValueReference(), (Object)Attribute.ValueReference.Never);
                AttributeTest.assertEquals((String)"Attribute \"DomainLink\" value is not being handled as a Value", (Object)attribute.getHandling(), (Object)IAttribute.Handling.Value);
                AttributeTest.assertEquals((String)"Attribute \"DomainLink\" has no ALL API access", (Object)attribute.getAPIAccess(), (Object)IAttribute.APIAccess.All);
            }
            if (!((Attribute)object.get(i)).getName().equals("HasTimeRestriction")) continue;
            attribute = (Attribute)object.get(i);
            AttributeTest.assertEquals((String)"Attribute \"HasTimeRestriction\" is not of Boolean type", (Object)attribute.getDataType(), (Object)IAttribute.DataType.Boolean);
            AttributeTest.assertEquals((String)"Attribute \"HasTimeRestriction\" is of unique kind", (Object)attribute.getUniqueness(), (Object)Attribute.Uniqueness.No);
            AttributeTest.assertEquals((String)"Attribute \"HasTimeRestriction\" does not have \"Never\" option in ValueReference", (Object)attribute.getValueReference(), (Object)Attribute.ValueReference.Never);
            AttributeTest.assertEquals((String)"Attribute \"HasTimeRestriction\" value is not being handled as Value", (Object)attribute.getHandling(), (Object)IAttribute.Handling.Value);
        }
    }

    @TestBase.STI(value=2)
    public void testXPSAttributes() throws Exception {
        Class clazz = SetupConnection.dictionary.fetchClass("CA", "XPS", "SecurityCategory");
        AttributeTest.assertFalse((String)"testXPSAttributes: Failed to fetch CA::XPS.SecurityCategory class", (clazz == null ? 1 : 0) != 0);
        List list = clazz.getAttributes();
        AttributeTest.assertEquals((String)"testXPSAttributes: Mismatch in number of attributes", (int)list.size(), (int)9);
        for (int i = 0; i < 9; ++i) {
            Attribute attribute;
            if (((Attribute)list.get(i)).getName().equals("Name")) {
                attribute = (Attribute)list.get(i);
                AttributeTest.assertEquals((String)"Attribute \"Name\" is not a String", (Object)attribute.getDataType(), (Object)IAttribute.DataType.String);
                AttributeTest.assertEquals((String)"Attribute \"Name\" does not have maximum length 32", (int)attribute.getMaxLength(), (int)32);
                AttributeTest.assertEquals((String)"Attribute \"Name\" has no uniqueness with in parent node", (Object)attribute.getUniqueness(), (Object)Attribute.Uniqueness.WithinParent);
                AttributeTest.assertEquals((String)"Attribute \"Name\" value is not being handled as a Value", (Object)attribute.getHandling(), (Object)IAttribute.Handling.Value);
                AttributeTest.assertEquals((String)"Attribute \"Name\" has no value \"Never\" in ValueReference", (Object)attribute.getValueReference(), (Object)Attribute.ValueReference.Never);
                AttributeTest.assertEquals((String)"Attribute \"Name\" Attribute has no ALL API access", (Object)attribute.getAPIAccess(), (Object)IAttribute.APIAccess.All);
            }
            if (((Attribute)list.get(i)).getName().equals("ScopingClass")) {
                attribute = (Attribute)list.get(i);
                AttributeTest.assertEquals((String)"Attribute \"ScopingClass\" is not of type Link", (Object)attribute.getDataType(), (Object)IAttribute.DataType.Link);
                AttributeTest.assertEquals((String)"Attribute \"ScopingClass\" is of kind Unique", (Object)attribute.getUniqueness(), (Object)Attribute.Uniqueness.No);
                AttributeTest.assertEquals((String)"Attribute \"ScopingClass\" belongs to class Domain", (String)attribute.getLinkToClass().getName(), (String)"Class");
                AttributeTest.assertEquals((String)"Attribute \"ScopingClass\" does not have Always in Granular option", (Object)attribute.getGranularOption(), (Object)Attribute.GranularOption.Always);
                AttributeTest.assertEquals((String)"Attribute \"ScopingClass\" has link reference", (Object)attribute.getLinkReference(), (Object)Attribute.LinkReference.Never);
                AttributeTest.assertEquals((String)"Attribute \"ScopingClass\" has value reference", (Object)attribute.getValueReference(), (Object)Attribute.ValueReference.Never);
                AttributeTest.assertEquals((String)"Attribute \"ScopingClass\" value is not being handled as a value", (Object)attribute.getHandling(), (Object)IAttribute.Handling.Value);
                AttributeTest.assertEquals((String)"Attribute \"ScopingClass\" has no ALL API access", (Object)attribute.getAPIAccess(), (Object)IAttribute.APIAccess.All);
            }
            if (((Attribute)list.get(i)).getName().equals("CopyScope")) {
                attribute = (Attribute)list.get(i);
                AttributeTest.assertEquals((String)"Attribute \"CopyScope\" is not of Integer type", (Object)attribute.getDataType(), (Object)IAttribute.DataType.Integer);
                AttributeTest.assertEquals((String)"Attribute \"CopyScope\" is of unique kind", (Object)attribute.getUniqueness(), (Object)Attribute.Uniqueness.No);
                AttributeTest.assertEquals((String)"Attribute \"CopyScope\" value is not being handled as an Enumeration value", (Object)attribute.getHandling(), (Object)IAttribute.Handling.Enumeration);
                AttributeTest.assertEquals((String)"Attribute \"CopyScope\" has no ALL API access", (Object)attribute.getAPIAccess(), (Object)IAttribute.APIAccess.All);
            }
            if (!((Attribute)list.get(i)).getName().equals("Obsolete")) continue;
            attribute = (Attribute)list.get(i);
            AttributeTest.assertEquals((String)"Attribute \"Obsolete\" is not of Boolean type", (Object)attribute.getDataType(), (Object)IAttribute.DataType.Boolean);
            AttributeTest.assertEquals((String)"Attribute \"Obsolete\" is of kind Unique", (Object)attribute.getUniqueness(), (Object)Attribute.Uniqueness.No);
            AttributeTest.assertEquals((String)"Attribute \"Obsolete\" value is not being handled as a value", (Object)attribute.getHandling(), (Object)IAttribute.Handling.Value);
        }
    }

    @TestBase.STI(value=3)
    public void testEPMAttributes() throws Exception {
        Class clazz = SetupConnection.dictionary.fetchClass("CA", "EPM", "Role");
        AttributeTest.assertFalse((String)"Failed to fetch CA::EPM.Role class", (clazz == null ? 1 : 0) != 0);
        List list = clazz.getAttributes();
        AttributeTest.assertSize("attributes", list, 6);
        for (int i = 0; i < 6; ++i) {
            Attribute attribute;
            if (((Attribute)list.get(i)).getName().equals("Name")) {
                attribute = (Attribute)list.get(i);
                AttributeTest.assertEquals((String)"Attribute \"Name\" is not a String", (Object)attribute.getDataType(), (Object)IAttribute.DataType.String);
                AttributeTest.assertEquals((String)"Attribute \"Name\" does not have maximum length 255", (int)attribute.getMaxLength(), (int)255);
                AttributeTest.assertEquals((String)"Attribute \"Name\" is not of kind Unique Within Parent", (Object)attribute.getUniqueness(), (Object)Attribute.Uniqueness.WithinParent);
                AttributeTest.assertEquals((String)"Attribute \"Name\" value is not being handled as a value", (Object)attribute.getHandling(), (Object)IAttribute.Handling.Value);
                AttributeTest.assertEquals((String)"Attribute \"Name\" has no value reference", (Object)attribute.getValueReference(), (Object)Attribute.ValueReference.Never);
                AttributeTest.assertEquals((String)"Attribute \"Name\" has no ALL API access", (Object)attribute.getAPIAccess(), (Object)IAttribute.APIAccess.All);
            }
            if (((Attribute)list.get(i)).getName().equals("PoliciesLink")) {
                attribute = (Attribute)list.get(i);
                AttributeTest.assertEquals((String)"Attribute \"PoliciesLink\" is not of type Link", (Object)attribute.getDataType(), (Object)IAttribute.DataType.Link);
                AttributeTest.assertEquals((String)"Attribute \"PoliciesLink\" is of kind Unique", (Object)attribute.getUniqueness(), (Object)Attribute.Uniqueness.No);
                AttributeTest.assertEquals((String)"Attribute \"PoliciesLink\" value is not being handled as a cascading value", (Object)attribute.getHandling(), (Object)IAttribute.Handling.Cascade);
                AttributeTest.assertEquals((String)"Attribute \"PoliciesLink\" belongs to the class Policy", (String)attribute.getLinkToClass().getName(), (String)"Policy");
                AttributeTest.assertEquals((String)"Attribute \"PoliciesLink\" has no \"Always\" option for GranularOption", (Object)attribute.getGranularOption(), (Object)Attribute.GranularOption.Always);
                AttributeTest.assertEquals((String)"Attribute \"PoliciesLink\" has no link reference", (Object)attribute.getLinkReference(), (Object)Attribute.LinkReference.Never);
                AttributeTest.assertEquals((String)"Attribute \"PoliciesLink\" has no value reference", (Object)attribute.getValueReference(), (Object)Attribute.ValueReference.Never);
                AttributeTest.assertEquals((String)"Attribute \"PoliciesLink\" has no ALL API access", (Object)attribute.getAPIAccess(), (Object)IAttribute.APIAccess.All);
            }
            if (!((Attribute)list.get(i)).getName().equals("Flags")) continue;
            attribute = (Attribute)list.get(i);
            AttributeTest.assertEquals((String)"Attribute \"Flags\" is not an Integer", (Object)attribute.getDataType(), (Object)IAttribute.DataType.Integer);
            AttributeTest.assertEquals((String)"Attribute \"Flags\" is of kind Unique", (Object)attribute.getUniqueness(), (Object)Attribute.Uniqueness.No);
            AttributeTest.assertEquals((String)"Attribute \"Flags\" value is not being handled as a Flags", (Object)attribute.getHandling(), (Object)IAttribute.Handling.Flags);
            AttributeTest.assertEquals((String)"Attribute \"Flags\"  has no ALL API access", (Object)attribute.getAPIAccess(), (Object)IAttribute.APIAccess.All);
            AttributeTest.assertEquals((String)"Attribute \"Flags\" has no value reference", (Object)attribute.getValueReference(), (Object)Attribute.ValueReference.Never);
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AttributeTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AttributeTest.class);
    }
}

