/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.xps;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Workspace;
import com.ca.siteminder.sdk.adminapi.ca.xps.WorkspaceEntry;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.basic.xps.WorkspaceEntryTest;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class WorkspaceTest
extends TestBase {
    static Workspace workspace;

    @TestBase.STI(value=1)
    public void testCreatWorkspace() throws XPSException {
        String string = "woorkspace" + SetupConnection.random;
        workspace = WorkspaceTest.makeWorkspace(string);
        this.createObject((XPSObject)workspace);
    }

    @TestBase.STI(value=2)
    public void testSearchWorkspace() throws XPSException {
        SetupConnection.fetchByName(Workspace.ddclass, workspace.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateWorkspace() throws XPSException {
        workspace.setDescription("update" + workspace.getName());
        this.updateObject((XPSObject)workspace);
    }

    @TestBase.STI(value=4)
    public void testWorkspaceDeployment() throws XPSException {
        try {
            InternalTesting.testDeployment(SetupConnection.session, (XPSObject)workspace);
            WorkspaceTest.fail((String)"exported workspace");
        }
        catch (ServerException serverException) {
            WorkspaceTest.assertContains(serverException.getMsg(), "not exportable");
        }
    }

    @TestBase.STI(value=5)
    public void testDeleteWorkspace() throws XPSException {
        this.deleteObject((XPSObject)workspace);
        workspace = null;
    }

    @TestBase.STI(value=6)
    public void testWorkspaceWithoutName() throws XPSException {
        workspace = WorkspaceTest.makeWorkspace(null);
        this.failCreate((XPSObject)workspace, "Name");
    }

    @TestBase.STI(value=7)
    public void testClosure() throws XPSException {
        SetupConnection.builder.doUserDirSetUp("TestDomainUserDirectory" + SetupConnection.random);
        List<UserDirectory> list = SetupConnection.builder.getUserDirs("TestDomainUserDirectory" + SetupConnection.random);
        String string = "Domain" + SetupConnection.random;
        Domain domain = SetupConnection.builder.makeDomain(string, list);
        this.createObject((XPSObject)domain);
        WorkspaceEntry workspaceEntry = WorkspaceEntryTest.makeWorkspaceEntry(null, (XPSObject)domain);
        this.createObject((XPSObject)workspaceEntry);
        Workspace workspace = workspaceEntry.getParent();
        List list2 = SetupConnection.security.getWorkspaceClosure(workspace);
        WorkspaceTest.assertEquals((String)"user dirs", list, (Object)list2);
    }

    static Workspace makeWorkspace(String string) {
        Workspace workspace = (Workspace)SetupConnection.policyData.newObject((IClass)Workspace.ddclass);
        if (string != null) {
            workspace.setName(string);
        } else {
            workspace.clearName();
        }
        return workspace;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)WorkspaceTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(WorkspaceTest.class);
    }
}

