/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class RuleTest
extends TestBase {
    static Rule rule;
    static Realm realm;
    static String strRuleName;

    @TestBase.STI(value=1)
    public void testCreateRule() throws XPSException {
        SetupConnection.builder.doDomainSetUp("TestRuleUserDir" + SetupConnection.random, "TestRuleAgent" + SetupConnection.random, null, "TestRuleDomain" + SetupConnection.random, "TestRuleRealm" + SetupConnection.random, null, null, null);
        realm = (Realm)SetupConnection.fetchByName(Realm.ddclass, "TestRuleRealm" + SetupConnection.random);
        strRuleName = "Rule" + SetupConnection.random;
        rule = SetupConnection.builder.makeRule(strRuleName, realm);
        this.createObject((XPSObject)rule);
        List list = realm.getChildren((IClass)Rule.ddclass);
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((Rule)list.get(i)).getName().equals(strRuleName)) continue;
            bl = true;
        }
        RuleTest.assertTrue((String)"Rule, created, must found in the existing Rules", (boolean)bl);
    }

    @TestBase.STI(value=2)
    public void testSearchRule() {
        SetupConnection.fetchByName(Rule.ddclass, rule.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateRule() throws XPSException {
        String string = rule.getDesc();
        rule.setDesc("update" + string);
        this.updateObject((XPSObject)rule);
    }

    @TestBase.STI(value=4)
    public void testRuleDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)rule);
    }

    @TestBase.STI(value=5)
    public void testDeleteRule() throws XPSException {
        this.deleteObject((XPSObject)rule);
        rule = null;
    }

    @TestBase.STI(value=6)
    public void testRuleWithoutName() throws XPSException {
        rule = SetupConnection.builder.makeRule(null, realm);
        this.failCreate((XPSObject)rule, "Name");
    }

    @TestBase.STI(value=7)
    public void testRuleWithoutRealm() throws XPSException {
        rule = SetupConnection.builder.makeRule(strRuleName, null);
        this.failCreate((XPSObject)rule, "parent");
    }

    @TestBase.STI(value=8)
    public void testRuleWithBadAction() throws XPSException {
        strRuleName = strRuleName + "_1";
        rule = SetupConnection.builder.makeRule(strRuleName, realm);
        rule.setActions(Collections.singletonList("POSTx"));
        this.failCreate((XPSObject)rule, "POSTx");
    }

    @TestBase.STI(value=9)
    public void testRuleWithWrongCaseAction() throws XPSException {
        rule = SetupConnection.builder.makeRule(strRuleName, realm);
        rule.setActions(Collections.singletonList("POST"));
        this.createObject((XPSObject)rule);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RuleTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(RuleTest.class);
    }
}

