/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthScheme;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.STIUtil;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class RealmTest
extends TestBase {
    static Agent agent;
    static AuthScheme authScheme;
    static Domain domain;
    static Realm realm;
    static Realm siblingRealm;

    @TestBase.STI(value=1)
    public void testCreateRealm() throws XPSException {
        SetupConnection.builder.doDomainSetUp("TestRealmUserDir" + SetupConnection.random, "TestRealmAgent1" + SetupConnection.random, "TestRealmAgent2" + SetupConnection.random, "TestRealmDomain" + SetupConnection.random, "TestRealm" + SetupConnection.random, null, null, null);
        agent = (Agent)SetupConnection.fetchByName(Agent.ddclass, "testrealmagent2" + SetupConnection.random);
        authScheme = (AuthScheme)SetupConnection.fetchByName(AuthScheme.ddclass, "Basic");
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, "TestRealmDomain" + SetupConnection.random);
        String string = "Realm" + SetupConnection.random;
        realm = SetupConnection.builder.makeRealm(string, agent, authScheme, domain);
        this.createObject((XPSObject)realm);
        List list = domain.getChildren((IClass)Realm.ddclass);
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((Realm)list.get(i)).getName().equals(string)) continue;
            bl = true;
        }
        RealmTest.assertTrue((String)"Realm, created, must found in existing realms", (boolean)bl);
    }

    @TestBase.STI(value=2)
    public void testSearchRealm() {
        SetupConnection.fetchByName(Realm.ddclass, realm.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateRealm() throws XPSException {
        realm.setName("update" + realm.getName());
        realm.setDesc("update" + realm.getDesc());
        this.updateObject((XPSObject)realm);
    }

    @TestBase.STI(value=4)
    public void testRealmDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)realm);
    }

    @TestBase.STI(value=5)
    public void testDeleteRealm() throws XPSException {
        this.deleteObject((XPSObject)realm);
        realm = null;
    }

    @TestBase.STI(value=6)
    public void testRealmWithoutName() throws XPSException {
        realm = SetupConnection.builder.makeRealm(null, agent, authScheme, domain);
        this.failCreate((XPSObject)realm, "Name");
    }

    @TestBase.STI(value=7)
    public void testRealmWithoutDomain() throws XPSException {
        String string = "Realm" + SetupConnection.random;
        realm = SetupConnection.builder.makeRealm(string, agent, authScheme, null);
        this.failCreate((XPSObject)realm, "parent");
    }

    @TestBase.STI(value=8)
    public void testRealmWithoutAgent() throws XPSException {
        String string = "Realm" + SetupConnection.random;
        realm = SetupConnection.builder.makeRealm(string, null, authScheme, domain);
        this.failCreate((XPSObject)realm, "AgentLink");
    }

    @TestBase.STI(value=9)
    public void testRealmWithoutAuthScheme() throws XPSException {
        String string = "Realm" + SetupConnection.random;
        realm = SetupConnection.builder.makeRealm(string, agent, null, domain);
        this.failCreate((XPSObject)realm, "AuthSchemeCount");
    }

    @TestBase.STI(value=10)
    public void testCreateNestedRealm() throws XPSException {
        List list = domain.getChildren((IClass)Realm.ddclass);
        RealmTest.assertFalse((String)"No realms exists under \"TestRealmDomain\"", (list.size() == 0 ? 1 : 0) != 0);
        Realm realm = (Realm)list.get(0);
        String string = "NestedRealm " + SetupConnection.random;
        RealmTest.realm = SetupConnection.builder.makeRealm(string, realm.getAgent(), realm.getAuthScheme(), domain);
        RealmTest.realm.clearResourceFilter();
        RealmTest.realm.setParentRealm(realm);
        RealmTest.realm.setResourceFilter("Test10/");
        this.createObject((XPSObject)RealmTest.realm);
    }

    @TestBase.STI(value=11)
    public void uniqueResourceNestedRealmPositive() throws XPSException {
        Realm realm = RealmTest.realm.getParentRealm();
        RealmTest.realm.setResourceFilter(realm.getResourceFilter());
        this.updateObject((XPSObject)RealmTest.realm);
    }

    @TestBase.STI(value=12)
    public void uniqueResourceNestedRealmNegative() throws XPSException {
        siblingRealm = realm.duplicate();
        siblingRealm.setName(realm.getName() + "_sibling");
        STIUtil.failCreate(SetupConnection.policyData, (XPSObject)siblingRealm, "Duplicate");
    }

    @TestBase.STI(value=13)
    public void uniqueNameNestedRealmPositive() throws XPSException {
        Realm realm = RealmTest.realm.getParentRealm();
        RealmTest.realm.setName(realm.getName());
        this.updateObject((XPSObject)RealmTest.realm);
    }

    @TestBase.STI(value=14)
    public void uniqueNameNestedRealmNegative() throws XPSException {
        siblingRealm = realm.duplicate();
        siblingRealm.setResourceFilter(realm.getResourceFilter() + "_sibling");
        STIUtil.failCreate(SetupConnection.policyData, (XPSObject)siblingRealm, "Duplicate");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RealmTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(RealmTest.class);
    }
}

