/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.sm.PolicyLink;
import com.ca.siteminder.sdk.adminapi.ca.sm.Response;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class PolicyLinkTest
extends TestBase {
    static PolicyLink policyLink;

    @TestBase.STI(value=1)
    public void testCreatePolicyLink() throws XPSException {
        SetupConnection.builder.doDomainSetUp("TestPolicyLinkUserDir" + SetupConnection.random, "TestPolicyLinkAgent1" + SetupConnection.random, null, "TestPolicyLinkDomain" + SetupConnection.random, "TestPolicyLinkRealm" + SetupConnection.random, "TestPolicyLinkRule" + SetupConnection.random, "TestPolicyLinkResponse" + SetupConnection.random, "TestPolicy" + SetupConnection.random);
        policyLink = this.makePolicyLink("TestPolicy" + SetupConnection.random);
        this.createObject((XPSObject)policyLink);
    }

    @TestBase.STI(value=2)
    public void testSearchPolicyLink() {
        Rule rule = (Rule)SetupConnection.fetchByName(Rule.ddclass, "TestPolicyLinkRule" + SetupConnection.random);
        Filter filter = new Filter((IAttribute)PolicyLink.RULE, Clause.Operator.EQUAL, (Object)rule);
        List list = SetupConnection.policyData.search((IClass)PolicyLink.ddclass, filter);
        PolicyLinkTest.assertFalse((String)"policyData.search returned empty policyLinks", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdatePolicyLink() throws XPSException {
        policyLink.clearResponse();
        this.updateObject((XPSObject)policyLink);
    }

    @TestBase.STI(value=4)
    public void testPolicyLinkDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)policyLink);
    }

    @TestBase.STI(value=5)
    public void testDeletePolicyLink() throws XPSException {
        this.deleteObject((XPSObject)policyLink);
        policyLink = null;
    }

    @TestBase.STI(value=6)
    public void testPolicyLinkWithoutParent() throws XPSException {
        policyLink = this.makePolicyLink(null);
        this.failCreate((XPSObject)policyLink, "parent");
    }

    @TestBase.STI(value=7)
    public void testPolicyLinkWithoutRule() throws XPSException {
        policyLink = this.makePolicyLink("TestPolicy" + SetupConnection.random);
        policyLink.clearResponse();
        policyLink.clearRule();
        this.failCreate((XPSObject)policyLink, "Rule");
    }

    private PolicyLink makePolicyLink(String string) throws XPSException {
        Policy policy;
        PolicyLink policyLink = (PolicyLink)SetupConnection.policyData.newObject((IClass)PolicyLink.ddclass);
        if (string != null) {
            policy = (Policy)SetupConnection.fetchByName(Policy.ddclass, string);
            policyLink.setParent(policy);
        }
        policy = (Rule)SetupConnection.fetchByName(Rule.ddclass, "TestPolicyLinkRule" + SetupConnection.random);
        policyLink.setRule((Rule)policy);
        Response response = (Response)SetupConnection.fetchByName(Response.ddclass, "TestPolicyLinkResponse" + SetupConnection.random);
        policyLink.setResponse(response);
        return policyLink;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)PolicyLinkTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(PolicyLinkTest.class);
    }
}

