/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IdentityMapping;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IdentityMappingTest
extends TestBase {
    static String strName;
    static IdentityMapping identityMapping;

    @TestBase.STI(value=1)
    public void testCreateAzIdentityMapping() throws XPSException {
        strName = "AzIdentityMapping" + SetupConnection.random;
        identityMapping = SetupConnection.builder.makeIdentityMapping(strName, "az");
        this.createObject((XPSObject)identityMapping);
    }

    @TestBase.STI(value=2)
    public void testSearchIdentityMapping() {
        SetupConnection.fetchByName(IdentityMapping.ddclass, identityMapping.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateIdentityMapping() throws XPSException {
        identityMapping.setName("update" + identityMapping.getName());
        identityMapping.setDescription("update" + identityMapping.getDescription());
        this.updateObject((XPSObject)identityMapping);
    }

    @TestBase.STI(value=4)
    public void testIdentityMappingDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)identityMapping);
    }

    @TestBase.STI(value=5)
    public void testdeleteAzIdentityMapping() throws XPSException {
        this.deleteObject((XPSObject)identityMapping);
        identityMapping = null;
    }

    @TestBase.STI(value=6)
    public void testCreateValidateIdentityMapping() throws XPSException {
        strName = "ValidateIdentityMapping" + SetupConnection.random;
        identityMapping = SetupConnection.builder.makeIdentityMapping(strName, "validate");
        this.createObject((XPSObject)identityMapping);
    }

    @TestBase.STI(value=7)
    public void testDeleteValidateIdentityMapping() throws XPSException {
        this.deleteObject((XPSObject)identityMapping);
        identityMapping = null;
    }

    @TestBase.STI(value=8)
    public void testIdentityMappingWithoutName() throws XPSException {
        identityMapping = SetupConnection.builder.makeIdentityMapping(null, "az");
        this.failCreate((XPSObject)identityMapping, "Name");
    }

    @TestBase.STI(value=9)
    public void testIdentityMappingWithoutMapping() throws XPSException {
        strName = "IdentityMapping2" + SetupConnection.random;
        identityMapping = SetupConnection.builder.makeIdentityMapping(strName, "");
        this.createObject((XPSObject)identityMapping);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IdentityMappingTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IdentityMappingTest.class);
    }
}

