/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalPolicy;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalPolicyLink;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalResponse;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalRule;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.sm.Response;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class GlobalPolicyLinkTest
extends TestBase {
    static GlobalPolicyLink globalPolicyLink;

    @TestBase.STI(value=1)
    public void testCreateGlobalPolicyLink() throws XPSException {
        globalPolicyLink = this.makeGlobalPolicyLink("TestGlobalPolicyLink" + SetupConnection.random);
        this.createObject((XPSObject)globalPolicyLink);
    }

    @TestBase.STI(value=2)
    public void testSearchGlobalPolicyLink() {
        GlobalRule globalRule = (GlobalRule)SetupConnection.fetchByName(GlobalRule.ddclass, "TestGlobalPolicyRule" + SetupConnection.random);
        Filter filter = new Filter((IAttribute)GlobalPolicyLink.RULE, Clause.Operator.EQUAL, (Object)globalRule);
        List list = SetupConnection.policyData.search((IClass)GlobalPolicyLink.ddclass, filter);
        GlobalPolicyLinkTest.assertFalse((String)"policyData.search returned empty policyLinks", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdateGlobalPolicyLink() throws XPSException {
        globalPolicyLink.clearResponse();
        this.updateObject((XPSObject)globalPolicyLink);
    }

    @TestBase.STI(value=4)
    public void testGlobalPolicyLinkDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)globalPolicyLink, false);
    }

    @TestBase.STI(value=5)
    public void testDeletePolicyLink() throws XPSException {
        this.deleteObject((XPSObject)globalPolicyLink);
        globalPolicyLink = null;
    }

    @TestBase.STI(value=6)
    public void testGlobalPolicyLinkWithoutParent() throws XPSException {
        globalPolicyLink = this.makeGlobalPolicyLink(null);
        this.failCreate((XPSObject)globalPolicyLink, "parent");
    }

    @TestBase.STI(value=7)
    public void testGlobalPolicyLinkWithoutRule() throws XPSException {
        globalPolicyLink = this.makeGlobalPolicyLink("TestGlobalPolicyLink" + SetupConnection.random);
        globalPolicyLink.clearRule();
        globalPolicyLink.clearResponse();
        this.failCreate((XPSObject)globalPolicyLink, "RuleLink");
    }

    private GlobalPolicyLink makeGlobalPolicyLink(String string) throws XPSException {
        GlobalPolicy globalPolicy;
        GlobalPolicyLink globalPolicyLink = (GlobalPolicyLink)SetupConnection.policyData.newObject((IClass)GlobalPolicyLink.ddclass);
        if (string != null) {
            globalPolicy = (GlobalPolicy)SetupConnection.fetchByName(GlobalPolicy.ddclass, string);
            globalPolicyLink.setParent((Policy)globalPolicy);
        }
        globalPolicy = (GlobalResponse)SetupConnection.fetchByName(GlobalResponse.ddclass, "TestGlobalPolicyResponse" + SetupConnection.random);
        globalPolicyLink.setResponse((Response)globalPolicy);
        GlobalRule globalRule = (GlobalRule)SetupConnection.fetchByName(GlobalRule.ddclass, "TestGlobalPolicyRule" + SetupConnection.random);
        globalPolicyLink.setRule((Rule)globalRule);
        globalPolicyLink.setIsGlobal(GlobalPolicyLink.IsGlobal.YES);
        return globalPolicyLink;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GlobalPolicyLinkTest.suite());
    }

    public static Test suite() {
        return new GlobalPolicySetup();
    }

    static class GlobalPolicySetup
    extends SetupConnection {
        GlobalPolicySetup() {
            super(GlobalPolicyLinkTest.class);
        }

        @Override
        public void setUp() throws Exception {
            super.setUp();
            this.doGlobalPolicySetup();
        }

        private void doGlobalPolicySetup() throws XPSException {
            Agent agent = SetupConnection.builder.makeAgent("TestGlobalPolicyLinkAgent" + SetupConnection.random);
            SetupConnection.createObject((XPSObject)agent);
            GlobalResponse globalResponse = SetupConnection.builder.makeGlobalResponse("TestGlobalPolicyResponse" + SetupConnection.random);
            SetupConnection.createObject((XPSObject)globalResponse);
            GlobalPolicy globalPolicy = SetupConnection.builder.makeGlobalPolicy("TestGlobalPolicyLink" + SetupConnection.random, null);
            SetupConnection.createObject((XPSObject)globalPolicy);
            GlobalRule globalRule = SetupConnection.builder.makeGlobalRule("TestGlobalPolicyRule" + SetupConnection.random, agent);
            SetupConnection.createObject((XPSObject)globalRule);
        }
    }
}

