/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class DomainTest
extends TestBase {
    static Domain domain;
    static String strName;
    static List<UserDirectory> userDirs;

    @TestBase.STI(value=1)
    public void testCreateDomain() throws XPSException {
        SetupConnection.builder.doUserDirSetUp("TestDomainUserDirectory" + SetupConnection.random);
        userDirs = SetupConnection.builder.getUserDirs("TestDomainUserDirectory" + SetupConnection.random);
        strName = "Domain" + SetupConnection.random;
        domain = SetupConnection.builder.makeDomain(strName, userDirs);
        this.createObject((XPSObject)domain);
        List list = domain.getUserDirectories();
        DomainTest.assertEquals((String)"List of created user dirs must match with fetched user directories", (int)userDirs.size(), (int)list.size());
    }

    @TestBase.STI(value=2)
    public void testSearchDomain() {
        SetupConnection.fetchByName(Domain.ddclass, domain.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateDomain() throws XPSException {
        domain.setName("update" + domain.getName());
        domain.setDesc("update" + domain.getDesc());
        this.updateObject((XPSObject)domain);
    }

    @TestBase.STI(value=4)
    public void testDomainDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)domain);
    }

    @TestBase.STI(value=5)
    public void testdeleteDomain() throws XPSException {
        this.deleteObject((XPSObject)domain);
        domain = null;
    }

    @TestBase.STI(value=6)
    public void testDomainWithoutName() throws XPSException {
        domain = SetupConnection.builder.makeDomain(null, userDirs);
        this.failCreate((XPSObject)domain, "Name");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DomainTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(DomainTest.class);
    }
}

