/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.CertMap;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class CertMapTest
extends TestBase {
    static CertMap certMap;
    static UserDirectory userDir;

    @TestBase.STI(value=1)
    public void testCreateCertMap() throws XPSException {
        SetupConnection.builder.doUserDirSetUp("TestCertUserDir" + SetupConnection.random);
        userDir = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, "TestCertUserDir" + SetupConnection.random);
        certMap = CertMapTest.makeCertMap(userDir);
        this.createObject((XPSObject)certMap);
    }

    @TestBase.STI(value=2)
    public void testSearchCreateCertMap() {
        Filter filter = new Filter((IAttribute)CertMap.ISSUERDN, Clause.Operator.EQUAL, (Object)"uid=SM,dc=netegrity,dc=com");
        Filter filter2 = new Filter((IAttribute)CertMap.MAPTOLDAP, Clause.Operator.EQUAL, (Object)"%{UID}");
        filter.OR(filter2);
        List list = SetupConnection.policyData.search((IClass)CertMap.ddclass, filter);
        CertMapTest.assertFalse((String)"policyData.search returned empty certMap", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdateCertMap() throws XPSException {
        certMap.setMapToLDAP("%{UID=*}");
        this.updateObject((XPSObject)certMap);
    }

    @TestBase.STI(value=4)
    public void testCertMapDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)certMap);
    }

    @TestBase.STI(value=5)
    public void testDeleteCertMap() throws XPSException {
        this.deleteObject((XPSObject)certMap);
        certMap = null;
    }

    @TestBase.STI(value=6)
    public void testCertMapWithoutDN() throws XPSException {
        certMap = CertMapTest.makeCertMap(userDir);
        certMap.clearIssuerDN();
        this.failCreate((XPSObject)certMap, "IssuerDN");
    }

    public static CertMap makeCertMap(UserDirectory userDirectory) throws XPSException {
        certMap = (CertMap)SetupConnection.policyData.newObject((IClass)CertMap.ddclass);
        HashSet<CertMap.Flags> hashSet = new HashSet<CertMap.Flags>();
        hashSet.add(CertMap.Flags.LDAPCheckMask);
        if (userDirectory != null) {
            certMap.setUserDirectory(userDirectory);
        }
        certMap.setIssuerDN("uid=SM,dc=netegrity" + SetupConnection.random + ",dc=com");
        certMap.setMapToLDAP("%{UID}");
        certMap.setDirType(CertMap.DirType.LDAPAD);
        certMap.setFlags(hashSet);
        return certMap;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)CertMapTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(CertMapTest.class);
    }
}

