/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AzIdentityMappingEntry;
import com.ca.siteminder.sdk.adminapi.ca.sm.IdentityMapping;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AzIdentityMappingEntryTest
extends TestBase {
    static AzIdentityMappingEntry aZIdentityMappingEntry;
    static String strName;
    static IdentityMapping mapping;

    @TestBase.STI(value=1)
    public void testCreateAzIdentityMappingEntry() throws XPSException {
        SetupConnection.builder.doIdentityMappingSetup("AzIdentityMappingEntry" + SetupConnection.random, "az");
        SetupConnection.builder.doUserDirSetUp("userDirAzIdentityMappingEntry" + SetupConnection.random);
        mapping = (IdentityMapping)SetupConnection.fetchByName(IdentityMapping.ddclass, "AzIdentityMappingEntry" + SetupConnection.random);
        strName = "AzIdentityMappingEntry" + SetupConnection.random;
        aZIdentityMappingEntry = this.makeAzIdentityMappingEntry(strName, mapping);
        this.createObject((XPSObject)aZIdentityMappingEntry);
    }

    @TestBase.STI(value=2)
    public void testSearchAzIdentityMappingEntry() {
        SetupConnection.fetchByName(AzIdentityMappingEntry.ddclass, aZIdentityMappingEntry.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAzIdentityMappingEntry() throws XPSException {
        aZIdentityMappingEntry.setName("update" + aZIdentityMappingEntry.getName());
        aZIdentityMappingEntry.setDescription("update" + aZIdentityMappingEntry.getDescription());
        this.updateObject((XPSObject)aZIdentityMappingEntry);
    }

    @TestBase.STI(value=4)
    public void testAzIdentityMappingEntryDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)aZIdentityMappingEntry);
    }

    @TestBase.STI(value=5)
    public void testdeleteAzAzIdentityMappingEntry() throws XPSException {
        this.deleteObject((XPSObject)aZIdentityMappingEntry);
        aZIdentityMappingEntry = null;
    }

    @TestBase.STI(value=6)
    public void testAzIdentityMappingEntryWithoutName() throws XPSException {
        aZIdentityMappingEntry = this.makeAzIdentityMappingEntry(null, mapping);
        this.failCreate((XPSObject)aZIdentityMappingEntry, "Name");
    }

    @TestBase.STI(value=7)
    public void testAzIdentityMappingEntryWithoutParent() throws XPSException {
        strName = "AzIdentityMappingEntry2" + SetupConnection.random;
        aZIdentityMappingEntry = this.makeAzIdentityMappingEntry(strName, null);
        this.failCreate((XPSObject)aZIdentityMappingEntry, "parent");
    }

    @TestBase.STI(value=8)
    public void testAzIdentityMappingEntryWithoutExpression() throws XPSException {
        strName = "AzIdentityMappingEntry2" + SetupConnection.random;
        aZIdentityMappingEntry = this.makeAzIdentityMappingEntry(strName, mapping);
        aZIdentityMappingEntry.clearUserSearchExpression();
        this.failCreate((XPSObject)aZIdentityMappingEntry, "UserSearchExpression");
    }

    public void doMappingSetup(String string, String string2) throws XPSException {
        IdentityMapping identityMapping = SetupConnection.builder.makeIdentityMapping(string, string2);
        this.createObject((XPSObject)identityMapping);
    }

    private AzIdentityMappingEntry makeAzIdentityMappingEntry(String string, IdentityMapping identityMapping) {
        AzIdentityMappingEntry azIdentityMappingEntry = (AzIdentityMappingEntry)SetupConnection.policyData.newObject((IClass)AzIdentityMappingEntry.ddclass);
        UserDirectory userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, "userDirAzIdentityMappingEntry" + SetupConnection.random);
        if (string != null) {
            azIdentityMappingEntry.setName(string);
        }
        azIdentityMappingEntry.setDescription("XPSAPI JUnit Sample AzIdentityMappingEntry");
        azIdentityMappingEntry.setParent(identityMapping);
        azIdentityMappingEntry.setUserSearchExpression("Identical DN");
        azIdentityMappingEntry.setTargetDir(userDirectory);
        azIdentityMappingEntry.setSourceDir(userDirectory);
        return azIdentityMappingEntry;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AzIdentityMappingEntryTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AzIdentityMappingEntryTest.class);
    }
}

