/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthAzMap;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AuthAzMapTest
extends TestBase {
    static AuthAzMap authAzMap;
    static UserDirectory userDir;

    @TestBase.STI(value=1)
    public void testCreateAuthAzMap() throws XPSException {
        SetupConnection.builder.doUserDirSetUp("TestAuthUserDir" + SetupConnection.random);
        userDir = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, "TestAuthUserDir" + SetupConnection.random);
        authAzMap = AuthAzMapTest.makeAuthAzMap(userDir);
        this.createObject((XPSObject)authAzMap);
    }

    @TestBase.STI(value=2)
    public void testSearchAuthAzMap() {
        Filter filter = new Filter((IAttribute)AuthAzMap.AUTHATTRNAME, Clause.Operator.EQUAL, (Object)"uid2");
        Filter filter2 = new Filter((IAttribute)AuthAzMap.AZATTRNAME, Clause.Operator.EQUAL, (Object)"uid");
        filter.AND(filter2);
        List list = SetupConnection.policyData.search((IClass)AuthAzMap.ddclass, filter);
        AuthAzMapTest.assertFalse((String)"policyData.search returned empty AuthAzMaps", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdateAuthAzMap() throws XPSException {
        authAzMap.setAuthAzMapType(AuthAzMap.AuthAzMapType.DN);
        this.updateObject((XPSObject)authAzMap);
    }

    @TestBase.STI(value=4)
    public void testAuthAzMapDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)authAzMap);
    }

    @TestBase.STI(value=5)
    public void testDeleteAuthAzMap() throws XPSException {
        this.deleteObject((XPSObject)authAzMap);
        authAzMap = null;
    }

    @TestBase.STI(value=6)
    public void testAuthAzMapWithoutAuthDir() throws XPSException {
        authAzMap = AuthAzMapTest.makeAuthAzMap(userDir);
        authAzMap.clearAuthDir();
        this.failCreate((XPSObject)authAzMap, "AuthDirLink");
    }

    @TestBase.STI(value=7)
    public void testAuthAzMapWithoutAzDir() throws XPSException {
        authAzMap = AuthAzMapTest.makeAuthAzMap(userDir);
        authAzMap.clearAzDir();
        this.failCreate((XPSObject)authAzMap, "AzDirLink");
    }

    @TestBase.STI(value=8)
    public void testAuthAzMapNotUnique() throws XPSException {
        authAzMap = AuthAzMapTest.makeAuthAzMap(userDir);
        this.createObject((XPSObject)authAzMap);
        AuthAzMap authAzMap = AuthAzMapTest.authAzMap.duplicate();
        this.failCreate((XPSObject)authAzMap, "unique");
    }

    @TestBase.STI(value=9)
    public void testAuthAzMapWrongType() throws XPSException {
        authAzMap.setAuthAzMapType(AuthAzMap.AuthAzMapType.Unknown);
        this.failUpdate((XPSObject)authAzMap, "Unknown");
    }

    public static AuthAzMap makeAuthAzMap(UserDirectory userDirectory) throws XPSException {
        AuthAzMap authAzMap = (AuthAzMap)SetupConnection.policyData.newObject((IClass)AuthAzMap.ddclass);
        if (userDirectory != null) {
            authAzMap.setAuthDir(userDirectory);
            authAzMap.setAzDir(userDirectory);
        }
        authAzMap.setAzAttrName("uid");
        authAzMap.setAuthAttrName("uid2");
        authAzMap.setAuthAzMapType(AuthAzMap.AuthAzMapType.UniversalID);
        return authAzMap;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AuthAzMapTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AuthAzMapTest.class);
    }
}

