/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentTypeAttr;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AgentTypeAttrTest
extends TestBase {
    static AgentType agentType;
    static AgentTypeAttr agentTypeAttr;
    static String strName;

    @TestBase.STI(value=1)
    public void testCreateAgentTypeAttr() throws XPSException {
        agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        strName = "AgentTypeAttr" + SetupConnection.random;
        agentTypeAttr = this.makeAgentTypeAttr(strName, agentType);
        this.createObject((XPSObject)agentTypeAttr);
        List list = agentType.getChildren((IClass)AgentTypeAttr.ddclass);
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((AgentTypeAttr)list.get(i)).getName().equals(strName)) continue;
            bl = true;
        }
        AgentTypeAttrTest.assertTrue((String)"AgentTypeAttr object, created, must get reflected in existing list", (boolean)bl);
    }

    @TestBase.STI(value=2)
    public void testSearchAgentTypeAttr() {
        SetupConnection.fetchByName(AgentTypeAttr.ddclass, agentTypeAttr.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAgentTypeAttr() throws XPSException {
        agentTypeAttr.setName("update" + agentTypeAttr.getName());
        agentTypeAttr.setDesc("update" + agentTypeAttr.getDesc());
        this.updateObject((XPSObject)agentTypeAttr);
    }

    @TestBase.STI(value=4)
    public void testAgentTypeAttrDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)agentTypeAttr, false);
    }

    @TestBase.STI(value=5)
    public void testDeleteAgentTypeAttr() throws XPSException {
        this.deleteObject((XPSObject)agentTypeAttr);
        agentTypeAttr = null;
    }

    @TestBase.STI(value=6)
    public void testAgentTypeAttrWithoutName() throws XPSException {
        agentTypeAttr = this.makeAgentTypeAttr(null, agentType);
        this.failCreate((XPSObject)agentTypeAttr, "Name");
    }

    @TestBase.STI(value=7)
    public void testAgentTypeAttrWithoutAgentType() throws XPSException {
        strName = "AgentTypeAttr" + SetupConnection.random;
        agentTypeAttr = this.makeAgentTypeAttr(strName, null);
        this.failCreate((XPSObject)agentTypeAttr, "parent");
    }

    private AgentTypeAttr makeAgentTypeAttr(String string, AgentType agentType) throws XPSException {
        AgentTypeAttr agentTypeAttr = (AgentTypeAttr)SetupConnection.policyData.newObject((IClass)AgentTypeAttr.ddclass);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1=2=3");
        if (string != null) {
            agentTypeAttr.setName(string);
        }
        if (agentType != null) {
            agentTypeAttr.setParent(agentType);
        }
        agentTypeAttr.setDesc("XPSAPI JUnit Sample AgentTypeAttr");
        agentTypeAttr.setAccRequestRadiusBehavior(AgentTypeAttr.AccRequestRadiusBehavior.RadiusBehaviorZero);
        agentTypeAttr.setAccResponseRadiusBehavior(AgentTypeAttr.AccResponseRadiusBehavior.RadiusBehaviorZero);
        agentTypeAttr.setAuthAcceptRadiusBehavior(AgentTypeAttr.AuthAcceptRadiusBehavior.RadiusBehaviorZero);
        agentTypeAttr.setAuthChallengeRadiusBehavior(AgentTypeAttr.AuthChallengeRadiusBehavior.RadiusBehaviorZero);
        agentTypeAttr.setAuthRejectRadiusBehavior(AgentTypeAttr.AuthRejectRadiusBehavior.RadiusBehaviorZeroOne);
        agentTypeAttr.setAuthRequestRadiusBehavior(AgentTypeAttr.AuthRequestRadiusBehavior.RadiusBehaviorZeroOne);
        agentTypeAttr.setDataType(AgentTypeAttr.DataType.String);
        agentTypeAttr.setId(Integer.valueOf(0));
        agentTypeAttr.setValues(arrayList);
        agentTypeAttr.setRadiusType(AgentTypeAttr.RadiusType.VendorSpecific);
        return agentTypeAttr;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AgentTypeAttrTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AgentTypeAttrTest.class);
    }
}

