/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Admin;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AdminTest
extends TestBase {
    static Admin admin;

    @TestBase.STI(value=1)
    public void testCreateAdmin() throws XPSException {
        String string = "Admin" + SetupConnection.random;
        admin = AdminTest.makeAdmin(string);
        this.createObject((XPSObject)admin);
    }

    @TestBase.STI(value=2)
    public void testSearchAdmin() {
        SetupConnection.fetchByName(Admin.ddclass, admin.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAdmin() throws XPSException {
        admin.setName("update" + admin.getName());
        admin.setDesc("update" + admin.getDesc());
        this.updateObject((XPSObject)admin);
    }

    @TestBase.STI(value=4)
    public void testAdminDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)admin);
    }

    @TestBase.STI(value=5)
    public void testDeleteAdmin() throws XPSException {
        this.deleteObject((XPSObject)admin);
        admin = null;
    }

    @TestBase.STI(value=6)
    public void testAdminWithoutName() throws XPSException {
        admin = AdminTest.makeAdmin(null);
        this.failCreate((XPSObject)admin, "Name");
    }

    public static Admin makeAdmin(String string) throws XPSException {
        Admin admin = (Admin)SetupConnection.policyData.newObject((IClass)Admin.ddclass);
        if (string != null) {
            admin.setName(string);
        }
        admin.setDesc("XPSAPI JUnit Sample Admin");
        admin.setPassword("firewall");
        admin.setDirectoryAuth(Boolean.valueOf(false));
        admin.setRights(Admin.Rights.None);
        return admin;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AdminTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AdminTest.class);
    }
}

