/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.idm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSIdentityPolicySet;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IMSIdentityPolicySetTest
extends TestBase {
    static IMSIdentityPolicySet imsIdentityPolicySet = null;

    @TestBase.STI(value=1)
    public void testCreateIMSIdentityPolicySet() throws XPSException {
        String string = "IMSIdentityPolicySet" + SetupConnection.random;
        imsIdentityPolicySet = SetupConnection.builder.makeIMSIdentityPolicySet(string);
        this.createObject((XPSObject)imsIdentityPolicySet);
    }

    @TestBase.STI(value=2)
    public void testSearchIMSIdentityPolicySet() {
        SetupConnection.fetchByName(IMSIdentityPolicySet.ddclass, imsIdentityPolicySet.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateIMSIdentityPolicySet() throws XPSException {
        imsIdentityPolicySet.setName("update" + imsIdentityPolicySet.getName());
        imsIdentityPolicySet.setDescription("update" + imsIdentityPolicySet.getDescription());
        this.updateObject((XPSObject)imsIdentityPolicySet);
    }

    @TestBase.STI(value=4)
    public void testIMSIdentityPolicySetDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)imsIdentityPolicySet);
    }

    @TestBase.STI(value=5)
    public void testDeleteIMSIdentityPolicySet() throws XPSException {
        this.deleteObject((XPSObject)imsIdentityPolicySet);
        imsIdentityPolicySet = null;
    }

    @TestBase.STI(value=6)
    public void testIMSIdentityPolicySetWithoutName() throws XPSException {
        imsIdentityPolicySet = SetupConnection.builder.makeIMSIdentityPolicySet(null);
        this.failCreate((XPSObject)imsIdentityPolicySet, "Name");
    }

    @TestBase.STI(value=7)
    public void testIMSIdentityPolicySetCategory() throws XPSException {
        String string = "IMSIdentityPolicySet2" + SetupConnection.random;
        imsIdentityPolicySet = SetupConnection.builder.makeIMSIdentityPolicySet(string);
        imsIdentityPolicySet.clearCategory();
        this.failCreate((XPSObject)imsIdentityPolicySet, "Category");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IMSIdentityPolicySetTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IMSIdentityPolicySetTest.class);
    }
}

