/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.fss;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.sm.PolicyLink;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.ca.sm.Response;
import com.ca.siteminder.sdk.adminapi.ca.sm.ResponseAttr;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.ca.sm.WSFEDSP;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class WSFEDSPTest
extends TestBase {
    static WSFEDSP wSFEDSP;
    static Domain domain;

    @TestBase.STI(value=1)
    public void testCreateWSFEDSP() throws XPSException {
        SetupConnection.builder.doDomainSetUp("TestWSFEDSPUserDir" + SetupConnection.random, "TestWSFEDSPAgent1" + SetupConnection.random, null, "TestWSFEDSPDomain" + SetupConnection.random, "TestWSFEDSPRealm" + SetupConnection.random, "TestWSFEDSPRule" + SetupConnection.random, "TestWSFEDSPResponse" + SetupConnection.random, "TestWSFEDSPPolicy" + SetupConnection.random);
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, "TestWSFEDSPDomain" + SetupConnection.random);
        String string = "WSFEDSP" + SetupConnection.random;
        String string2 = "RPID" + SetupConnection.random;
        wSFEDSP = this.makeWSFEDSP(string, string2, domain);
        this.createObject((XPSObject)wSFEDSP);
        List list = domain.getChildren((IClass)WSFEDSP.ddclass);
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((WSFEDSP)list.get(i)).getName().equals(string.toLowerCase())) continue;
            bl = true;
        }
        WSFEDSPTest.assertTrue((String)"WSFEDSP object not found", (boolean)bl);
        String string3 = "wsfedrp:" + string;
        Agent agent = wSFEDSP.getAgent();
        WSFEDSPTest.assertNotNull((String)"Backing agent not found", (Object)agent);
        WSFEDSPTest.assertEquals((String)"Backing agent has a wrong name", (String)string3.toLowerCase(), (String)agent.getName());
        Realm realm = wSFEDSP.getRealm();
        WSFEDSPTest.assertNotNull((String)"Backing realm not found", (Object)realm);
        WSFEDSPTest.assertEquals((String)"Backing realm has a wrong name", (String)string3.toLowerCase(), (String)realm.getName());
        Rule rule = wSFEDSP.getRule();
        WSFEDSPTest.assertNotNull((String)"Backing rule not found", (Object)rule);
        WSFEDSPTest.assertEquals((String)"Backing rule has a wrong name", (String)string3.toLowerCase(), (String)rule.getName());
        Policy policy = wSFEDSP.getPolicy();
        WSFEDSPTest.assertNotNull((String)"Backing policy not found", (Object)policy);
        WSFEDSPTest.assertEquals((String)"Backing policy has a wrong name", (String)string3.toLowerCase(), (String)policy.getName());
        Response response = wSFEDSP.getResponse();
        WSFEDSPTest.assertNotNull((String)"Backing response not found", (Object)response);
        WSFEDSPTest.assertEquals((String)"Backing response has a wrong name", (String)string3.toLowerCase(), (String)response.getName());
        List list2 = policy.getChildren((IClass)PolicyLink.ddclass);
        WSFEDSPTest.assertNotNull((String)"Backing policy link not found", (Object)list2);
        WSFEDSPTest.assertEquals((String)"Wrong number of backing policy links", (int)1, (int)list2.size());
        List list3 = response.getChildren((IClass)ResponseAttr.ddclass);
        WSFEDSPTest.assertNotNull((String)"Backing response attribute not found", (Object)list3);
        WSFEDSPTest.assertEquals((String)"Wrong number of backing response attributes", (int)1, (int)list3.size());
    }

    @TestBase.STI(value=2)
    public void testSearchWSFEDSP() throws XPSException {
        SetupConnection.fetchByName(WSFEDSP.ddclass, wSFEDSP.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateWSFEDSP() throws XPSException {
        wSFEDSP.setName("update" + wSFEDSP.getName());
        this.updateObject((XPSObject)wSFEDSP);
    }

    @TestBase.STI(value=4)
    public void testWSFEDSPPDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)wSFEDSP);
    }

    @TestBase.STI(value=5)
    public void testDeleteWSFEDSP() throws XPSException {
        this.deleteObject((XPSObject)wSFEDSP);
        wSFEDSP = null;
    }

    @TestBase.STI(value=6)
    public void testWSFEDSPWithoutDomain() throws XPSException {
        String string = "WSFEDSP1" + SetupConnection.random;
        String string2 = "RPID1" + SetupConnection.random;
        wSFEDSP = this.makeWSFEDSP(string, string2, null);
        this.failCreate((XPSObject)wSFEDSP, "parent");
    }

    @TestBase.STI(value=7)
    public void testWSFEDSPWithoutName() throws XPSException {
        String string = "RPID2" + SetupConnection.random;
        wSFEDSP = this.makeWSFEDSP(null, string, domain);
        this.failCreate((XPSObject)wSFEDSP, "Name");
    }

    @TestBase.STI(value=8)
    public void testWSFEDSPWithoutRPID() throws XPSException {
        String string = "WSFEDSP2" + SetupConnection.random;
        wSFEDSP = this.makeWSFEDSP(string, null, domain);
        this.failCreate((XPSObject)wSFEDSP, "RPID");
    }

    private WSFEDSP makeWSFEDSP(String string, String string2, Domain domain) throws XPSException {
        WSFEDSP wSFEDSP = (WSFEDSP)SetupConnection.policyData.newObject((IClass)WSFEDSP.ddclass);
        if (string != null) {
            wSFEDSP.setName(string);
        }
        if (string2 != null) {
            wSFEDSP.setKEY_RPID(string2);
        }
        if (domain != null) {
            wSFEDSP.setParent(domain);
        }
        wSFEDSP.setDSigningAlias("Testing");
        wSFEDSP.setAssertionPluginClass("Assertion");
        wSFEDSP.setAssertionPluginParameters("AssertionParameter");
        wSFEDSP.setDSigningAlias("DSigning");
        wSFEDSP.setNetegrityAffiliateMinderAuthURL("http://AuthUrl");
        wSFEDSP.setSAMLMajorVersion(Integer.valueOf(2));
        wSFEDSP.setSAMLMinorVersion(Integer.valueOf(0));
        wSFEDSP.setSkewTime(Integer.valueOf(30));
        wSFEDSP.setValidityDuration(Integer.valueOf(60));
        wSFEDSP.setApplicationURL("http://application");
        wSFEDSP.setAssertionConsumerDefaultURL("http://consumer");
        wSFEDSP.setAssertionPluginClass("Assertion");
        wSFEDSP.setAssertionPluginParameters("AssertionParameter");
        wSFEDSP.setDisableSignatureProcessing(Boolean.valueOf(false));
        wSFEDSP.setNameIdAttrName("XPSAPIAttribute");
        wSFEDSP.setNameIdDNSpec("XPSAPIDomain");
        wSFEDSP.setNameIdFormat("ab=dc");
        wSFEDSP.setNameIdType(Integer.valueOf(2));
        wSFEDSP.setAuthenticationLevel(Integer.valueOf(2));
        wSFEDSP.setNameIdType(Integer.valueOf(2));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1.1.1.1");
        arrayList.add("2.2.2.2");
        wSFEDSP.setIPAddresses(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("first");
        arrayList2.add("second");
        wSFEDSP.setAttributeList(arrayList2);
        return wSFEDSP;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)WSFEDSPTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(WSFEDSPTest.class);
    }
}

