/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.fss;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthScheme;
import com.ca.siteminder.sdk.adminapi.ca.sm.SAMLv1IdP;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class SAMLv1IdPTest
extends TestBase {
    static SAMLv1IdP sAMLv1IdP;
    static String name;
    static AuthScheme scheme;

    @TestBase.STI(value=1)
    public void testCreateSAMLv1IdP() throws XPSException {
        name = "TestSAMLv1IdPAuthScheme" + SetupConnection.random;
        scheme = this.doAuthValidateSetUp(name);
        sAMLv1IdP = this.makeSAMLv1IdP(true);
        this.createObject((XPSObject)sAMLv1IdP);
    }

    @TestBase.STI(value=2)
    public void testSearchSAMLv1IdP() throws XPSException {
        Filter filter = new Filter((IAttribute)SAMLv1IdP.FAILUREREDIRECTMODE, Clause.Operator.EQUAL, (Object)1);
        Filter filter2 = new Filter((IAttribute)SAMLv1IdP.INVALIDREDIRECTMODE, Clause.Operator.EQUAL, (Object)2);
        filter.AND(filter2);
        List list = SetupConnection.policyData.search((IClass)SAMLv1IdP.ddclass, filter);
        SAMLv1IdPTest.assertSize("SAMLv1IdP list", list, 1);
    }

    @TestBase.STI(value=3)
    public void testUpdateSAMLv1IdP() throws XPSException {
        sAMLv1IdP.setFailureRedirectMode(Integer.valueOf(2));
        sAMLv1IdP.setInvalidRedirectMode(Integer.valueOf(1));
        this.updateObject((XPSObject)sAMLv1IdP);
    }

    @TestBase.STI(value=4)
    public void testSAMLv1IdPDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)sAMLv1IdP);
    }

    @TestBase.STI(value=5)
    public void testDeleteSAMLv1IdP() throws XPSException {
        this.deleteObject((XPSObject)sAMLv1IdP);
        sAMLv1IdP = null;
    }

    @TestBase.STI(value=6)
    public void testSAMLv1IdPWithoutParent() throws XPSException {
        sAMLv1IdP = this.makeSAMLv1IdP(false);
        this.failCreate((XPSObject)sAMLv1IdP, "parent");
    }

    private SAMLv1IdP makeSAMLv1IdP(boolean bl) throws XPSException {
        SAMLv1IdP sAMLv1IdP = (SAMLv1IdP)SetupConnection.policyData.newObject((IClass)SAMLv1IdP.ddclass);
        if (bl) {
            sAMLv1IdP.setParent(scheme);
        }
        sAMLv1IdP.setIsActive(Boolean.valueOf(false));
        sAMLv1IdP.setFailureRedirectMode(Integer.valueOf(1));
        sAMLv1IdP.setFailureRedirectURL("http://failure");
        sAMLv1IdP.setInvalidRedirectMode(Integer.valueOf(2));
        sAMLv1IdP.setInvalidRedirectURL("http://Redirect");
        sAMLv1IdP.setSAML1PluginClass("PluginClass");
        sAMLv1IdP.setSAML1PluginParameters("testing");
        sAMLv1IdP.setUserNotFoundRedirectMode(Integer.valueOf(3));
        sAMLv1IdP.setUserNotFoundRedirectURL("http://UserNotFound");
        return sAMLv1IdP;
    }

    private AuthScheme doAuthValidateSetUp(String string) throws XPSException {
        AuthScheme authScheme = SetupConnection.builder.makeAuthScheme(string);
        this.createObject((XPSObject)authScheme);
        return authScheme;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SAMLv1IdPTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(SAMLv1IdPTest.class);
    }
}

