/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.epm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.LDAPUserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class LDAPUserDirectoryTest
extends TestBase {
    static LDAPUserDirectory lDAPUserDirectory;
    static UserDirectory userDir;

    @TestBase.STI(value=1)
    public void testCreateLDAPUserDirectory() throws XPSException {
        SetupConnection.builder.doUserDirSetUp("TestDomainUserDirectory" + SetupConnection.random);
        userDir = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, "TestDomainUserDirectory" + SetupConnection.random);
        lDAPUserDirectory = this.makeLDAPUserDirectory(userDir);
        this.createObject((XPSObject)lDAPUserDirectory);
    }

    @TestBase.STI(value=2)
    public void testSearchLDAPUserDirectory() throws XPSException {
        Filter filter = new Filter((IAttribute)LDAPUserDirectory.POLICYSERVERNAME, Clause.Operator.EQUAL, (Object)"siteminder");
        Filter filter2 = new Filter((IAttribute)LDAPUserDirectory.WRITEBACKSERVER, Clause.Operator.EQUAL, (Object)"testing");
        filter.AND(filter2);
        List list = SetupConnection.policyData.search((IClass)LDAPUserDirectory.ddclass, filter);
        LDAPUserDirectoryTest.assertFalse((String)"policyData.search returned empty list", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdateLDAPUserDirectory() throws XPSException {
        lDAPUserDirectory.setWritebackServer("testing2");
        this.updateObject((XPSObject)lDAPUserDirectory);
    }

    @TestBase.STI(value=4)
    public void testLDAPUserDirectoryDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)lDAPUserDirectory);
    }

    @TestBase.STI(value=5)
    public void testLDAPUserDirectoryFEDEncryption() {
        String string = "{FEDAESKW}xxx";
        lDAPUserDirectory.setWritebackPassword(string);
        this.updateObject((XPSObject)lDAPUserDirectory);
        string = "{AESKW}xxxx";
        lDAPUserDirectory.setWritebackPassword(string);
        this.updateObject((XPSObject)lDAPUserDirectory);
    }

    @TestBase.STI(value=6)
    public void testDeleteLDAPUserDirectory() throws XPSException {
        this.deleteObject((XPSObject)lDAPUserDirectory);
        lDAPUserDirectory = null;
    }

    @TestBase.STI(value=7)
    public void testLDAPUserDirectoryWithoutParent() throws XPSException {
        lDAPUserDirectory = this.makeLDAPUserDirectory(null);
        this.failCreate((XPSObject)lDAPUserDirectory, "parent");
    }

    private LDAPUserDirectory makeLDAPUserDirectory(UserDirectory userDirectory) throws XPSException {
        LDAPUserDirectory lDAPUserDirectory = (LDAPUserDirectory)SetupConnection.policyData.newObject((IClass)LDAPUserDirectory.ddclass);
        if (userDirectory != null) {
            lDAPUserDirectory.setParent(userDirectory);
        }
        lDAPUserDirectory.setPolicyServerName("siteminder");
        lDAPUserDirectory.setTimeout(Integer.valueOf(60));
        lDAPUserDirectory.setWritebackAdministrator("siteminder");
        lDAPUserDirectory.setWritebackPassword("firewall");
        lDAPUserDirectory.setWritebackServer("testing");
        return lDAPUserDirectory;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)LDAPUserDirectoryTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(LDAPUserDirectoryTest.class);
    }
}

