/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.epm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.Application;
import com.ca.siteminder.sdk.adminapi.ca.epm.CapabilityGroup;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class CapabilityGroupTest
extends TestBase {
    static CapabilityGroup capabilityGroup;
    static Application app;
    static Realm realm;
    static Rule rule;

    @TestBase.STI(value=1)
    public void testCreateCapabilityGroup() throws XPSException {
        SetupConnection.builder.doApplicationSetUp("TestAppGroupUserDir" + SetupConnection.random, "TestAppGroupApp" + SetupConnection.random);
        app = (Application)SetupConnection.fetchByName(Application.ddclass, "TestAppGroupApp" + SetupConnection.random);
        SetupConnection.builder.doDomainSetUp("TestRuleUserDir" + SetupConnection.random, "TestRuleAgent" + SetupConnection.random, null, "TestRuleDomain" + SetupConnection.random, "TestRuleRealm" + SetupConnection.random, null, null, null);
        realm = (Realm)SetupConnection.fetchByName(Realm.ddclass, "TestRuleRealm" + SetupConnection.random);
        String string = "Rule" + SetupConnection.random;
        rule = SetupConnection.builder.makeRule(string, realm);
        this.createObject((XPSObject)rule);
        String string2 = "CapabilityGroup" + SetupConnection.random;
        capabilityGroup = this.makeCapabilityGroup(string2, app);
        capabilityGroup.setRealm(realm);
        capabilityGroup.setRule(rule);
        this.createObject((XPSObject)capabilityGroup);
    }

    @TestBase.STI(value=2)
    public void testSearchCapabilityGroup() throws XPSException {
        SetupConnection.fetchByName(CapabilityGroup.ddclass, capabilityGroup.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateCapabilityGroup() throws XPSException {
        capabilityGroup.setName("update" + capabilityGroup.getName());
        capabilityGroup.setDesc("update" + capabilityGroup.getDesc());
        this.updateObject((XPSObject)capabilityGroup);
    }

    @TestBase.STI(value=4)
    public void testCapabilityGroupDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)capabilityGroup);
    }

    @TestBase.STI(value=5)
    public void testDeleteCapabilityGroup() throws XPSException {
        this.deleteObject((XPSObject)capabilityGroup);
        capabilityGroup = null;
    }

    @TestBase.STI(value=6)
    public void testCapabilityGroupWithoutName() throws XPSException {
        capabilityGroup = this.makeCapabilityGroup(null, app);
        this.failCreate((XPSObject)capabilityGroup, "Name");
    }

    @TestBase.STI(value=7)
    public void testCapabilityGroupWithoutParent() throws XPSException {
        String string = "CapabilityGroup2" + SetupConnection.random;
        capabilityGroup = this.makeCapabilityGroup(string, null);
        this.failCreate((XPSObject)capabilityGroup, "parent");
    }

    @TestBase.STI(value=8)
    public void testCapabilityGroupWithoutAgentType() throws XPSException {
        String string = "CapabilityGroup2" + SetupConnection.random;
        capabilityGroup = this.makeCapabilityGroup(string, app);
        capabilityGroup.clearAgentType();
        this.failCreate((XPSObject)capabilityGroup, "AgentTypeLink");
    }

    private CapabilityGroup makeCapabilityGroup(String string, Application application) throws XPSException {
        CapabilityGroup capabilityGroup = (CapabilityGroup)SetupConnection.policyData.newObject((IClass)CapabilityGroup.ddclass);
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        capabilityGroup.setAgentType(agentType);
        if (string != null) {
            capabilityGroup.setName(string);
        }
        if (application != null) {
            capabilityGroup.setParent((Domain)application);
        }
        capabilityGroup.setDesc("XPSAPI JUnit Sample CapabilityGroup");
        return capabilityGroup;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)CapabilityGroupTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(CapabilityGroupTest.class);
    }
}

