/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.epm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.Application;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class ApplicationTest
extends TestBase {
    static String strName;
    static Application application;
    static List<UserDirectory> userDirs;

    @TestBase.STI(value=1)
    public void testCreateApplication() throws XPSException {
        SetupConnection.builder.doUserDirSetUp("TestDomainUserDirectory" + SetupConnection.random);
        userDirs = SetupConnection.builder.getUserDirs("TestDomainUserDirectory" + SetupConnection.random);
        strName = "Application" + SetupConnection.random;
        application = SetupConnection.builder.makeApplication(strName, userDirs);
        this.createObject((XPSObject)application);
    }

    @TestBase.STI(value=2)
    public void testSearchApplication() throws XPSException {
        SetupConnection.fetchByName(Application.ddclass, application.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateApplication() throws XPSException {
        application.setName("update" + application.getName());
        application.setDesc("update" + application.getDesc());
        this.updateObject((XPSObject)application);
    }

    @TestBase.STI(value=4)
    public void testApplicationDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)application);
    }

    @TestBase.STI(value=5)
    public void testDeleteApplication() throws XPSException {
        this.deleteObject((XPSObject)application);
        application = null;
    }

    @TestBase.STI(value=6)
    public void testApplicationWithoutName() throws XPSException {
        application = SetupConnection.builder.makeApplication(null, userDirs);
        this.failCreate((XPSObject)application, "Name");
    }

    @TestBase.STI(value=7)
    public void testApplicationWithWrongCustomAttributesFormat() throws XPSException {
        application = SetupConnection.builder.makeApplication(strName, userDirs);
        application.setCustomAttributes(Collections.singletonList("xxx"));
        this.failCreate((XPSObject)application, "Custom attribute");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ApplicationTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(ApplicationTest.class);
    }
}

