/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.alias;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.alias.AliasBase;
import java.util.ArrayList;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IntegerListAliasTest
extends AliasBase {
    @TestBase.STI(value=1)
    public void testIntegerListAlias() throws XPSException {
        IntegerListAliasTest.assertEquals((String)"AliasToIntegerList attribute must match with AliasedInteger", gMainTest.getAliasToIntegerList(), (Object)lAliasedInteger);
    }

    @TestBase.STI(value=2)
    public void testIntegerListAliasForward() throws XPSException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(100);
        arrayList.add(200);
        arrayList.add(300);
        gMainTest.setAliasToIntegerList(arrayList);
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        IntegerListAliasTest.assertEquals((String)"IntegerList attribute is not updated", test.getIntegerList(), arrayList);
    }

    @TestBase.STI(value=3)
    public void testIntegerListAliasBackward() throws XPSException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(400);
        arrayList.add(500);
        arrayList.add(600);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.setIntegerList(arrayList);
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        IntegerListAliasTest.assertEquals((String)"AliasToIntegerList is not updated", gMainTest.getAliasToIntegerList(), arrayList);
    }

    @TestBase.STI(value=4)
    public void testIntegerListAliasCleared() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.clearIntegerList();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        IntegerListAliasTest.assertTrue((String)"AliasToIntegerList attribute is not cleared", (boolean)gMainTest.getAliasToIntegerList().isEmpty());
    }

    @TestBase.STI(value=5)
    public void testIntegerListMainCleared() throws XPSException {
        gMainTest.clearAliasToIntegerList();
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        IntegerListAliasTest.assertTrue((String)"IntegerList attribute is not cleared", (boolean)test.getIntegerList().isEmpty());
    }

    @TestBase.STI(value=6)
    public void testIntegerListSetAliasBeforeLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(null);
        IntegerListAliasTest.assertEquals((String)"Before setLink, AliasToIntegerList must match with MainInteger", test.getAliasToIntegerList(), (Object)lMainInteger);
        test.setLink(this.createAliasTest());
        this.updateObject((XPSObject)test);
        IntegerListAliasTest.assertEquals((String)"After setLink, AliasToIntegerList must match with AliasedInteger", test.getAliasToIntegerList(), (Object)lAliasedInteger);
        test.clearLink();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)test);
        IntegerListAliasTest.assertEquals((String)"After ClearLink, AliasToIntegerList must match with MainInteger", test.getAliasToIntegerList(), (Object)lMainInteger);
    }

    @TestBase.STI(value=7)
    public void testIntegerListAliasToAliasLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(this.createAliasTest());
        com.ca.siteminder.sdk.adminapi.test.xps.Test test2 = this.createTest(test);
        IntegerListAliasTest.assertEquals((String)"AliasToAliasToIntegerList attribute must match with aliasedInteger", test2.getAliasToAliasToIntegerList(), (Object)lAliasedInteger);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IntegerListAliasTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IntegerListAliasTest.class);
    }
}

