/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.alias;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.alias.AliasBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class CircularAliasTest
extends AliasBase {
    protected static com.ca.siteminder.sdk.adminapi.test.xps.Test gMainTest;

    @TestBase.STI(value=1)
    public void testCircularAlias() throws XPSException {
        CircularAliasTest.assertTrue((String)"The CircularAliasToBoolean attribute must be true", (boolean)gMainTest.getCircularAliasToBoolean());
        CircularAliasTest.assertEquals((String)"The CircularAliasToInteger attribute value must be 100", (Object)gMainTest.getCircularAliasToInteger(), (Object)new Integer(100));
        CircularAliasTest.assertEquals((String)"The CircularAliasToString must have value \"Aliased circular string\"", (String)gMainTest.getCircularAliasToString(), (String)"Aliased circular string");
    }

    @TestBase.STI(value=2)
    public void testCircularAliasForward() throws XPSException {
        gMainTest.setCircularAliasToBoolean(false);
        gMainTest.setCircularAliasToInteger(1000);
        gMainTest.setCircularAliasToString("Testing");
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        CircularAliasTest.assertFalse((String)"The CircularBoolean attribute must be false", (boolean)test.getCircularBoolean());
        CircularAliasTest.assertEquals((String)"The attribute CircularInteger must have value 1000", (Object)test.getCircularInteger(), (Object)new Integer(1000));
        CircularAliasTest.assertEquals((String)"The attribute CircularString must have value \"Testing\"", (String)test.getCircularString(), (String)"Testing");
    }

    @TestBase.STI(value=3)
    public void testCircularAliasBackward() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.setCircularBoolean(false);
        test.setCircularInteger(2000);
        test.setCircularString("circular string");
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        CircularAliasTest.assertFalse((String)"The attribute CircularAliasToBoolean must be false ", (boolean)gMainTest.getCircularAliasToBoolean());
        CircularAliasTest.assertEquals((String)"The attribute CircularAliasToInteger must have value 1000", (Object)gMainTest.getCircularAliasToInteger(), (Object)new Integer(2000));
        CircularAliasTest.assertEquals((String)"The attribute CircularAliasToString must have value \"circular string\"", (String)gMainTest.getCircularAliasToString(), (String)"circular string");
    }

    @TestBase.STI(value=4)
    public void testCircularAliasCleared() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.clearCircularBoolean();
        test.clearCircularInteger();
        test.clearCircularString();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        CircularAliasTest.assertNull((String)"The attribute CircularAliasToBoolean is not cleared", (Object)gMainTest.getCircularAliasToBoolean());
        CircularAliasTest.assertNull((String)"The attribute CircularAliasToInteger is not cleared", (Object)gMainTest.getCircularAliasToInteger());
        CircularAliasTest.assertNull((String)"The attribute CircularAliasToString is not cleared", (Object)gMainTest.getCircularAliasToString());
    }

    @TestBase.STI(value=5)
    public void testCircularMainCleared() throws XPSException {
        gMainTest.clearCircularAliasToBoolean();
        gMainTest.clearCircularAliasToInteger();
        gMainTest.clearCircularAliasToString();
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        CircularAliasTest.assertNull((String)"The attribute CircularBoolean is not cleared", (Object)test.getCircularBoolean());
        CircularAliasTest.assertNull((String)"The attribute CircularInteger is not cleared", (Object)test.getCircularInteger());
        CircularAliasTest.assertNull((String)"The attribute CircularString is not cleared", (Object)test.getCircularString());
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)CircularAliasTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(CircularAliasTest.class);
    }

    @Override
    public void setUpSuite() {
        gMainTest = this.createTest(this.createAliasTest());
        this.updateAlias();
    }

    @Override
    protected com.ca.siteminder.sdk.adminapi.test.xps.Test createAliasTest() {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = (com.ca.siteminder.sdk.adminapi.test.xps.Test)SetupConnection.policyData.newObject(com.ca.siteminder.sdk.adminapi.test.xps.Test.ddclass);
        test.setCircularBoolean(true);
        test.setCircularInteger(100);
        test.setCircularString("Aliased circular string");
        test.setCircularAliasToBoolean(true);
        test.setCircularAliasToInteger(400);
        test.setCircularAliasToString("Aliased2 circular string");
        this.createObject((XPSObject)test);
        return test;
    }

    @Override
    protected com.ca.siteminder.sdk.adminapi.test.xps.Test createTest(com.ca.siteminder.sdk.adminapi.test.xps.Test test) {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test2 = (com.ca.siteminder.sdk.adminapi.test.xps.Test)SetupConnection.policyData.newObject(com.ca.siteminder.sdk.adminapi.test.xps.Test.ddclass);
        test2.setCircularAliasToBoolean(false);
        test2.setCircularAliasToInteger(200);
        test2.setCircularAliasToString("Main circular string");
        test.setCircularBoolean(false);
        test.setCircularInteger(300);
        test.setCircularString("Main2 circular string");
        test2.setLink(test);
        this.createObject((XPSObject)test2);
        return test2;
    }

    private com.ca.siteminder.sdk.adminapi.test.xps.Test updateAlias() {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        this.updateObject((XPSObject)test);
        return test;
    }
}

