/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest;

import com.ca.siteminder.sdk.adminapi.ConnectionHelper;
import com.ca.siteminder.sdk.adminapi.Directory;
import com.ca.siteminder.sdk.adminapi.SearchOptions;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Admin;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.ODBCQuery;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.ca.xps.Grant;
import com.ca.siteminder.sdk.adminapi.ca.xps.SecurityCategory;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.security.SecuritySetup;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import netegrity.siteminder.javaagent.AgentAPI;

public class TestBaseDMS
extends TestBase {
    protected static String strUDNamespace = null;
    protected static String udName = null;
    protected static String userSearchName = null;
    protected static final String origUserPwd = "OrigPassword11";
    protected static final String newUserPwd = "NewPassword11";
    protected static final String userPwdName = "DMSTestUserPwd";
    protected static final String userDisabledName = "DMSTestUserDisabled";
    protected static final String userGroupName = "DMSTestUserInGroup";
    static final int count = 4;
    static final String adminPrefix = "smadmin";
    static final String domainPrefix = "TestDomain";
    static final String adminName = "smadmin4";
    static final String adminPwd = "firewall";
    static final String domainName = "TestDomain4";
    protected static String fullUserPwdDN = null;
    protected static String fullUserDsbDN = null;
    protected static String fullUserGrpDN = null;
    protected static String fullUserSrcDN = null;
    protected static String strUDXID = null;
    protected static String uid = null;
    protected static String disabledAttr = null;
    protected static String pwdAttr = null;
    protected static String pwdDataAttr = null;
    public static UserDirectory userDirectory = null;
    public static Directory dir = null;
    public static SearchOptions searchOptions = null;
    public static String desc = "XXXX";

    protected void checkAndCreateUserDirIfNeeded(String string, Map<String, String> map) throws XPSException {
        if (dir != null) {
            return;
        }
        searchOptions = new SearchOptions();
        searchOptions.setResolution(1);
        searchOptions.setEscape(false);
        searchOptions.setSearchResults(100);
        searchOptions.setSearchRoot(this.getSearchRoot());
        try {
            userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (userDirectory != null && userDirectory.getNamespace().equals(strUDNamespace)) {
            strUDXID = userDirectory.getXid();
        } else if (string != null) {
            uid = map.get("USERDIR_UID_ATTR");
            disabledAttr = map.get("USERDIR_DISABLED_ATTR");
            pwdAttr = map.get("USERDIR_PWD_ATTR");
            pwdDataAttr = map.get("USERDIR_PWD_DATA_ATTR");
            userDirectory = (UserDirectory)SetupConnection.policyData.newObject((IClass)UserDirectory.ddclass);
            userDirectory.setServer(this.getUserDirectoryPath());
            userDirectory.setName(string);
            userDirectory.setDesc("XPSAPI JUnit Sample UserDirectory");
            userDirectory.setNamespace(strUDNamespace);
            userDirectory.setUniversalIDAttribute(uid);
            userDirectory.setDisabledAttribute(disabledAttr);
            userDirectory.setPasswordAttribute(pwdAttr);
            userDirectory.setBlobAttribute(pwdDataAttr);
            if (strUDNamespace.equals("ODBC:")) {
                uid = map.get("USERDIR_NAME_ATTR");
                userDirectory.setUniversalIDAttribute(uid);
                ODBCQuery oDBCQuery = (ODBCQuery)SetupConnection.policyData.newObject((IClass)ODBCQuery.ddclass);
                oDBCQuery.setName(string + "_query");
                oDBCQuery.setDesc("XPSAPI JUnit Sample Query Scheme");
                SetupConnection.createObject((XPSObject)oDBCQuery);
                userDirectory.setODBCQuery(oDBCQuery);
            } else if (strUDNamespace.equals("LDAP:") || strUDNamespace.equals("AD:")) {
                userDirectory.setSearchRoot(this.getSearchRoot());
                userDirectory.setSearchResults(Integer.valueOf(0));
                userDirectory.setSearchScope(UserDirectory.SearchScope.SubTree);
                userDirectory.setSearchTimeout(Integer.valueOf(30));
                userDirectory.setUserLookupStart(map.get("LDAP_USER_LOOKUP_START"));
                userDirectory.setUserLookupEnd(map.get("LDAP_USER_LOOKUP_END"));
            }
            if (map.get("USERDIR_CREDENTIALS_USERNAME") != null && map.get("USERDIR_CREDENTIALS_PASSWORD") != null) {
                userDirectory.setUsername(map.get("USERDIR_CREDENTIALS_USERNAME"));
                userDirectory.setPassword(map.get("USERDIR_CREDENTIALS_PASSWORD"));
                userDirectory.setRequireCredentials(Boolean.valueOf(true));
            } else {
                userDirectory.setRequireCredentials(Boolean.valueOf(false));
            }
            userDirectory.setSecureConnection(Boolean.valueOf(false));
            userDirectory.setEnableSecurityContext(Boolean.valueOf(false));
            SetupConnection.createObject((XPSObject)userDirectory);
            strUDXID = userDirectory.getXid();
        }
        try {
            dir = SetupConnection.getDirectoryManager().getDirectory(strUDXID);
        }
        catch (Exception exception) {
            throw new XPSException(exception.getMessage());
        }
        if (dir == null) {
            throw new XPSException("Cannot create user directory");
        }
    }

    protected static void createNewAdmin(Session session, String string, Set<Admin.Rights> set, EnumSet<Administrator.Flags> enumSet, Integer n) {
        SecurityCategory securityCategory;
        session.begin();
        Administrator administrator = (Administrator)session.getPolicyData().newObject((IClass)Administrator.ddclass);
        String string2 = SecuritySetup.getLegacyNamespace() + adminName;
        administrator.setName(string2);
        administrator.setUserPath(string2);
        administrator.setDescription(desc);
        administrator.setFlags(enumSet);
        EnumSet<Administrator.MethodsAllowed> enumSet2 = EnumSet.of(Administrator.MethodsAllowed.RemoteAPI, Administrator.MethodsAllowed.LocalAPI);
        administrator.setMethodsAllowed(enumSet2);
        session.getPolicyData().createObject((XPSObject)administrator);
        if (string != null) {
            securityCategory = (SecurityCategory)session.getPolicyData().fetchObject(string);
            Grant grant = (Grant)session.getPolicyData().newObject((IClass)Grant.ddclass);
            grant.setParent(administrator);
            int n2 = n == null ? 0x200000 : n;
            grant.setRightsMask(Integer.valueOf(n2));
            grant.setSecurityCategory(securityCategory);
            if (securityCategory.getScopingClass() != null) {
                Domain domain = (Domain)session.getPolicyData().newObject((IClass)Domain.ddclass);
                domain.setName(domainName);
                domain.setDesc(desc);
                session.getPolicyData().createObject((XPSObject)domain);
                ArrayList<Domain> arrayList = new ArrayList<Domain>();
                arrayList.add(domain);
                grant.setScope(arrayList);
            }
            session.getPolicyData().createObject((XPSObject)grant);
        }
        session.commit();
        session.begin();
        securityCategory = (Admin)session.getPolicyData().newObject((IClass)Admin.ddclass);
        securityCategory.setName(adminName);
        securityCategory.setPassword(adminPwd);
        securityCategory.setDesc(desc);
        securityCategory.setRights(set);
        session.getPolicyData().createObject((XPSObject)securityCategory);
        session.commit();
    }

    protected static String getSpec(Session session) {
        AgentAPI agentAPI = session.getConnection();
        ConnectionHelper connectionHelper = new ConnectionHelper();
        connectionHelper.agentapi = agentAPI;
        String string = connectionHelper.PMAPI_login(adminName, adminPwd);
        return string;
    }

    protected static Session login(Session session, String string) {
        AgentAPI agentAPI = session.getConnection();
        Session session2 = new Session();
        session2.setConnection(agentAPI);
        session2.setSessionTicket(string);
        session2.connect();
        return session2;
    }

    protected static void clean(IClass<? extends XPSObject> iClass, Session session) {
        IAttribute iAttribute = iClass.getAttribute("Desc");
        if (iAttribute == null) {
            iAttribute = iClass.getAttribute("Description");
        }
        Filter filter = new Filter(iAttribute, Clause.Operator.BEGINSWITH, (Object)desc);
        List list = session.getPolicyData().search(iClass, filter, false);
        for (XPSObject xPSObject : list) {
            session.getPolicyData().deleteObject(xPSObject);
        }
    }

    protected static void breakdown(Session session) {
        session.begin();
        TestBaseDMS.clean((IClass<? extends XPSObject>)Domain.ddclass, session);
        TestBaseDMS.clean((IClass<? extends XPSObject>)Admin.ddclass, session);
        TestBaseDMS.clean((IClass<? extends XPSObject>)Administrator.ddclass, session);
        session.commit();
    }

    @Override
    public void setUpSuite() {
        strUDNamespace = SetupConnection.properties.get("USERDIR_NAMESPACE");
        if (strUDNamespace == null || strUDNamespace.isEmpty()) {
            throw new XPSException("Can not get property USERDIR_NAMESPACE");
        }
        udName = "DirManagerUD" + System.currentTimeMillis() + strUDNamespace;
        userSearchName = this.GetSearchUserName();
        this.checkAndCreateUserDirIfNeeded(udName, SetupConnection.properties);
        fullUserPwdDN = this.CreateUserPath(userPwdName);
        fullUserDsbDN = this.CreateUserPath(userDisabledName);
        fullUserGrpDN = this.CreateUserPath(userGroupName);
        fullUserSrcDN = this.CreateUserPath(userSearchName);
    }

    protected String getUserDirectoryPath() {
        String string = null;
        if (strUDNamespace.contains("LDAP:") || strUDNamespace.contains("AD:")) {
            string = SetupConnection.properties.get("LDAP_USER_STORE_SERVER");
        } else if (strUDNamespace.contains("ODBC:")) {
            string = SetupConnection.properties.get("ODBC_USER_STORE_SERVER");
        } else {
            throw new XPSException("Not supported namespace: " + strUDNamespace);
        }
        if (string == null || string.isEmpty()) {
            throw new XPSException("Can not read LDAP_USER_STORE_SERVER/ODBC_USER_STORE_SERVER");
        }
        return string;
    }

    protected String getUniversalIDAttr() {
        if (uid == null || uid.isEmpty()) {
            throw new XPSException("USERDIR_UID_ATTR");
        }
        return uid;
    }

    protected String getSearchRoot() {
        if (strUDNamespace.contains("LDAP:") || strUDNamespace.contains("AD:")) {
            String string = SetupConnection.properties.get("LDAP_SEARCH_ROOT");
            if (string == null || string.isEmpty()) {
                throw new XPSException("Can not read LDAP_SEARCH_ROOT");
            }
            return string;
        }
        return null;
    }

    protected String CreateUserPath(String string) {
        if (string.isEmpty()) {
            throw new XPSException("Cannot get property LDAP_GROUP_NAME1");
        }
        String string2 = null;
        if (strUDNamespace.equals("LDAP:") || strUDNamespace.equals("AD:")) {
            String string3 = SetupConnection.properties.get("LDAP_GROUP_NAME1");
            if (string3 == null || string3.isEmpty()) {
                throw new XPSException("Cannot get property LDAP_GROUP_NAME1");
            }
            String string4 = SetupConnection.properties.get("LDAP_GROUP_SEARCH_ATTR1");
            if (string4 == null || string4.isEmpty()) {
                throw new XPSException("Cannot get property LDAP_GROUP_SEARCH_ATTR1");
            }
            String string5 = this.getSearchRoot();
            string2 = uid + "=" + string + "," + string4 + "=" + string3 + "," + string5;
        } else {
            string2 = string;
        }
        return string2;
    }

    protected String GetSearchUserName() {
        String string = null;
        if (strUDNamespace.equals("LDAP:") || strUDNamespace.equals("AD:")) {
            string = SetupConnection.properties.get("LDAP_USERNAME4");
        } else if (strUDNamespace.equals("ODBC:")) {
            string = SetupConnection.properties.get("ODBC_USERNAME4");
        }
        return string;
    }

    protected String parseDN(String string) {
        if (strUDNamespace.equalsIgnoreCase("ODBC:")) {
            return string;
        }
        String string2 = string.toLowerCase();
        int n = string2.indexOf("=") + 1;
        if (n < 0) {
            return string2;
        }
        String[] stringArray = new String[]{"dc=", "cn=", "ou="};
        int n2 = string2.length();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            int n3 = string2.indexOf(stringArray[i], n);
            if (n3 >= n2 || n3 <= 0) continue;
            n2 = n3;
            if ((n3 = string2.lastIndexOf(44, n3)) <= n) continue;
            n2 = n3;
        }
        return string2.substring(n, n2);
    }
}

