/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest;

import com.ca.siteminder.rpc.output.PrintFormatter;
import com.ca.siteminder.rpc.type.Formatter;
import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.RpcRegistry;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapitest.AssertionSkip;
import com.ca.siteminder.sdk.adminapitest.STIUtil;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public abstract class TestBase
extends TestCase {
    static PrintFormatter formatter = new PrintFormatter((OutputStream)System.out).structured();
    private static int MAX_INDEX = 100;

    public static void format(Object object) {
        RpcRegistry rpcRegistry = RpcRegistry.get();
        rpcRegistry.format((Formatter)formatter, object);
        formatter.flush();
    }

    public static void println(String string) {
        System.out.println(string);
        System.out.flush();
    }

    protected void failCreate(XPSObject xPSObject, String string) {
        STIUtil.failCreate(SetupConnection.policyData, xPSObject, string);
    }

    protected void failUpdate(XPSObject xPSObject, String string) {
        STIUtil.failUpdate(SetupConnection.policyData, xPSObject, string);
    }

    protected void failDelete(XPSObject xPSObject, String string) {
        STIUtil.failDelete(SetupConnection.policyData, xPSObject, string);
    }

    protected void checkDeletion(XPSObject xPSObject) {
        String string = xPSObject.getXid();
        InternalTesting.Server_xpsrefresh(SetupConnection.session);
        XPSObject xPSObject2 = SetupConnection.policyData.fetchObject(string, true);
        TestBase.assertNull((String)"checkDeletion - policyData.fetchObject must return null", (Object)xPSObject2);
    }

    protected void checkObject(XPSObject xPSObject) {
        String string = xPSObject.getXid();
        InternalTesting.Server_xpsrefresh(SetupConnection.session);
        XPSObject xPSObject2 = InternalTesting.fetchIgnoreCache(string, SetupConnection.session);
        TestBase.assertNotNull((String)"checkObject - fetchIgnoreCache() should not return null", (Object)xPSObject2);
        InternalTesting.assertEqualAttributes(xPSObject2, xPSObject);
    }

    protected void createObject(XPSObject xPSObject) {
        SetupConnection.createObject(xPSObject);
        this.checkObject(xPSObject);
    }

    protected void updateObject(XPSObject xPSObject) {
        SetupConnection.updateObject(xPSObject);
        this.checkObject(xPSObject);
    }

    protected void deleteObject(XPSObject xPSObject) {
        SetupConnection.deleteObject(xPSObject);
        this.checkDeletion(xPSObject);
    }

    protected static void buildSuite(Class<? extends TestCase> clazz, TestSuite testSuite) {
        STI sTI;
        Method[] methodArray = clazz.getMethods();
        String[] stringArray = new String[MAX_INDEX + 1];
        int n = 0;
        for (Method object : methodArray) {
            sTI = object.getAnnotation(STI.class);
            if (sTI == null) continue;
            String string = object.getName();
            if (object.getReturnType() != Void.TYPE) {
                SetupConnection.println(string + ": not a test: wrong signature");
                ++n;
                continue;
            }
            if (object.getParameterTypes().length != 0) {
                SetupConnection.println(string + ": not a test: wrong signature");
                ++n;
                continue;
            }
            int n2 = sTI.value();
            if (n2 < 1 || n2 > MAX_INDEX) {
                SetupConnection.format("STI(%d): index should be between 1 and %d\n", n2, MAX_INDEX);
                ++n;
                continue;
            }
            if (stringArray[n2] != null) {
                SetupConnection.format("STI(%d): repeated index\n", n2);
                ++n;
                continue;
            }
            stringArray[n2] = string;
        }
        if (n > 0) {
            throw new RuntimeException("errors in indexing tests");
        }
        for (String string : stringArray) {
            if (string == null) continue;
            try {
                sTI = clazz.newInstance();
                sTI.setName(string);
                testSuite.addTest((Test)sTI);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static void assertContains(String string, String string2) {
        if (string2 != null) {
            TestBase.assertNotNull((String)"message is null", (Object)string);
            if (!string.contains(string2)) {
                TestBase.fail((String)(string + " contains " + string2));
            }
        }
    }

    protected static void assertNotContains(String string, String string2) {
        if (string2 != null) {
            TestBase.assertNotNull((String)"message is null", (Object)string);
            if (string.contains(string2)) {
                TestBase.fail((String)(string + " not contains " + string2));
            }
        }
    }

    protected static void assertSize(String string, Collection<?> collection, int n) {
        int n2;
        int n3 = n2 = collection == null ? 0 : collection.size();
        if (n2 != n) {
            TestBase.fail((String)(string + " size: expected: " + n + ", actual: " + n2));
        }
    }

    public void setUpSuite() {
    }

    public void tearDownSuite() {
    }

    public static void skip(String string) {
        throw new AssertionSkip(string);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface STI {
        public int value();
    }
}

