/*
 * Decompiled with CFR 0.152.
 */
package com.coreblox.corebloxcrypto;

import com.coreblox.corebloxcrypto.Decrypter;
import com.coreblox.corebloxcrypto.SessionParametersInterface;
import com.coreblox.corebloxcrypto.SpringAwareObject;
import java.io.File;
import java.io.IOException;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public enum Encrypter {
    INSTANCE;


    public String encryptString(String plaintext, boolean useSinglePassword, boolean useFileEncryption, String globalPassword, String originalPassword) throws Exception {
        if (useFileEncryption && !Decrypter.INSTANCE.isEncryptedValue(plaintext)) {
            StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
            encryptor.setProviderName("BC");
            if (Security.getProvider("BC") == null) {
                System.out.println("Bouncy Castle provider is NOT available");
            } else {
                System.out.println("Bouncy Castle provider is available");
                encryptor.setProvider(Security.getProvider("BC"));
            }
            if (useSinglePassword && !globalPassword.isEmpty()) {
                this.updatePassword(globalPassword, encryptor);
            } else if (originalPassword.isEmpty()) {
                SessionParametersInterface sp = SpringAwareObject.getSessionParameters();
                if (sp == null || sp.getPassword() == null) {
                    throw new Exception("Empty Password");
                }
                this.updatePassword(sp.getPassword(), encryptor);
            } else {
                this.updatePassword(originalPassword, encryptor);
            }
            this.updateAlg("PBEWITHSHA256AND256BITAES-CBC-BC", encryptor);
            String encryptedString = PropertyValueEncryptionUtils.encrypt((String)plaintext, (StringEncryptor)encryptor);
            return encryptedString;
        }
        return plaintext;
    }

    public String encryptString(String plaintext, String key) {
        if (!Decrypter.INSTANCE.isEncryptedValue(plaintext)) {
            StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
            encryptor.setProviderName("BC");
            if (Security.getProvider("BC") == null) {
                Logger.getLogger(Encrypter.class.getName()).log(Level.INFO, "Bouncy Castle provider is not available");
            } else {
                Logger.getLogger(Encrypter.class.getName()).log(Level.INFO, "Bouncy Castle provider is available");
                encryptor.setProvider(Security.getProvider("BC"));
            }
            this.updatePassword(key, encryptor);
            this.updateAlg("PBEWITHSHA256AND256BITAES-CBC-BC", encryptor);
            String encryptedString = PropertyValueEncryptionUtils.encrypt((String)plaintext, (StringEncryptor)encryptor);
            return encryptedString;
        }
        Logger.getLogger(Encrypter.class.getName()).log(Level.INFO, "String value is already encrypted");
        return plaintext;
    }

    public void encryptFile(File plainFile, String key) throws IOException, Exception {
        String plainString = FileUtils.readFileToString((File)plainFile);
        String encryptedString = this.encryptString(plainString, key);
        FileUtils.writeStringToFile((File)plainFile, (String)encryptedString);
    }

    private void updatePassword(String password, StandardPBEStringEncryptor encryptor) {
        encryptor.setPassword(password);
        encryptor.setProviderName("BC");
        if (Security.getProvider("BC") == null) {
            Logger.getLogger(Encrypter.class.getName()).log(Level.INFO, "Bouncy Castle provider is NOT available");
        } else {
            Logger.getLogger(Encrypter.class.getName()).log(Level.INFO, "Bouncy Castle provider is available");
            encryptor.setProvider(Security.getProvider("BC"));
        }
    }

    private void updateAlg(String alg, StandardPBEStringEncryptor encryptor) {
        encryptor.setProviderName("BC");
        if (Security.getProvider("BC") == null) {
            Logger.getLogger(Encrypter.class.getName()).log(Level.INFO, "Bouncy Castle provider is NOT available");
        } else {
            Logger.getLogger(Encrypter.class.getName()).log(Level.INFO, "Bouncy Castle provider is available");
            encryptor.setProvider(Security.getProvider("BC"));
        }
        encryptor.setAlgorithm(alg);
    }
}

