/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.filter;

import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Expression;
import com.ca.siteminder.sdk.adminapi.filter.LogicalOp;

public class Filter {
    private Expression expression;

    public Filter(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.expression = expression;
    }

    public Filter(Filter filter) {
        this.expression = filter.expression;
    }

    public Filter(IAttribute iAttribute, Clause.Operator operator, Object object) {
        this(iAttribute, operator, object, false);
    }

    public Filter(IAttribute iAttribute, Clause.Operator operator, Object object, boolean bl) {
        this.expression = new Clause(iAttribute, operator, object, bl);
    }

    public void OR(Filter filter) {
        this.expression = this.apply(filter, LogicalOp.Operator.OR);
    }

    public void ORNOT(Filter filter) {
        this.expression = this.apply(Filter.not(filter), LogicalOp.Operator.OR);
    }

    public void AND(Filter filter) {
        this.expression = this.apply(filter, LogicalOp.Operator.AND);
    }

    public void ANDNOT(Filter filter) {
        this.expression = this.apply(Filter.not(filter), LogicalOp.Operator.AND);
    }

    public void NOT() {
        this.expression = this.expression.negate();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public static Filter and(Filter filter, Filter filter2) {
        return new Filter(filter.apply(filter2, LogicalOp.Operator.AND));
    }

    public static Filter or(Filter filter, Filter filter2) {
        return new Filter(filter.apply(filter2, LogicalOp.Operator.OR));
    }

    public static Filter not(Filter filter) {
        return new Filter(filter.expression.negate());
    }

    public String toString() {
        return this.expression.toString();
    }

    LogicalOp apply(Filter filter, LogicalOp.Operator operator) {
        return new LogicalOp(this.expression, filter.expression, operator);
    }
}

