/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.dd;

import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.dd.DDAttribute;
import com.ca.siteminder.sdk.adminapi.dd.DDProduct;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDClass<T extends XPSObject>
implements IClass<T> {
    DDClass<? extends XPSObject> baseClass;
    DDClass<? extends XPSObject> parentClass;
    boolean isExtension;
    Class<T> javaClass;
    Set<DDClass> extensions;
    String fqname;
    private List<DDAttribute> attrList = new ArrayList<DDAttribute>();
    Map<String, DDAttribute> attrMap = new HashMap<String, DDAttribute>();

    @Override
    public List<DDAttribute> getAttributes() {
        return this.attrList;
    }

    @Override
    public boolean isExtension() {
        return this.isExtension;
    }

    @Override
    public DDClass getBaseClass() {
        return this.isExtension ? this.baseClass : null;
    }

    @Override
    public DDClass getParentClass() {
        return this.isExtension ? this.baseClass.getParentClass() : this.parentClass;
    }

    @Override
    public Class<T> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public Class<? extends XPSObject> getDynamicJavaClass() {
        return this.javaClass;
    }

    void addExtension(DDClass dDClass) {
        if (this.extensions == null) {
            this.extensions = new HashSet<DDClass>();
        }
        this.extensions.add(dDClass);
    }

    void addAttribute(DDAttribute dDAttribute) {
        this.attrList.add(dDAttribute);
        if (this.baseClass != null) {
            this.baseClass.attrMap.put(dDAttribute.getFQName(), dDAttribute);
        } else {
            this.attrMap.put(dDAttribute.getShortName(), dDAttribute);
            this.attrMap.put(dDAttribute.getFQName(), dDAttribute);
        }
    }

    @Override
    public String getFQName() {
        return this.fqname;
    }

    @Override
    public String getName() {
        int n = this.fqname.lastIndexOf("::");
        return this.fqname.substring(n + 2);
    }

    public DDClass(Class<T> clazz, DDClass<? extends XPSObject> dDClass, String string) {
        this(clazz, dDClass, string, false);
    }

    public DDClass(Class<T> clazz, DDClass<? extends XPSObject> dDClass, String string, boolean bl) {
        this.fqname = string;
        this.javaClass = clazz;
        this.isExtension = bl;
        if (dDClass != null) {
            DDClass<? extends XPSObject> dDClass2 = dDClass;
            if (bl) {
                this.baseClass = dDClass2;
                this.baseClass.addExtension(this);
            } else {
                this.parentClass = dDClass2;
            }
        }
    }

    @Override
    public DDAttribute getAttribute(String string) {
        DDAttribute dDAttribute = this.attrMap.get(string);
        if (dDAttribute == null && this.isExtension) {
            dDAttribute = this.baseClass.getAttribute(string);
        }
        return dDAttribute;
    }

    public static String classNameOfXid(String string) {
        int n = string.lastIndexOf(64);
        if (n < 0) {
            throw new XPSException("bad xid: " + string);
        }
        return string.substring(0, n);
    }

    public void print(PrintWriter printWriter) {
        printWriter.println(this.fqname);
        for (DDAttribute dDAttribute : this.attrList) {
            dDAttribute.print(printWriter);
        }
        printWriter.flush();
    }

    @Override
    public DDProduct getProduct() {
        return null;
    }
}

