/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.ca.xps;

import com.ca.siteminder.sdk.adminapi.BaseObject;
import com.ca.siteminder.sdk.adminapi.XPSObjectImpl;
import com.ca.siteminder.sdk.adminapi.ca.xps.Bit;
import com.ca.siteminder.sdk.adminapi.ca.xps.Class;
import com.ca.siteminder.sdk.adminapi.dd.DDAttribute;
import com.ca.siteminder.sdk.adminapi.dd.DDClass;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.ValuedEnum;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
extends BaseObject
implements IAttribute {
    Class parent;
    public static final DDClass<Attribute> ddclass = new DDClass<Attribute>(Attribute.class, Class.ddclass, "CA.XPS::Attribute");
    List<Bit> bits;
    public static final DDAttribute<String> NAME = new DDAttribute(ddclass, "Name", 1, 1, IAttribute.DataType.String);
    public static final DDAttribute<Integer> MINELEMENTS = new DDAttribute(ddclass, "MinElements", IAttribute.DataType.Integer);
    public static final DDAttribute<Integer> MAXELEMENTS = new DDAttribute(ddclass, "MaxElements", IAttribute.DataType.Integer);
    public static final DDAttribute<Integer> HANDLING = new DDAttribute(ddclass, "Handling", IAttribute.DataType.Integer);
    public static final DDAttribute<Integer> DATATYPES = new DDAttribute(ddclass, "DataType", IAttribute.DataType.Integer);
    public static final DDAttribute<Boolean> ISCALCULATED = new DDAttribute(ddclass, "IsCalculated", 0, 1, IAttribute.DataType.Boolean);
    public static final DDAttribute<Integer> APIACCESS = new DDAttribute(ddclass, "APIAccess", IAttribute.DataType.Integer);
    public static final DDAttribute<Class> LINKTOCLASS = new DDAttribute(ddclass, "LinkToClass", 0, 1, IAttribute.DataType.Link);
    public static final DDAttribute<Integer> REFERENCESCOPE = new DDAttribute(ddclass, "ReferenceScope", 0, 1, IAttribute.DataType.Integer, IAttribute.Handling.Enumeration, IAttribute.APIAccess.ReadOnly);
    public static final DDAttribute<Boolean> OBSOLETE = new DDAttribute(ddclass, "Obsolete", 0, 1, IAttribute.DataType.Boolean, IAttribute.Handling.Value, IAttribute.APIAccess.ReadOnly);
    public static final DDAttribute<String> ERRORMAPPING = new DDAttribute(ddclass, "ErrorMapping", 0, 0, IAttribute.DataType.String, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<Integer> GRANULAROPTION = new DDAttribute(ddclass, "GranularOption", 1, 1, IAttribute.DataType.Integer, IAttribute.Handling.Enumeration, IAttribute.APIAccess.All);
    public static final DDAttribute<Integer> LINKINTEGRITY = new DDAttribute(ddclass, "LinkIntegrity", 1, 1, IAttribute.DataType.Integer, IAttribute.Handling.Enumeration, IAttribute.APIAccess.All);
    public static final DDAttribute<Integer> UNIQUENESS = new DDAttribute(ddclass, "Uniqueness", 1, 1, IAttribute.DataType.Integer, IAttribute.Handling.Enumeration, IAttribute.APIAccess.All);
    public static final DDAttribute<Integer> LINKREFERENCE = new DDAttribute(ddclass, "LinkReference", 1, 1, IAttribute.DataType.Integer, IAttribute.Handling.Enumeration, IAttribute.APIAccess.All);
    public static final DDAttribute<Integer> VALUEREFERENCE = new DDAttribute(ddclass, "ValueReference", 1, 1, IAttribute.DataType.Integer, IAttribute.Handling.Enumeration, IAttribute.APIAccess.All);
    public static final DDAttribute<Boolean> ISAUDITED = new DDAttribute(ddclass, "IsAudited", 1, 1, IAttribute.DataType.Boolean, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<Integer> MAXLENGTH = new DDAttribute(ddclass, "MaxLength", 0, 1, IAttribute.DataType.Integer, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<String> DESCRIPTION = new DDAttribute(ddclass, "Description", 0, 1, IAttribute.DataType.String, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<String> ALIAS = new DDAttribute(ddclass, "Alias", 0, 1, IAttribute.DataType.String, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<Integer> CHARACTERCASE = new DDAttribute(ddclass, "CharacterCase", 0, 1, IAttribute.DataType.Integer, IAttribute.Handling.Enumeration, IAttribute.APIAccess.All);

    public Attribute(XPSObjectImpl xPSObjectImpl) {
        super(xPSObjectImpl);
    }

    public synchronized List<Bit> getBits() {
        if (this.bits == null) {
            this.bits = this.getChildren(Bit.ddclass);
        }
        return this.bits;
    }

    public synchronized void addBit(Bit bit) {
        if (this.bits == null) {
            this.bits = new ArrayList<Bit>();
        }
        this.bits.add(bit);
    }

    public synchronized Class getParent() {
        if (this.parent == null) {
            this.parent = this.impl.getParent(Class.class);
        }
        return this.parent;
    }

    @Override
    public String getName() {
        return (String)this.impl.getSingleProperty(NAME);
    }

    @Override
    public String getFQName() {
        return this.getParent().getFQName() + "." + this.getName();
    }

    @Override
    public String getAppropriateName() {
        Class clazz = this.getParent();
        if (clazz == clazz.metadataClass || clazz.baseClass != null) {
            return this.getFQName();
        }
        return this.getName();
    }

    @Override
    public int getMinElements() {
        Integer n = (Integer)this.impl.getSingleProperty(MINELEMENTS);
        return n != null ? n : 0;
    }

    @Override
    public int getMaxElements() {
        Integer n = (Integer)this.impl.getSingleProperty(MAXELEMENTS);
        return n != null ? n : 0;
    }

    @Override
    public boolean isOptional() {
        return this.getMinElements() == 0;
    }

    @Override
    public boolean isList() {
        return this.getMaxElements() != 1;
    }

    @Override
    public IAttribute.Handling getHandling() {
        return IAttribute.Handling.values()[this.impl.getIntProperty(HANDLING)];
    }

    @Override
    public IAttribute.DataType getDataType() {
        return IAttribute.DataType.values()[this.impl.getIntProperty(DATATYPES)];
    }

    @Override
    public boolean isCalculated() {
        return this.impl.getBooleanProperty(ISCALCULATED);
    }

    @Override
    public IAttribute.APIAccess getAPIAccess() {
        return IAttribute.APIAccess.values()[this.impl.getIntProperty(APIACCESS)];
    }

    @Override
    public Class getLinkToClass() {
        return this.impl.getLink(LINKTOCLASS, Class.class);
    }

    @Override
    public Class getAttributeClass() {
        return this.getParent();
    }

    public ReferenceScope getReferenceScope() {
        return ReferenceScope.values()[this.impl.getIntProperty(REFERENCESCOPE) - 0];
    }

    public boolean hasReferenceScope() {
        return this.impl.hasProp(REFERENCESCOPE);
    }

    public Boolean getObsolete() {
        return (Boolean)this.impl.getSingleProperty(OBSOLETE);
    }

    public boolean hasObsolete() {
        return this.impl.hasProp(OBSOLETE);
    }

    public List<String> getErrorMapping() {
        return this.impl.getListProperty(ERRORMAPPING);
    }

    public boolean hasErrorMapping() {
        return this.impl.hasProp(ERRORMAPPING);
    }

    public GranularOption getGranularOption() {
        return GranularOption.values()[this.impl.getIntProperty(GRANULAROPTION) - 0];
    }

    public LinkIntegrity getLinkIntegrity() {
        return LinkIntegrity.values()[this.impl.getIntProperty(LINKINTEGRITY) - 0];
    }

    public Uniqueness getUniqueness() {
        return Uniqueness.values()[this.impl.getIntProperty(UNIQUENESS) - 0];
    }

    public boolean hasUniqueness() {
        return this.impl.hasProp(UNIQUENESS);
    }

    public LinkReference getLinkReference() {
        return LinkReference.values()[this.impl.getIntProperty(LINKREFERENCE) - 0];
    }

    public boolean hasLinkReference() {
        return this.impl.hasProp(LINKREFERENCE);
    }

    public ValueReference getValueReference() {
        return ValueReference.values()[this.impl.getIntProperty(VALUEREFERENCE) - 0];
    }

    public Boolean getIsAudited() {
        return (Boolean)this.impl.getSingleProperty(ISAUDITED);
    }

    public boolean hasIsAudited() {
        return this.impl.hasProp(ISAUDITED);
    }

    public Integer getMaxLength() {
        return (Integer)this.impl.getSingleProperty(MAXLENGTH);
    }

    public boolean hasMaxLength() {
        return this.impl.hasProp(MAXLENGTH);
    }

    public String getDescription() {
        return (String)this.impl.getSingleProperty(DESCRIPTION);
    }

    public void setDescription(String string) {
        this.impl.setSingleProperty(DESCRIPTION, string);
    }

    public boolean hasDescription() {
        return this.impl.hasProp(DESCRIPTION);
    }

    public String getAlias() {
        return (String)this.impl.getSingleProperty(ALIAS);
    }

    public void setAlias(String string) {
        this.impl.setSingleProperty(ALIAS, string);
    }

    public boolean hasAlias() {
        return this.impl.hasProp(ALIAS);
    }

    public void clearAlias() {
        this.impl.clearProp(ALIAS);
    }

    public CharacterCase getCharacterCase() {
        return (CharacterCase)this.impl.getEnum(CHARACTERCASE, CharacterCase.values(), 0);
    }

    public void setCharacterCase(CharacterCase characterCase) {
        this.impl.setIntProperty(CHARACTERCASE, characterCase.ordinal() + 0);
    }

    public boolean hasCharacterCase() {
        return this.impl.hasProp(CHARACTERCASE);
    }

    public void clearCharacterCase() {
        this.impl.clearProp(CHARACTERCASE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharacterCase implements ValuedEnum
    {
        Mixed,
        Lower,
        Upper;


        @Override
        public int getValue() {
            return this.ordinal() + 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueReference {
        Never,
        URLRules,
        Always,
        Ask;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkReference {
        Never,
        Identity,
        Comment;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Uniqueness {
        No,
        WithinParent,
        WithinClass;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkIntegrity {
        Na,
        Restrict,
        Cascade,
        Undefine;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GranularOption {
        Always,
        Never,
        NeverToClass,
        NeverFromClass;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReferenceScope {
        Global,
        CommonAttribute,
        Private;

    }
}

