/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.ca.fed;

import com.ca.siteminder.sdk.adminapi.BaseObject;
import com.ca.siteminder.sdk.adminapi.XPSObjectImpl;
import com.ca.siteminder.sdk.adminapi.ca.fed.Certificate;
import com.ca.siteminder.sdk.adminapi.dd.DDAttribute;
import com.ca.siteminder.sdk.adminapi.dd.DDClass;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.ValuedEnum;

public class BackchannelConfig
extends BaseObject {
    public static final DDClass<BackchannelConfig> ddclass = new DDClass<BackchannelConfig>(BackchannelConfig.class, null, "CA.FED::BackchannelConfig", false);
    public static final DDAttribute<Integer> BACKCHANNELTIMEOUT = new DDAttribute(ddclass, "BackchannelTimeout", 0, 1, IAttribute.DataType.Integer, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<Integer> CHANNELTYPE = new DDAttribute(ddclass, "ChannelType", 0, 1, IAttribute.DataType.Integer, IAttribute.Handling.Enumeration, IAttribute.APIAccess.All);
    public static final DDAttribute<Certificate> CLIENTCERT = new DDAttribute(ddclass, "ClientCertLink", 0, 1, IAttribute.DataType.Link, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<String> PASSWORD = new DDAttribute(ddclass, "Password", 0, 1, IAttribute.DataType.String, IAttribute.Handling.Sensitive, IAttribute.APIAccess.All);
    public static final DDAttribute<String> USERNAME = new DDAttribute(ddclass, "UserName", 0, 1, IAttribute.DataType.String, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<Integer> AUTHTYPE = new DDAttribute(ddclass, "AuthType", 1, 1, IAttribute.DataType.Integer, IAttribute.Handling.Enumeration, IAttribute.APIAccess.All);

    public BackchannelConfig(XPSObjectImpl xPSObjectImpl) {
        super(xPSObjectImpl);
    }

    public BackchannelConfig duplicate() {
        return new BackchannelConfig(this.impl.copy());
    }

    public Integer getBackchannelTimeout() {
        return (Integer)this.impl.getSingleProperty(BACKCHANNELTIMEOUT);
    }

    public void setBackchannelTimeout(Integer n) {
        this.impl.setSingleProperty(BACKCHANNELTIMEOUT, n);
    }

    public boolean hasBackchannelTimeout() {
        return this.impl.hasProp(BACKCHANNELTIMEOUT);
    }

    public void clearBackchannelTimeout() {
        this.impl.clearProp(BACKCHANNELTIMEOUT);
    }

    public ChannelType getChannelType() {
        return (ChannelType)this.impl.getEnum(CHANNELTYPE, ChannelType.values(), 0);
    }

    public void setChannelType(ChannelType channelType) {
        this.impl.setIntProperty(CHANNELTYPE, channelType.ordinal() + 0);
    }

    public boolean hasChannelType() {
        return this.impl.hasProp(CHANNELTYPE);
    }

    public void clearChannelType() {
        this.impl.clearProp(CHANNELTYPE);
    }

    public Certificate getClientCert() {
        return this.impl.getLink(CLIENTCERT, Certificate.class);
    }

    public void setClientCert(Certificate certificate) {
        this.impl.setLink(CLIENTCERT, certificate);
    }

    public boolean hasClientCert() {
        return this.impl.hasProp(CLIENTCERT);
    }

    public void clearClientCert() {
        this.impl.clearProp(CLIENTCERT);
    }

    public String getPassword() {
        return (String)this.impl.getSingleProperty(PASSWORD);
    }

    public void setPassword(String string) {
        this.impl.setSingleProperty(PASSWORD, string);
    }

    public boolean hasPassword() {
        return this.impl.hasProp(PASSWORD);
    }

    public void clearPassword() {
        this.impl.clearProp(PASSWORD);
    }

    public String getUserName() {
        return (String)this.impl.getSingleProperty(USERNAME);
    }

    public void setUserName(String string) {
        this.impl.setSingleProperty(USERNAME, string);
    }

    public boolean hasUserName() {
        return this.impl.hasProp(USERNAME);
    }

    public void clearUserName() {
        this.impl.clearProp(USERNAME);
    }

    public AuthType getAuthType() {
        return (AuthType)this.impl.getEnum(AUTHTYPE, AuthType.values(), 0);
    }

    public void setAuthType(AuthType authType) {
        this.impl.setIntProperty(AUTHTYPE, authType.ordinal() + 0);
    }

    public boolean hasAuthType() {
        return this.impl.hasProp(AUTHTYPE);
    }

    public void clearAuthType() {
        this.impl.clearProp(AUTHTYPE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthType implements ValuedEnum
    {
        Basic,
        ClientCert,
        NoAuth;


        @Override
        public int getValue() {
            return this.ordinal() + 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChannelType implements ValuedEnum
    {
        Incoming,
        Outgoing;


        @Override
        public int getValue() {
            return this.ordinal() + 0;
        }
    }
}

