/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import com.ca.siteminder.sdk.adminapi.CacheUpdate;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CacheUpdater
extends Thread {
    private static final Logger logger = Logger.getLogger(CacheUpdater.class);
    private Session session;
    private Set<String> myModifiedObjects = new HashSet<String>();
    private Map<String, CacheUpdate> theirModifiedObjects = new HashMap<String, CacheUpdate>();
    private boolean done = false;
    private boolean isDisabled = false;
    private static int WAIT_TIME = 60000;

    synchronized void addMy(String string) {
        this.myModifiedObjects.add(string);
    }

    CacheUpdater(Session session) {
        this.session = session;
        this.setDaemon(true);
        this.setName("CacheUpdater");
    }

    public void run() {
        while (this.runOneRound()) {
        }
    }

    synchronized boolean runOneRound() {
        try {
            this.wait(WAIT_TIME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.done) {
            return false;
        }
        if (this.isDisabled) {
            return true;
        }
        List<CacheUpdate> list = null;
        try {
            list = this.session.service.getCacheUpdates();
        }
        catch (Exception exception) {
            this.isDisabled = true;
            return true;
        }
        for (CacheUpdate cacheUpdate : list) {
            this.theirModifiedObjects.put(cacheUpdate.getXid(), cacheUpdate);
        }
        if (!this.theirModifiedObjects.isEmpty() && !this.session.transactionInProgress) {
            this.processUpdate();
        }
        return true;
    }

    void enable() {
        this.isDisabled = false;
    }

    synchronized void stopIt() {
        this.done = true;
        this.notify();
    }

    void processUpdate() {
        for (CacheUpdate cacheUpdate : this.theirModifiedObjects.values()) {
            String string = cacheUpdate.getXid();
            logger.info((Object)string);
            if (this.myModifiedObjects.contains(string)) {
                this.myModifiedObjects.remove(string);
                continue;
            }
            XPSObject xPSObject = this.session.objectCache.get(string);
            if (xPSObject == null) continue;
            if (cacheUpdate.getOperation() == 4) {
                this.session.objectCache.remove(string);
                continue;
            }
            xPSObject.impl.turnIntoStub();
        }
        this.theirModifiedObjects.clear();
    }

    synchronized void reset() {
        this.myModifiedObjects.clear();
        this.theirModifiedObjects.clear();
    }
}

